/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineInfo;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import java.io.IOException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LineAppendable
extends Appendable,
Iterable<LineInfo> {
    public static final Options O_CONVERT_TABS = Options.CONVERT_TABS;
    public static final Options O_COLLAPSE_WHITESPACE = Options.COLLAPSE_WHITESPACE;
    public static final Options O_TRIM_TRAILING_WHITESPACE = Options.TRIM_TRAILING_WHITESPACE;
    public static final Options O_PASS_THROUGH = Options.PASS_THROUGH;
    public static final Options O_TRIM_LEADING_WHITESPACE = Options.TRIM_LEADING_WHITESPACE;
    public static final Options O_TRIM_LEADING_EOL = Options.TRIM_LEADING_EOL;
    public static final Options O_PREFIX_PRE_FORMATTED = Options.PREFIX_PRE_FORMATTED;
    public static final BitFieldSet<Options> O_FORMAT_ALL = BitFieldSet.of((Enum)O_CONVERT_TABS, (Enum)O_COLLAPSE_WHITESPACE, (Enum)O_TRIM_TRAILING_WHITESPACE, (Enum)O_TRIM_LEADING_WHITESPACE);
    public static final int F_CONVERT_TABS = BitFieldSet.intMask((Enum)O_CONVERT_TABS);
    public static final int F_COLLAPSE_WHITESPACE = BitFieldSet.intMask((Enum)O_COLLAPSE_WHITESPACE);
    public static final int F_TRIM_TRAILING_WHITESPACE = BitFieldSet.intMask((Enum)O_TRIM_TRAILING_WHITESPACE);
    public static final int F_PASS_THROUGH = BitFieldSet.intMask((Enum)O_PASS_THROUGH);
    public static final int F_TRIM_LEADING_WHITESPACE = BitFieldSet.intMask((Enum)O_TRIM_LEADING_WHITESPACE);
    public static final int F_TRIM_LEADING_EOL = BitFieldSet.intMask((Enum)O_TRIM_LEADING_EOL);
    public static final int F_PREFIX_PRE_FORMATTED = BitFieldSet.intMask((Enum)O_PREFIX_PRE_FORMATTED);
    public static final int F_FORMAT_ALL = F_CONVERT_TABS | F_COLLAPSE_WHITESPACE | F_TRIM_TRAILING_WHITESPACE | F_TRIM_LEADING_WHITESPACE | F_TRIM_LEADING_EOL;
    public static final int F_WHITESPACE_REMOVAL = F_COLLAPSE_WHITESPACE | F_TRIM_TRAILING_WHITESPACE | F_TRIM_LEADING_WHITESPACE;
    @Deprecated
    public static final int CONVERT_TABS = F_CONVERT_TABS;
    @Deprecated
    public static final int COLLAPSE_WHITESPACE = F_COLLAPSE_WHITESPACE;
    @Deprecated
    public static final int TRIM_TRAILING_WHITESPACE = F_TRIM_TRAILING_WHITESPACE;
    @Deprecated
    public static final int PASS_THROUGH = F_PASS_THROUGH;
    @Deprecated
    public static final int ALLOW_LEADING_WHITESPACE = 0;
    @Deprecated
    public static final int TRIM_LEADING_WHITESPACE = F_TRIM_LEADING_WHITESPACE;
    @Deprecated
    public static final int ALLOW_LEADING_EOL = 0;
    @Deprecated
    public static final int PREFIX_PRE_FORMATTED = F_PREFIX_PRE_FORMATTED;
    @Deprecated
    public static final int FORMAT_ALL = F_FORMAT_ALL;

    public static BitFieldSet<Options> toOptionSet(int options) {
        return BitFieldSet.of(Options.class, (long)options);
    }

    public static BitFieldSet<Options> toOptionSet(Options ... options) {
        return BitFieldSet.of(Options.class, (Enum[])options);
    }

    default public int getOptions() {
        return this.getOptionSet().toInt();
    }

    @NotNull
    public LineAppendable getEmptyAppendable();

    @NotNull
    default public LineAppendable copyAppendable(int startLine, int endLine, boolean withPrefixes) {
        return this.getEmptyAppendable().append(this, startLine, endLine, withPrefixes);
    }

    @NotNull
    default public LineAppendable copyAppendable(int startLine, int endLine) {
        return this.getEmptyAppendable().append(this, startLine, endLine, false);
    }

    @NotNull
    default public LineAppendable copyAppendable(int startLine) {
        return this.getEmptyAppendable().append(this, startLine, Integer.MAX_VALUE, false);
    }

    @NotNull
    default public LineAppendable copyAppendable() {
        return this.getEmptyAppendable().append(this, 0, Integer.MAX_VALUE, false);
    }

    @NotNull
    default public LineAppendable copyAppendable(boolean withPrefixes) {
        return this.getEmptyAppendable().append(this, 0, Integer.MAX_VALUE, withPrefixes);
    }

    @NotNull
    public BitFieldSet<Options> getOptionSet();

    @NotNull
    public LineAppendable pushOptions();

    @NotNull
    public LineAppendable popOptions();

    @NotNull
    default public LineAppendable noTrimLeading() {
        return this.changeOptions(0, F_TRIM_LEADING_WHITESPACE);
    }

    @NotNull
    default public LineAppendable trimLeading() {
        return this.changeOptions(F_TRIM_LEADING_WHITESPACE, 0);
    }

    @NotNull
    default public LineAppendable preserveSpaces() {
        return this.changeOptions(0, F_TRIM_LEADING_WHITESPACE | F_COLLAPSE_WHITESPACE);
    }

    @NotNull
    default public LineAppendable noPreserveSpaces() {
        return this.changeOptions(F_TRIM_LEADING_WHITESPACE | F_COLLAPSE_WHITESPACE, 0);
    }

    @NotNull
    default public LineAppendable removeOptions(int flags) {
        return this.changeOptions(0, flags);
    }

    @NotNull
    default public LineAppendable addOptions(int flags) {
        return this.changeOptions(flags, 0);
    }

    @NotNull
    public LineAppendable changeOptions(int var1, int var2);

    @NotNull
    default public LineAppendable setOptions(int flags) {
        return this.setOptions(LineAppendable.toOptionSet(flags));
    }

    @NotNull
    default public LineAppendable setOptions(Options ... options) {
        return this.setOptions(LineAppendable.toOptionSet(options).toInt());
    }

    @NotNull
    default public LineAppendable setOptions(BitFieldSet<Options> options) {
        return this.setOptions(options.toInt());
    }

    @NotNull
    public ISequenceBuilder<?, ?> getBuilder();

    public int getTrailingBlankLines(int var1);

    default public int getTrailingBlankLines() {
        return this.getTrailingBlankLines(this.getLineCountWithPending());
    }

    public boolean endsWithEOL();

    @Override
    @NotNull
    public LineAppendable append(@NotNull CharSequence var1);

    @Override
    @NotNull
    public LineAppendable append(@NotNull CharSequence var1, int var2, int var3);

    @Override
    @NotNull
    public LineAppendable append(char var1);

    @NotNull
    public LineAppendable append(char var1, int var2);

    @NotNull
    default public LineAppendable appendAll(@NotNull Iterable<CharSequence> sequences) {
        for (CharSequence sequence : sequences) {
            this.append(sequence);
        }
        return this;
    }

    @NotNull
    public LineAppendable append(@NotNull LineAppendable var1, int var2, int var3, boolean var4);

    @NotNull
    default public LineAppendable append(@NotNull LineAppendable lineAppendable) {
        return this.append(lineAppendable, 0, Integer.MAX_VALUE, true);
    }

    @NotNull
    default public LineAppendable append(@NotNull LineAppendable lineAppendable, boolean withPrefixes) {
        return this.append(lineAppendable, 0, Integer.MAX_VALUE, withPrefixes);
    }

    @NotNull
    public LineAppendable line();

    @NotNull
    public LineAppendable lineWithTrailingSpaces(int var1);

    @NotNull
    public LineAppendable lineIf(boolean var1);

    @NotNull
    public LineAppendable blankLine();

    @NotNull
    public LineAppendable blankLineIf(boolean var1);

    @NotNull
    public LineAppendable blankLine(int var1);

    public boolean isPreFormatted();

    @NotNull
    public LineAppendable openPreFormatted(boolean var1);

    @NotNull
    public LineAppendable closePreFormatted();

    @NotNull
    public LineAppendable indent();

    @NotNull
    public LineAppendable unIndent();

    @NotNull
    public LineAppendable unIndentNoEol();

    @NotNull
    public BasedSequence getIndentPrefix();

    @NotNull
    public LineAppendable setIndentPrefix(@Nullable CharSequence var1);

    @NotNull
    public BasedSequence getPrefix();

    @NotNull
    public BasedSequence getBeforeEolPrefix();

    @NotNull
    public LineAppendable addPrefix(@NotNull CharSequence var1, boolean var2);

    @NotNull
    public LineAppendable setPrefix(@Nullable CharSequence var1, boolean var2);

    @NotNull
    default public LineAppendable addPrefix(@NotNull CharSequence prefix) {
        return this.addPrefix(prefix, this.getPendingEOL() == 0);
    }

    @NotNull
    default public LineAppendable setPrefix(@NotNull CharSequence prefix) {
        return this.setPrefix(prefix, this.getPendingEOL() == 0);
    }

    @NotNull
    public LineAppendable pushPrefix();

    @NotNull
    public LineAppendable popPrefix(boolean var1);

    @NotNull
    default public LineAppendable popPrefix() {
        return this.popPrefix(false);
    }

    public int getAfterEolPrefixDelta();

    public int column();

    public int offset();

    public int offsetWithPending();

    public boolean isPendingSpace();

    public int getPendingSpace();

    public int getPendingEOL();

    @NotNull
    public LineAppendable lineOnFirstText(boolean var1);

    @NotNull
    default public LineAppendable setLineOnFirstText() {
        return this.lineOnFirstText(true);
    }

    @NotNull
    default public LineAppendable clearLineOnFirstText() {
        return this.lineOnFirstText(false);
    }

    @NotNull
    public LineAppendable addIndentOnFirstEOL(@NotNull Runnable var1);

    @NotNull
    public LineAppendable removeIndentOnFirstEOL(@NotNull Runnable var1);

    public int getLineCount();

    default public boolean isEmpty() {
        return this.getLineCountWithPending() == 0;
    }

    default public boolean isNotEmpty() {
        return this.getLineCountWithPending() != 0;
    }

    public int getLineCountWithPending();

    @NotNull
    public LineInfo getLineInfo(int var1);

    @NotNull
    default public LineInfo get(int lineIndex) {
        return this.getLineInfo(lineIndex);
    }

    @NotNull
    public BasedSequence getLine(int var1);

    @Override
    @NotNull
    public Iterator<LineInfo> iterator();

    @NotNull
    public Iterable<BasedSequence> getLines(int var1, int var2, int var3, boolean var4);

    @NotNull
    default public Iterable<BasedSequence> getLines(int maxTrailingBlankLines) {
        return this.getLines(maxTrailingBlankLines, 0, Integer.MAX_VALUE, true);
    }

    @NotNull
    default public Iterable<BasedSequence> getLines() {
        return this.getLines(Integer.MAX_VALUE, 0, Integer.MAX_VALUE, true);
    }

    @NotNull
    default public Iterable<BasedSequence> getLines(int maxTrailingBlankLines, boolean withPrefixes) {
        return this.getLines(maxTrailingBlankLines, 0, Integer.MAX_VALUE, withPrefixes);
    }

    @NotNull
    default public Iterable<BasedSequence> getLines(boolean withPrefixes) {
        return this.getLines(Integer.MAX_VALUE, 0, Integer.MAX_VALUE, withPrefixes);
    }

    @NotNull
    public Iterable<LineInfo> getLinesInfo(int var1, int var2, int var3);

    @NotNull
    default public Iterable<LineInfo> getLinesInfo(int maxTrailingBlankLines) {
        return this.getLinesInfo(maxTrailingBlankLines, 0, Integer.MAX_VALUE);
    }

    @NotNull
    default public Iterable<LineInfo> getLinesInfo() {
        return this.getLinesInfo(Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
    }

    @NotNull
    default public BasedSequence getLineContent(int lineIndex) {
        LineInfo lineInfo = this.getLineInfo(lineIndex);
        BasedSequence line = this.getLine(lineIndex);
        return line.subSequence(lineInfo.prefixLength, lineInfo.prefixLength + lineInfo.textLength);
    }

    @NotNull
    default public BasedSequence getLinePrefix(int lineIndex) {
        LineInfo lineInfo = this.getLineInfo(lineIndex);
        BasedSequence line = this.getLine(lineIndex);
        return line.subSequence(0, lineInfo.prefixLength);
    }

    public void setPrefixLength(int var1, int var2);

    public void setLine(int var1, @NotNull CharSequence var2, @NotNull CharSequence var3);

    public void insertLine(int var1, @NotNull CharSequence var2, @NotNull CharSequence var3);

    @NotNull
    public LineAppendable removeLines(int var1, int var2);

    @NotNull
    public String toString(int var1, int var2, boolean var3);

    @NotNull
    default public String toString(int maxBlankLines, int maxTrailingBlankLines) {
        return this.toString(maxBlankLines, maxTrailingBlankLines, true);
    }

    @NotNull
    default public String toString(int maxBlankLines, boolean withPrefixes) {
        return this.toString(maxBlankLines, maxBlankLines, withPrefixes);
    }

    @NotNull
    default public String toString(boolean withPrefixes) {
        return this.toString(Integer.MAX_VALUE, Integer.MAX_VALUE, withPrefixes);
    }

    @NotNull
    default public String toString(int maxBlankLines) {
        return this.toString(maxBlankLines, maxBlankLines, true);
    }

    @NotNull
    public CharSequence toSequence(int var1, int var2, boolean var3);

    @NotNull
    default public CharSequence toSequence(int maxBlankLines, int maxTrailingBlankLines) {
        return this.toSequence(maxBlankLines, maxTrailingBlankLines, true);
    }

    @NotNull
    default public CharSequence toSequence(int maxBlankLines, boolean withPrefixes) {
        return this.toSequence(maxBlankLines, maxBlankLines, withPrefixes);
    }

    @NotNull
    default public CharSequence toSequence(boolean withPrefixes) {
        return this.toSequence(Integer.MAX_VALUE, Integer.MAX_VALUE, withPrefixes);
    }

    @NotNull
    default public CharSequence toSequence() {
        return this.toSequence(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
    }

    @Deprecated
    default public <T extends Appendable> T appendTo(@NotNull T out, int maxTrailingBlankLines) throws IOException {
        return this.appendTo(out, Integer.MAX_VALUE, maxTrailingBlankLines);
    }

    public <T extends Appendable> T appendTo(@NotNull T var1, boolean var2, int var3, int var4, int var5, int var6) throws IOException;

    default public <T extends Appendable> T appendTo(@NotNull T out, int maxBlankLines, int maxTrailingBlankLines, int startLine, int endLine) throws IOException {
        return this.appendTo(out, true, maxBlankLines, maxTrailingBlankLines, startLine, endLine);
    }

    default public <T extends Appendable> T appendTo(@NotNull T out, int maxBlankLines, int maxTrailingBlankLines) throws IOException {
        return this.appendTo(out, maxBlankLines, maxTrailingBlankLines, 0, Integer.MAX_VALUE);
    }

    default public <T extends Appendable> T appendTo(@NotNull T out) throws IOException {
        return this.appendTo(out, 0, 0, 0, Integer.MAX_VALUE);
    }

    default public <T extends Appendable> T appendToSilently(@NotNull T out, boolean withPrefixes, int maxBlankLines, int maxTrailingBlankLines, int startLine, int endLine) {
        try {
            this.appendTo(out, withPrefixes, maxBlankLines, maxTrailingBlankLines, startLine, endLine);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    default public <T extends Appendable> T appendToSilently(@NotNull T out, int maxBlankLines, int maxTrailingBlankLines, int startLine, int endLine) {
        this.appendToSilently(out, true, maxBlankLines, maxTrailingBlankLines, startLine, endLine);
        return out;
    }

    default public <T extends Appendable> T appendToSilently(@NotNull T out, int maxBlankLines, int maxTrailingBlankLines) {
        this.appendToSilently(out, maxBlankLines, maxTrailingBlankLines, 0, Integer.MAX_VALUE);
        return out;
    }

    default public <T extends Appendable> T appendToSilently(@NotNull T out) {
        return this.appendToSilently(out, 0, 0, 0, Integer.MAX_VALUE);
    }

    public LineAppendable removeExtraBlankLines(int var1, int var2, int var3, int var4);

    default public LineAppendable removeExtraBlankLines(int maxBlankLines, int maxTrailingBlankLines) {
        return this.removeExtraBlankLines(maxBlankLines, maxTrailingBlankLines, 0, Integer.MAX_VALUE);
    }

    public static CharSequence combinedPrefix(@Nullable CharSequence prefix, @Nullable CharSequence suffix) {
        if (prefix != null && prefix.length() > 0 && suffix != null && suffix.length() > 0) {
            return String.valueOf(prefix) + suffix;
        }
        if (prefix != null && prefix.length() > 0) {
            return prefix;
        }
        if (suffix != null && suffix.length() > 0) {
            return suffix;
        }
        return BasedSequence.NULL;
    }

    public static enum Options {
        CONVERT_TABS,
        COLLAPSE_WHITESPACE,
        TRIM_TRAILING_WHITESPACE,
        PASS_THROUGH,
        TRIM_LEADING_WHITESPACE,
        TRIM_LEADING_EOL,
        PREFIX_PRE_FORMATTED;

    }
}

