/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.semanticdb.internal;

import dotty.tools.dotc.semanticdb.internal.SemanticdbOutputStream$;
import dotty.tools.dotc.semanticdb.internal.WireFormat$;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Int$;

public class SemanticdbOutputStream {
    private final OutputStream output;
    private final byte[] buffer;
    private int position;
    private final int limit;
    private int totalBytesWritten;

    public static int DEFAULT_BUFFER_SIZE() {
        return SemanticdbOutputStream$.MODULE$.DEFAULT_BUFFER_SIZE();
    }

    public static int LITTLE_ENDIAN_32_SIZE() {
        return SemanticdbOutputStream$.MODULE$.LITTLE_ENDIAN_32_SIZE();
    }

    public static int LITTLE_ENDIAN_64_SIZE() {
        return SemanticdbOutputStream$.MODULE$.LITTLE_ENDIAN_64_SIZE();
    }

    public static int computeBoolSize(int n, boolean bl) {
        return SemanticdbOutputStream$.MODULE$.computeBoolSize(n, bl);
    }

    public static int computeBoolSizeNoTag(boolean bl) {
        return SemanticdbOutputStream$.MODULE$.computeBoolSizeNoTag(bl);
    }

    public static int computeByteArraySize(int n, byte[] byArray) {
        return SemanticdbOutputStream$.MODULE$.computeByteArraySize(n, byArray);
    }

    public static int computeByteArraySizeNoTag(byte[] byArray) {
        return SemanticdbOutputStream$.MODULE$.computeByteArraySizeNoTag(byArray);
    }

    public static int computeByteBufferSize(int n, ByteBuffer byteBuffer) {
        return SemanticdbOutputStream$.MODULE$.computeByteBufferSize(n, byteBuffer);
    }

    public static int computeByteBufferSizeNoTag(ByteBuffer byteBuffer) {
        return SemanticdbOutputStream$.MODULE$.computeByteBufferSizeNoTag(byteBuffer);
    }

    public static int computeDoubleSize(int n, double d) {
        return SemanticdbOutputStream$.MODULE$.computeDoubleSize(n, d);
    }

    public static int computeDoubleSizeNoTag(double d) {
        return SemanticdbOutputStream$.MODULE$.computeDoubleSizeNoTag(d);
    }

    public static int computeEnumSize(int n, int n2) {
        return SemanticdbOutputStream$.MODULE$.computeEnumSize(n, n2);
    }

    public static int computeEnumSizeNoTag(int n) {
        return SemanticdbOutputStream$.MODULE$.computeEnumSizeNoTag(n);
    }

    public static int computeFixed32Size(int n, int n2) {
        return SemanticdbOutputStream$.MODULE$.computeFixed32Size(n, n2);
    }

    public static int computeFixed32SizeNoTag(int n) {
        return SemanticdbOutputStream$.MODULE$.computeFixed32SizeNoTag(n);
    }

    public static int computeFixed64Size(int n, long l) {
        return SemanticdbOutputStream$.MODULE$.computeFixed64Size(n, l);
    }

    public static int computeFixed64SizeNoTag(long l) {
        return SemanticdbOutputStream$.MODULE$.computeFixed64SizeNoTag(l);
    }

    public static int computeFloatSize(int n, float f) {
        return SemanticdbOutputStream$.MODULE$.computeFloatSize(n, f);
    }

    public static int computeFloatSizeNoTag(float f) {
        return SemanticdbOutputStream$.MODULE$.computeFloatSizeNoTag(f);
    }

    public static int computeInt32Size(int n, int n2) {
        return SemanticdbOutputStream$.MODULE$.computeInt32Size(n, n2);
    }

    public static int computeInt32SizeNoTag(int n) {
        return SemanticdbOutputStream$.MODULE$.computeInt32SizeNoTag(n);
    }

    public static int computeInt64Size(int n, long l) {
        return SemanticdbOutputStream$.MODULE$.computeInt64Size(n, l);
    }

    public static int computeInt64SizeNoTag(long l) {
        return SemanticdbOutputStream$.MODULE$.computeInt64SizeNoTag(l);
    }

    public static int computePreferredBufferSize(int n) {
        return SemanticdbOutputStream$.MODULE$.computePreferredBufferSize(n);
    }

    public static int computeRawVarint32Size(int n) {
        return SemanticdbOutputStream$.MODULE$.computeRawVarint32Size(n);
    }

    public static int computeRawVarint64Size(long l) {
        return SemanticdbOutputStream$.MODULE$.computeRawVarint64Size(l);
    }

    public static int computeSFixed32Size(int n, int n2) {
        return SemanticdbOutputStream$.MODULE$.computeSFixed32Size(n, n2);
    }

    public static int computeSFixed32SizeNoTag(int n) {
        return SemanticdbOutputStream$.MODULE$.computeSFixed32SizeNoTag(n);
    }

    public static int computeSFixed64Size(int n, long l) {
        return SemanticdbOutputStream$.MODULE$.computeSFixed64Size(n, l);
    }

    public static int computeSFixed64SizeNoTag(long l) {
        return SemanticdbOutputStream$.MODULE$.computeSFixed64SizeNoTag(l);
    }

    public static int computeSInt32Size(int n, int n2) {
        return SemanticdbOutputStream$.MODULE$.computeSInt32Size(n, n2);
    }

    public static int computeSInt32SizeNoTag(int n) {
        return SemanticdbOutputStream$.MODULE$.computeSInt32SizeNoTag(n);
    }

    public static int computeSInt64Size(int n, long l) {
        return SemanticdbOutputStream$.MODULE$.computeSInt64Size(n, l);
    }

    public static int computeSInt64SizeNoTag(long l) {
        return SemanticdbOutputStream$.MODULE$.computeSInt64SizeNoTag(l);
    }

    public static int computeStringSize(int n, String string) {
        return SemanticdbOutputStream$.MODULE$.computeStringSize(n, string);
    }

    public static int computeStringSizeNoTag(String string) {
        return SemanticdbOutputStream$.MODULE$.computeStringSizeNoTag(string);
    }

    public static int computeTagSize(int n) {
        return SemanticdbOutputStream$.MODULE$.computeTagSize(n);
    }

    public static int computeUInt32Size(int n, int n2) {
        return SemanticdbOutputStream$.MODULE$.computeUInt32Size(n, n2);
    }

    public static int computeUInt32SizeNoTag(int n) {
        return SemanticdbOutputStream$.MODULE$.computeUInt32SizeNoTag(n);
    }

    public static int computeUInt64Size(int n, long l) {
        return SemanticdbOutputStream$.MODULE$.computeUInt64Size(n, l);
    }

    public static int computeUInt64SizeNoTag(long l) {
        return SemanticdbOutputStream$.MODULE$.computeUInt64SizeNoTag(l);
    }

    public static int encodeZigZag32(int n) {
        return SemanticdbOutputStream$.MODULE$.encodeZigZag32(n);
    }

    public static long encodeZigZag64(long l) {
        return SemanticdbOutputStream$.MODULE$.encodeZigZag64(l);
    }

    public static SemanticdbOutputStream newInstance(ByteBuffer byteBuffer) {
        return SemanticdbOutputStream$.MODULE$.newInstance(byteBuffer);
    }

    public static SemanticdbOutputStream newInstance(ByteBuffer byteBuffer, int n) {
        return SemanticdbOutputStream$.MODULE$.newInstance(byteBuffer, n);
    }

    public static SemanticdbOutputStream newInstance(byte[] byArray) {
        return SemanticdbOutputStream$.MODULE$.newInstance(byArray);
    }

    public static SemanticdbOutputStream newInstance(OutputStream outputStream) {
        return SemanticdbOutputStream$.MODULE$.newInstance(outputStream);
    }

    public static SemanticdbOutputStream newInstance(OutputStream outputStream, int n) {
        return SemanticdbOutputStream$.MODULE$.newInstance(outputStream, n);
    }

    public SemanticdbOutputStream(OutputStream output, byte[] buffer) {
        this.output = output;
        this.buffer = buffer;
        this.position = 0;
        this.limit = buffer.length;
        this.totalBytesWritten = 0;
    }

    private void refreshBuffer() {
        if (this.output == null) {
            throw new OutOfSpaceException();
        }
        this.output.write(this.buffer, 0, this.position);
        this.position = 0;
    }

    public void flush() {
        if (this.output != null) {
            this.refreshBuffer();
            return;
        }
    }

    public int spaceLeft() {
        if (this.output == null) {
            return this.limit - this.position;
        }
        throw new UnsupportedOperationException("spaceLeft() can only be called on SemanticdbOutputStreams that are writing to a flat array.");
    }

    public void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void writeDouble(int fieldNumber, double value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_FIXED64());
        this.writeDoubleNoTag(value);
    }

    public void writeFloat(int fieldNumber, float value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_FIXED32());
        this.writeFloatNoTag(value);
    }

    public void writeUInt64(int fieldNumber, long value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_VARINT());
        this.writeUInt64NoTag(value);
    }

    public void writeInt64(int fieldNumber, long value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_VARINT());
        this.writeInt64NoTag(value);
    }

    public void writeInt32(int fieldNumber, int value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_VARINT());
        this.writeInt32NoTag(value);
    }

    public void writeFixed64(int fieldNumber, long value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_FIXED64());
        this.writeFixed64NoTag(value);
    }

    public void writeFixed32(int fieldNumber, int value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_FIXED32());
        this.writeFixed32NoTag(value);
    }

    public void writeBool(int fieldNumber, boolean value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_VARINT());
        this.writeBoolNoTag(value);
    }

    public void writeString(int fieldNumber, String value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_LENGTH_DELIMITED());
        this.writeStringNoTag(value);
    }

    public void writeByteArray(int fieldNumber, byte[] value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_LENGTH_DELIMITED());
        this.writeByteArrayNoTag(value);
    }

    public void writeByteArray(int fieldNumber, byte[] value, int offset, int length) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_LENGTH_DELIMITED());
        this.writeByteArrayNoTag(value, offset, length);
    }

    public void writeByteBuffer(int fieldNumber, ByteBuffer value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_LENGTH_DELIMITED());
        this.writeByteBufferNoTag(value);
    }

    public void writeUInt32(int fieldNumber, int value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_VARINT());
        this.writeUInt32NoTag(value);
    }

    public void writeEnum(int fieldNumber, int value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_VARINT());
        this.writeEnumNoTag(value);
    }

    public void writeSFixed32(int fieldNumber, int value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_FIXED32());
        this.writeSFixed32NoTag(value);
    }

    public void writeSFixed64(int fieldNumber, long value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_FIXED64());
        this.writeSFixed64NoTag(value);
    }

    public void writeSInt32(int fieldNumber, int value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_VARINT());
        this.writeSInt32NoTag(value);
    }

    public void writeSInt64(int fieldNumber, long value) {
        this.writeTag(fieldNumber, WireFormat$.MODULE$.WIRETYPE_VARINT());
        this.writeSInt64NoTag(value);
    }

    public void writeDoubleNoTag(double value) {
        this.writeRawLittleEndian64(Double.doubleToLongBits(value));
    }

    public void writeFloatNoTag(float value) {
        this.writeRawLittleEndian32(Float.floatToIntBits(value));
    }

    public void writeUInt64NoTag(long value) {
        this.writeRawVarint64(value);
    }

    public void writeInt64NoTag(long value) {
        this.writeRawVarint64(value);
    }

    public void writeInt32NoTag(int value) {
        if (value >= 0) {
            this.writeRawVarint32(value);
            return;
        }
        this.writeRawVarint64(Int$.MODULE$.int2long(value));
    }

    public void writeFixed64NoTag(long value) {
        this.writeRawLittleEndian64(value);
    }

    public void writeFixed32NoTag(int value) {
        this.writeRawLittleEndian32(value);
    }

    public void writeBoolNoTag(boolean value) {
        this.writeRawByte(value ? 1 : 0);
    }

    public void writeStringNoTag(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeRawVarint32(bytes.length);
        this.writeRawBytes(bytes);
    }

    public void writeTag(int fieldNumber, int wireType) {
        this.writeRawVarint32(WireFormat$.MODULE$.makeTag(fieldNumber, wireType));
    }

    public void writeRawVarint32(int value0) {
        int value = value0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte(value);
                return;
            }
            this.writeRawByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public void writeRawVarint64(long value0) {
        long value = value0;
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)value);
                return;
            }
            this.writeRawByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public void writeRawLittleEndian32(int value) {
        this.writeRawByte(value & 0xFF);
        this.writeRawByte(value >> 8 & 0xFF);
        this.writeRawByte(value >> 16 & 0xFF);
        this.writeRawByte(value >> 24 & 0xFF);
    }

    public void writeRawLittleEndian64(long value) {
        this.writeRawByte((int)value & 0xFF);
        this.writeRawByte((int)(value >> 8) & 0xFF);
        this.writeRawByte((int)(value >> 16) & 0xFF);
        this.writeRawByte((int)(value >> 24) & 0xFF);
        this.writeRawByte((int)(value >> 32) & 0xFF);
        this.writeRawByte((int)(value >> 40) & 0xFF);
        this.writeRawByte((int)(value >> 48) & 0xFF);
        this.writeRawByte((int)(value >> 56) & 0xFF);
    }

    public void writeByteArrayNoTag(byte[] value) {
        this.writeRawVarint32(value.length);
        this.writeRawBytes(value);
    }

    public void writeByteArrayNoTag(byte[] value, int offset, int length) {
        this.writeRawVarint32(length);
        this.writeRawBytes(value, offset, length);
    }

    public void writeByteBufferNoTag(ByteBuffer value) {
        this.writeRawVarint32(value.capacity());
        this.writeRawBytes(value);
    }

    public void writeUInt32NoTag(int value) {
        this.writeRawVarint32(value);
    }

    public void writeEnumNoTag(int value) {
        this.writeInt32NoTag(value);
    }

    public void writeSFixed32NoTag(int value) {
        this.writeRawLittleEndian32(value);
    }

    public void writeSFixed64NoTag(long value) {
        this.writeRawLittleEndian64(value);
    }

    public void writeSInt32NoTag(int value) {
        this.writeRawVarint32(SemanticdbOutputStream$.MODULE$.encodeZigZag32(value));
    }

    public void writeSInt64NoTag(long value) {
        this.writeRawVarint64(SemanticdbOutputStream$.MODULE$.encodeZigZag64(value));
    }

    public void writeRawByte(byte value) {
        if (this.position == this.limit) {
            this.refreshBuffer();
        }
        this.buffer[this.position] = value;
        ++this.position;
    }

    public void writeRawByte(int value) {
        this.writeRawByte((byte)value);
    }

    public void writeRawBytes(byte[] value) {
        this.writeRawBytes(value, 0, value.length);
    }

    public void writeRawBytes(ByteBuffer value) {
        if (value.hasArray()) {
            this.writeRawBytes(value.array(), value.arrayOffset(), value.capacity());
            return;
        }
        ByteBuffer duplicated = value.duplicate();
        duplicated.clear();
        this.writeRawBytesInternal(duplicated);
    }

    private void writeRawBytesInternal(ByteBuffer value) {
        int length = value.remaining();
        if (this.limit - this.position >= length) {
            value.get(this.buffer, this.position, length);
            this.position += length;
            this.totalBytesWritten += length;
            return;
        }
        int bytesWritten = this.limit - this.position;
        value.get(this.buffer, this.position, bytesWritten);
        length -= bytesWritten;
        this.position = this.limit;
        this.totalBytesWritten += bytesWritten;
        this.refreshBuffer();
        while (length > this.limit) {
            value.get(this.buffer, 0, this.limit);
            this.output.write(this.buffer, 0, this.limit);
            length -= this.limit;
            this.totalBytesWritten += this.limit;
        }
        value.get(this.buffer, 0, length);
        this.position = length;
        this.totalBytesWritten += length;
    }

    public void writeRawBytes(byte[] value, int offset0, int length0) {
        int offset = offset0;
        int length = length0;
        if (this.limit - this.position >= length) {
            System.arraycopy(value, offset, this.buffer, this.position, length);
            this.position += length;
            this.totalBytesWritten += length;
            return;
        }
        int bytesWritten = this.limit - this.position;
        System.arraycopy(value, offset, this.buffer, this.position, bytesWritten);
        offset += bytesWritten;
        this.position = this.limit;
        this.totalBytesWritten += bytesWritten;
        this.refreshBuffer();
        if ((length -= bytesWritten) <= this.limit) {
            System.arraycopy(value, offset, this.buffer, 0, length);
            this.position = length;
        } else {
            this.output.write(value, offset, length);
        }
        this.totalBytesWritten += length;
    }

    public static class ByteBufferOutputStream
    extends OutputStream {
        private final ByteBuffer byteBuffer;

        public ByteBufferOutputStream(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        private ByteBuffer byteBuffer() {
            return this.byteBuffer;
        }

        @Override
        public void write(int b) {
            this.byteBuffer().put((byte)b);
        }

        @Override
        public void write(byte[] data, int offset, int length) {
            this.byteBuffer().put(data, offset, length);
        }
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;

        public OutOfSpaceException() {
            super("SemanticdbOutputStream was writing to a flat byte array and ran out of space.");
        }
    }
}

