# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("crypt32.dll")
prototypes = \
    {
        #
        'CryptFormatObject': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "dwFormatType", "dwFormatStrType", "pFormatStruct", "lpszStructType", "pbEncoded", "cbEncoded", "pbFormat", "pcbFormat"]),
        #
        'CryptEncodeObjectEx': SimTypeFunction([SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CRYPT_ENCODE_OBJECT_FLAGS"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pfnAlloc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbSize"]), offset=0), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0)}, name="CRYPT_ENCODE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "lpszStructType", "pvStructInfo", "dwFlags", "pEncodePara", "pvEncoded", "pcbEncoded"]),
        #
        'CryptEncodeObject': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "lpszStructType", "pvStructInfo", "pbEncoded", "pcbEncoded"]),
        #
        'CryptDecodeObjectEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pfnAlloc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbSize"]), offset=0), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0)}, name="CRYPT_DECODE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "lpszStructType", "pbEncoded", "cbEncoded", "dwFlags", "pDecodePara", "pvStructInfo", "pcbStructInfo"]),
        #
        'CryptDecodeObject': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "lpszStructType", "pbEncoded", "cbEncoded", "dwFlags", "pvStructInfo", "pcbStructInfo"]),
        #
        'CryptInstallOIDFunctionAddress': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvFuncAddr": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_OID_FUNC_ENTRY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hModule", "dwEncodingType", "pszFuncName", "cFuncEntry", "rgFuncEntry", "dwFlags"]),
        #
        'CryptInitOIDFunctionSet': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pszFuncName", "dwFlags"]),
        #
        'CryptGetOIDFunctionAddress': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFuncSet", "dwEncodingType", "pszOID", "dwFlags", "ppvFuncAddr", "phFuncAddr"]),
        #
        'CryptGetDefaultOIDDllList': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFuncSet", "dwEncodingType", "pwszDllList", "pcchDllList"]),
        #
        'CryptGetDefaultOIDFunctionAddress': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFuncSet", "dwEncodingType", "pwszDll", "dwFlags", "ppvFuncAddr", "phFuncAddr"]),
        #
        'CryptFreeOIDFunctionAddress': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hFuncAddr", "dwFlags"]),
        #
        'CryptRegisterOIDFunction': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "pszFuncName", "pszOID", "pwszDll", "pszOverrideFuncName"]),
        #
        'CryptUnregisterOIDFunction': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "pszFuncName", "pszOID"]),
        #
        'CryptRegisterDefaultOIDFunction': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "pszFuncName", "dwIndex", "pwszDll"]),
        #
        'CryptUnregisterDefaultOIDFunction': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "pszFuncName", "pwszDll"]),
        #
        'CryptSetOIDFunctionValue': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="REG_VALUE_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "pszFuncName", "pszOID", "pwszValueName", "dwValueType", "pbValueData", "cbValueData"]),
        #
        'CryptGetOIDFunctionValue': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "pszFuncName", "pszOID", "pwszValueName", "pdwValueType", "pbValueData", "pcbValueData"]),
        #
        'CryptEnumOIDFunction': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "pszFuncName", "pszOID", "cValue", "rgdwValueType", "rgpwszValueName", "rgpbValueData", "rgcbValueData", "pvArg"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "pszFuncName", "pszOID", "dwFlags", "pvArg", "pfnEnumOIDFunc"]),
        #
        'CryptFindOIDInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwGroupId": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwValue": SimTypeInt(signed=False, label="UInt32"), "Algid": SimTypeInt(signed=False, label="UInt32"), "dwLength": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "ExtraInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_OID_INFO", pack=False, align=None), offset=0), arg_names=["dwKeyType", "pvKey", "dwGroupId"]),
        #
        'CryptRegisterOIDInfo': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwGroupId": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwValue": SimTypeInt(signed=False, label="UInt32"), "Algid": SimTypeInt(signed=False, label="UInt32"), "dwLength": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "ExtraInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_OID_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pInfo", "dwFlags"]),
        #
        'CryptUnregisterOIDInfo': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwGroupId": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwValue": SimTypeInt(signed=False, label="UInt32"), "Algid": SimTypeInt(signed=False, label="UInt32"), "dwLength": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "ExtraInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_OID_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pInfo"]),
        #
        'CryptEnumOIDInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwGroupId": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwValue": SimTypeInt(signed=False, label="UInt32"), "Algid": SimTypeInt(signed=False, label="UInt32"), "dwLength": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "ExtraInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_OID_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pInfo", "pvArg"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwGroupId", "dwFlags", "pvArg", "pfnEnumOIDInfo"]),
        #
        'CryptFindLocalizedName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["pwszCryptName"]),
        #
        'CryptMsgOpenToEncode': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CRYPT_MSG_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"cbContent": SimTypeInt(signed=False, label="UInt32"), "pfnStreamOutput": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvArg", "pbData", "cbData", "fFinal"]), offset=0), "pvArg": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CMSG_STREAM_INFO", pack=False, align=None), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["dwMsgEncodingType", "dwFlags", "dwMsgType", "pvMsgEncodeInfo", "pszInnerContentObjID", "pStreamInfo"]),
        #
        'CryptMsgCalculateEncodedLength': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwMsgEncodingType", "dwFlags", "dwMsgType", "pvMsgEncodeInfo", "pszInnerContentObjID", "cbData"]),
        #
        'CryptMsgOpenToDecode': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbContent": SimTypeInt(signed=False, label="UInt32"), "pfnStreamOutput": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvArg", "pbData", "cbData", "fFinal"]), offset=0), "pvArg": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CMSG_STREAM_INFO", pack=False, align=None), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["dwMsgEncodingType", "dwFlags", "dwMsgType", "hCryptProv", "pRecipientInfo", "pStreamInfo"]),
        #
        'CryptMsgDuplicate': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hCryptMsg"]),
        #
        'CryptMsgClose': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptMsg"]),
        #
        'CryptMsgUpdate': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptMsg", "pbData", "cbData", "fFinal"]),
        #
        'CryptMsgGetParam': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptMsg", "dwParamType", "dwIndex", "pvData", "pcbData"]),
        #
        'CryptMsgControl': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptMsg", "dwFlags", "dwCtrlType", "pvCtrlPara"]),
        #
        'CryptMsgVerifyCountersignatureEncoded': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "dwEncodingType", "pbSignerInfo", "cbSignerInfo", "pbSignerInfoCountersignature", "cbSignerInfoCountersignature", "pciCountersigner"]),
        #
        'CryptMsgVerifyCountersignatureEncodedEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "dwEncodingType", "pbSignerInfo", "cbSignerInfo", "pbSignerInfoCountersignature", "cbSignerInfoCountersignature", "dwSignerType", "pvSigner", "dwFlags", "pvExtra"]),
        #
        'CryptMsgCountersign': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "Anonymous": SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None"), "dwKeySpec": SimTypeInt(signed=False, label="UInt32"), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvHashAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cAuthAttr": SimTypeInt(signed=False, label="UInt32"), "rgAuthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0), "cUnauthAttr": SimTypeInt(signed=False, label="UInt32"), "rgUnauthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CMSG_SIGNER_ENCODE_INFO", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptMsg", "dwIndex", "cCountersigners", "rgCountersigners"]),
        #
        'CryptMsgCountersignEncoded': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "Anonymous": SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None"), "dwKeySpec": SimTypeInt(signed=False, label="UInt32"), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvHashAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cAuthAttr": SimTypeInt(signed=False, label="UInt32"), "rgAuthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0), "cUnauthAttr": SimTypeInt(signed=False, label="UInt32"), "rgUnauthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CMSG_SIGNER_ENCODE_INFO", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "pbSignerInfo", "cbSignerInfo", "cCountersigners", "rgCountersigners", "pbCountersignature", "pcbCountersignature"]),
        #
        'CertOpenStore': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CERT_OPEN_STORE_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["lpszStoreProvider", "dwEncodingType", "hCryptProv", "dwFlags", "pvPara"]),
        #
        'CertDuplicateStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hCertStore"]),
        #
        'CertSaveStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE"), SimTypeInt(signed=False, label="CERT_STORE_SAVE_AS"), SimTypeInt(signed=False, label="CERT_STORE_SAVE_TO"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "dwEncodingType", "dwSaveAs", "dwSaveTo", "pvSaveToPara", "dwFlags"]),
        #
        'CertCloseStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "dwFlags"]),
        #
        'CertGetSubjectCertificateFromStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCertStore", "dwCertEncodingType", "pCertId"]),
        #
        'CertEnumCertificatesInStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCertStore", "pPrevCertContext"]),
        #
        'CertFindCertificateInStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CERT_FIND_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCertStore", "dwCertEncodingType", "dwFindFlags", "dwFindType", "pvFindPara", "pPrevCertContext"]),
        #
        'CertGetIssuerCertificateFromStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCertStore", "pSubjectContext", "pPrevIssuerContext", "pdwFlags"]),
        #
        'CertVerifySubjectCertificateContext': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubject", "pIssuer", "pdwFlags"]),
        #
        'CertDuplicateCertificateContext': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["pCertContext"]),
        #
        'CertCreateCertificateContext': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["dwCertEncodingType", "pbCertEncoded", "cbCertEncoded"]),
        #
        'CertFreeCertificateContext': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext"]),
        #
        'CertSetCertificateContextProperty': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "dwPropId", "dwFlags", "pvData"]),
        #
        'CertGetCertificateContextProperty': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "dwPropId", "pvData", "pcbData"]),
        #
        'CertEnumCertificateContextProperties': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pCertContext", "dwPropId"]),
        #
        'CertCreateCTLEntryFromCertificateContextProperties': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "cOptAttr", "rgOptAttr", "dwFlags", "pvReserved", "pCtlEntry", "pcbCtlEntry"]),
        #
        'CertSetCertificateContextPropertiesFromCTLEntry': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "pCtlEntry", "dwFlags"]),
        #
        'CertGetCRLFromStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCertStore", "pIssuerContext", "pPrevCrlContext", "pdwFlags"]),
        #
        'CertEnumCRLsInStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCertStore", "pPrevCrlContext"]),
        #
        'CertFindCRLInStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCertStore", "dwCertEncodingType", "dwFindFlags", "dwFindType", "pvFindPara", "pPrevCrlContext"]),
        #
        'CertDuplicateCRLContext': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), arg_names=["pCrlContext"]),
        #
        'CertCreateCRLContext': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), arg_names=["dwCertEncodingType", "pbCrlEncoded", "cbCrlEncoded"]),
        #
        'CertFreeCRLContext': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCrlContext"]),
        #
        'CertSetCRLContextProperty': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCrlContext", "dwPropId", "dwFlags", "pvData"]),
        #
        'CertGetCRLContextProperty': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCrlContext", "dwPropId", "pvData", "pcbData"]),
        #
        'CertEnumCRLContextProperties': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pCrlContext", "dwPropId"]),
        #
        'CertFindCertificateInCRL': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCert", "pCrlContext", "dwFlags", "pvReserved", "ppCrlEntry"]),
        #
        'CertIsValidCRLForCertificate': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCert", "pCrl", "dwFlags", "pvReserved"]),
        #
        'CertAddEncodedCertificateToStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "dwCertEncodingType", "pbCertEncoded", "cbCertEncoded", "dwAddDisposition", "ppCertContext"]),
        #
        'CertAddCertificateContextToStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "pCertContext", "dwAddDisposition", "ppStoreContext"]),
        #
        'CertAddSerializedElementToStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "pbElement", "cbElement", "dwAddDisposition", "dwFlags", "dwContextTypeFlags", "pdwContextType", "ppvContext"]),
        #
        'CertDeleteCertificateFromStore': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext"]),
        #
        'CertAddEncodedCRLToStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "dwCertEncodingType", "pbCrlEncoded", "cbCrlEncoded", "dwAddDisposition", "ppCrlContext"]),
        #
        'CertAddCRLContextToStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "pCrlContext", "dwAddDisposition", "ppStoreContext"]),
        #
        'CertDeleteCRLFromStore': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCrlContext"]),
        #
        'CertSerializeCertificateStoreElement': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "dwFlags", "pbElement", "pcbElement"]),
        #
        'CertSerializeCRLStoreElement': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCrlContext", "dwFlags", "pbElement", "pcbElement"]),
        #
        'CertDuplicateCTLContext': SimTypeFunction([SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), arg_names=["pCtlContext"]),
        #
        'CertCreateCTLContext': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), arg_names=["dwMsgAndCertEncodingType", "pbCtlEncoded", "cbCtlEncoded"]),
        #
        'CertFreeCTLContext': SimTypeFunction([SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCtlContext"]),
        #
        'CertSetCTLContextProperty': SimTypeFunction([SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCtlContext", "dwPropId", "dwFlags", "pvData"]),
        #
        'CertGetCTLContextProperty': SimTypeFunction([SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCtlContext", "dwPropId", "pvData", "pcbData"]),
        #
        'CertEnumCTLContextProperties': SimTypeFunction([SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pCtlContext", "dwPropId"]),
        #
        'CertEnumCTLsInStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCertStore", "pPrevCtlContext"]),
        #
        'CertFindSubjectInCTL': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), arg_names=["dwEncodingType", "dwSubjectType", "pvSubject", "pCtlContext", "dwFlags"]),
        #
        'CertFindCTLInStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CERT_FIND_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCertStore", "dwMsgAndCertEncodingType", "dwFindFlags", "dwFindType", "pvFindPara", "pPrevCtlContext"]),
        #
        'CertAddEncodedCTLToStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "dwMsgAndCertEncodingType", "pbCtlEncoded", "cbCtlEncoded", "dwAddDisposition", "ppCtlContext"]),
        #
        'CertAddCTLContextToStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "pCtlContext", "dwAddDisposition", "ppStoreContext"]),
        #
        'CertSerializeCTLStoreElement': SimTypeFunction([SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCtlContext", "dwFlags", "pbElement", "pcbElement"]),
        #
        'CertDeleteCTLFromStore': SimTypeFunction([SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCtlContext"]),
        #
        'CertAddCertificateLinkToStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "pCertContext", "dwAddDisposition", "ppStoreContext"]),
        #
        'CertAddCRLLinkToStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "pCrlContext", "dwAddDisposition", "ppStoreContext"]),
        #
        'CertAddCTLLinkToStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "pCtlContext", "dwAddDisposition", "ppStoreContext"]),
        #
        'CertAddStoreToCollection': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCollectionStore", "hSiblingStore", "dwUpdateFlags", "dwPriority"]),
        #
        'CertRemoveStoreFromCollection': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hCollectionStore", "hSiblingStore"]),
        #
        'CertControlStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CERT_CONTROL_STORE_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "dwFlags", "dwCtrlType", "pvCtrlPara"]),
        #
        'CertSetStoreProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "dwPropId", "dwFlags", "pvData"]),
        #
        'CertGetStoreProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCertStore", "dwPropId", "pvData", "pcbData"]),
        #
        'CertCreateContext': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0), "pvFree": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pfnSort": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cbTotalEncoded", "cbRemainEncoded", "cEntry", "pvSort"]), offset=0), "pvSort": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CREATE_CONTEXT_PARA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["dwContextType", "dwEncodingType", "pbEncoded", "cbEncoded", "dwFlags", "pCreatePara"]),
        #
        'CertRegisterSystemStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SYSTEM_STORE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvSystemStore", "dwFlags", "pStoreInfo", "pvReserved"]),
        #
        'CertRegisterPhysicalStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pszOpenStoreProvider": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwOpenEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwOpenFlags": SimTypeInt(signed=False, label="UInt32"), "OpenParameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwPriority": SimTypeInt(signed=False, label="UInt32")}, name="CERT_PHYSICAL_STORE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvSystemStore", "dwFlags", "pwszStoreName", "pStoreInfo", "pvReserved"]),
        #
        'CertUnregisterSystemStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvSystemStore", "dwFlags"]),
        #
        'CertUnregisterPhysicalStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvSystemStore", "dwFlags", "pwszStoreName"]),
        #
        'CertEnumSystemStoreLocation': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwszStoreLocation", "dwFlags", "pvReserved", "pvArg"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwFlags", "pvArg", "pfnEnum"]),
        #
        'CertEnumSystemStore': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CERT_SYSTEM_STORE_FLAGS"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SYSTEM_STORE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvSystemStore", "dwFlags", "pStoreInfo", "pvReserved", "pvArg"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwFlags", "pvSystemStoreLocationPara", "pvArg", "pfnEnum"]),
        #
        'CertEnumPhysicalStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pszOpenStoreProvider": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwOpenEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwOpenFlags": SimTypeInt(signed=False, label="UInt32"), "OpenParameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwPriority": SimTypeInt(signed=False, label="UInt32")}, name="CERT_PHYSICAL_STORE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvSystemStore", "dwFlags", "pwszStoreName", "pStoreInfo", "pvReserved", "pvArg"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvSystemStore", "dwFlags", "pvArg", "pfnEnum"]),
        #
        'CertGetEnhancedKeyUsage': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "dwFlags", "pUsage", "pcbUsage"]),
        #
        'CertSetEnhancedKeyUsage': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "pUsage"]),
        #
        'CertAddEnhancedKeyUsageIdentifier': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "pszUsageIdentifier"]),
        #
        'CertRemoveEnhancedKeyUsageIdentifier': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "pszUsageIdentifier"]),
        #
        'CertGetValidUsages': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cCerts", "rghCerts", "cNumOIDs", "rghOIDs", "pcbOIDs"]),
        #
        'CryptMsgGetAndVerifySigner': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptMsg", "cSignerStore", "rghSignerStore", "dwFlags", "ppSigner", "pdwSignerIndex"]),
        #
        'CryptMsgSignCTL': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "cSigners": SimTypeInt(signed=False, label="UInt32"), "rgSigners": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "Anonymous": SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None"), "dwKeySpec": SimTypeInt(signed=False, label="UInt32"), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvHashAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cAuthAttr": SimTypeInt(signed=False, label="UInt32"), "rgAuthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0), "cUnauthAttr": SimTypeInt(signed=False, label="UInt32"), "rgUnauthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CMSG_SIGNER_ENCODE_INFO", pack=False, align=None), offset=0), "cCertEncoded": SimTypeInt(signed=False, label="UInt32"), "rgCertEncoded": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), "cCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "rgCrlEncoded": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CMSG_SIGNED_ENCODE_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwMsgEncodingType", "pbCtlContent", "cbCtlContent", "pSignInfo", "dwFlags", "pbEncoded", "pcbEncoded"]),
        #
        'CryptMsgEncodeAndSignCTL': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "cSigners": SimTypeInt(signed=False, label="UInt32"), "rgSigners": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "Anonymous": SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None"), "dwKeySpec": SimTypeInt(signed=False, label="UInt32"), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvHashAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cAuthAttr": SimTypeInt(signed=False, label="UInt32"), "rgAuthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0), "cUnauthAttr": SimTypeInt(signed=False, label="UInt32"), "rgUnauthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CMSG_SIGNER_ENCODE_INFO", pack=False, align=None), offset=0), "cCertEncoded": SimTypeInt(signed=False, label="UInt32"), "rgCertEncoded": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), "cCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "rgCrlEncoded": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CMSG_SIGNED_ENCODE_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwMsgEncodingType", "pCtlInfo", "pSignInfo", "dwFlags", "pbEncoded", "pcbEncoded"]),
        #
        'CertFindSubjectInSortedCTL': SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectIdentifier", "pCtlContext", "dwFlags", "pvReserved", "pEncodedAttributes"]),
        #
        'CertEnumSubjectInSortedCTL': SimTypeFunction([SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCtlContext", "ppvNextSubject", "pSubjectIdentifier", "pEncodedAttributes"]),
        #
        'CertVerifyCTLUsage': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cCtlStore": SimTypeInt(signed=False, label="UInt32"), "rghCtlStore": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "cSignerStore": SimTypeInt(signed=False, label="UInt32"), "rghSignerStore": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="CTL_VERIFY_USAGE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwError": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "ppCtl": SimTypePointer(SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), offset=0), "dwCtlEntryIndex": SimTypeInt(signed=False, label="UInt32"), "ppSigner": SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0), "dwSignerIndex": SimTypeInt(signed=False, label="UInt32")}, name="CTL_VERIFY_USAGE_STATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "dwSubjectType", "pvSubject", "pSubjectUsage", "dwFlags", "pVerifyUsagePara", "pVerifyUsageStatus"]),
        #
        'CertVerifyRevocation': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pIssuerCert": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "cCertStore": SimTypeInt(signed=False, label="UInt32"), "rgCertStore": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "hCrlStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pftTimeToUse": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_PARA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwError": SimTypeInt(signed=False, label="UInt32"), "dwReason": SimTypeInt(signed=False, label="CERT_REVOCATION_STATUS_REASON"), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_REVOCATION_STATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncodingType", "dwRevType", "cContext", "rgpvContext", "dwFlags", "pRevPara", "pRevStatus"]),
        #
        'CertCompareIntegerBlob': SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pInt1", "pInt2"]),
        #
        'CertCompareCertificate': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "pCertId1", "pCertId2"]),
        #
        'CertCompareCertificateName': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "pCertName1", "pCertName2"]),
        #
        'CertIsRDNAttrsInCertificateName': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cRDNAttr": SimTypeInt(signed=False, label="UInt32"), "rgRDNAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwValueType": SimTypeInt(signed=False, label="CERT_RDN_ATTR_VALUE_TYPE"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_RDN_ATTR", pack=False, align=None), offset=0)}, name="CERT_RDN", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "dwFlags", "pCertName", "pRDN"]),
        #
        'CertComparePublicKeyInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "pPublicKey1", "pPublicKey2"]),
        #
        'CertGetPublicKeyLength': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwCertEncodingType", "pPublicKey"]),
        #
        'CryptVerifyCertificateSignature': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "dwCertEncodingType", "pbEncoded", "cbEncoded", "pPublicKey"]),
        #
        'CryptVerifyCertificateSignatureEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CRYPT_VERIFY_CERT_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "dwCertEncodingType", "dwSubjectType", "pvSubject", "dwIssuerType", "pvIssuer", "dwFlags", "pvExtra"]),
        #
        'CertIsStrongHashToSign': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwInfoChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"pvInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSerializedInfo": SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="CERT_STRONG_SIGN_FLAGS"), "pwszCNGSignHashAlgids": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszCNGPubKeyMinBitLengths": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_STRONG_SIGN_SERIALIZED_INFO", pack=False, align=None), offset=0), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="CERT_STRONG_SIGN_PARA", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pStrongSignPara", "pwszCNGHashAlgid", "pSigningCert"]),
        #
        'CryptHashToBeSigned': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "dwCertEncodingType", "pbEncoded", "cbEncoded", "pbComputedHash", "pcbComputedHash"]),
        #
        'CryptHashCertificate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "Algid", "dwFlags", "pbEncoded", "cbEncoded", "pbComputedHash", "pcbComputedHash"]),
        #
        'CryptHashCertificate2': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwszCNGHashAlgid", "dwFlags", "pvReserved", "pbEncoded", "cbEncoded", "pbComputedHash", "pcbComputedHash"]),
        #
        'CryptSignCertificate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProvOrNCryptKey", "dwKeySpec", "dwCertEncodingType", "pbEncodedToBeSigned", "cbEncodedToBeSigned", "pSignatureAlgorithm", "pvHashAuxInfo", "pbSignature", "pcbSignature"]),
        #
        'CryptSignAndEncodeCertificate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CERT_KEY_SPEC"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProvOrNCryptKey", "dwKeySpec", "dwCertEncodingType", "lpszStructType", "pvStructInfo", "pSignatureAlgorithm", "pvHashAuxInfo", "pbEncoded", "pcbEncoded"]),
        #
        'CertVerifyTimeValidity': SimTypeFunction([SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTimeToVerify", "pCertInfo"]),
        #
        'CertVerifyCRLTimeValidity': SimTypeFunction([SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTimeToVerify", "pCrlInfo"]),
        #
        'CertVerifyValidityNesting': SimTypeFunction([SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "pIssuerInfo"]),
        #
        'CertVerifyCRLRevocation': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "pCertId", "cCrlInfo", "rgpCrlInfo"]),
        #
        'CertAlgIdToOID': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["dwAlgId"]),
        #
        'CertOIDToAlgId': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszObjId"]),
        #
        'CertFindExtension': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), label="LPArray", offset=0)], SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0), arg_names=["pszObjId", "cExtensions", "rgExtensions"]),
        #
        'CertFindAttribute': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), label="LPArray", offset=0)], SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0), arg_names=["pszObjId", "cAttr", "rgAttr"]),
        #
        'CertFindRDNAttr': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"cRDN": SimTypeInt(signed=False, label="UInt32"), "rgRDN": SimTypePointer(SimStruct({"cRDNAttr": SimTypeInt(signed=False, label="UInt32"), "rgRDNAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwValueType": SimTypeInt(signed=False, label="CERT_RDN_ATTR_VALUE_TYPE"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_RDN_ATTR", pack=False, align=None), offset=0)}, name="CERT_RDN", pack=False, align=None), offset=0)}, name="CERT_NAME_INFO", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwValueType": SimTypeInt(signed=False, label="CERT_RDN_ATTR_VALUE_TYPE"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_RDN_ATTR", pack=False, align=None), offset=0), arg_names=["pszObjId", "pName"]),
        #
        'CertGetIntendedKeyUsage': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "pCertInfo", "pbKeyUsage", "cbKeyUsage"]),
        #
        'CryptInstallDefaultContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CRYPT_DEFAULT_CONTEXT_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CRYPT_DEFAULT_CONTEXT_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "dwDefaultType", "pvDefaultPara", "dwFlags", "pvReserved", "phDefaultContext"]),
        #
        'CryptUninstallDefaultContext': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hDefaultContext", "dwFlags", "pvReserved"]),
        #
        'CryptExportPublicKeyInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProvOrNCryptKey", "dwKeySpec", "dwCertEncodingType", "pInfo", "pcbInfo"]),
        #
        'CryptExportPublicKeyInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProvOrNCryptKey", "dwKeySpec", "dwCertEncodingType", "pszPublicKeyObjId", "dwFlags", "pvAuxInfo", "pInfo", "pcbInfo"]),
        #
        'CryptExportPublicKeyInfoFromBCryptKeyHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBCryptKey", "dwCertEncodingType", "pszPublicKeyObjId", "dwFlags", "pvAuxInfo", "pInfo", "pcbInfo"]),
        #
        'CryptImportPublicKeyInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "dwCertEncodingType", "pInfo", "phKey"]),
        #
        'CryptImportPublicKeyInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "dwCertEncodingType", "pInfo", "aiKeyAlg", "dwFlags", "pvAuxInfo", "phKey"]),
        #
        'CryptImportPublicKeyInfoEx2': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CRYPT_IMPORT_PUBLIC_KEY_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "pInfo", "dwFlags", "pvAuxInfo", "phKey"]),
        #
        'CryptAcquireCertificatePrivateKey': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CRYPT_ACQUIRE_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CERT_KEY_SPEC"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCert", "dwFlags", "pvParameters", "phCryptProvOrNCryptKey", "pdwKeySpec", "pfCallerFreeProvOrNCryptKey"]),
        #
        'CryptFindCertificateKeyProvInfo': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CRYPT_FIND_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCert", "dwFlags", "pvReserved"]),
        #
        'CryptImportPKCS8': SimTypeFunction([SimStruct({"PrivateKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "pResolvehCryptProvFunc": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PrivateKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "pAttributes": SimTypePointer(SimStruct({"cAttr": SimTypeInt(signed=False, label="UInt32"), "rgAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTES", pack=False, align=None), offset=0)}, name="CRYPT_PRIVATE_KEY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPrivateKeyInfo", "phCryptProv", "pVoidResolveFunc"]), offset=0), "pVoidResolveFunc": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pDecryptPrivateKeyFunc": SimTypePointer(SimTypeFunction([SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Algorithm", "EncryptedPrivateKey", "pbClearTextKey", "pcbClearTextKey", "pVoidDecryptFunc"]), offset=0), "pVoidDecryptFunc": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_PKCS8_IMPORT_PARAMS", pack=False, align=None), SimTypeInt(signed=False, label="CRYPT_KEY_FLAGS"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sPrivateKeyAndParams", "dwFlags", "phCryptProv", "pvAuxInfo"]),
        #
        'CryptExportPKCS8': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "dwKeySpec", "pszPrivateKeyObjId", "dwFlags", "pvAuxInfo", "pbPrivateKeyBlob", "pcbPrivateKeyBlob"]),
        #
        'CryptHashPublicKeyInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptProv", "Algid", "dwFlags", "dwCertEncodingType", "pInfo", "pbComputedHash", "pcbComputedHash"]),
        #
        'CertRDNValueToStrA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwValueType", "pValue", "psz", "csz"]),
        #
        'CertRDNValueToStrW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwValueType", "pValue", "psz", "csz"]),
        #
        'CertNameToStrA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CERT_STRING_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwCertEncodingType", "pName", "dwStrType", "psz", "csz"]),
        #
        'CertNameToStrW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CERT_STRING_TYPE"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwCertEncodingType", "pName", "dwStrType", "psz", "csz"]),
        #
        'CertStrToNameA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="CERT_STRING_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "pszX500", "dwStrType", "pvReserved", "pbEncoded", "pcbEncoded", "ppszError"]),
        #
        'CertStrToNameW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="CERT_STRING_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "pszX500", "dwStrType", "pvReserved", "pbEncoded", "pcbEncoded", "ppszError"]),
        #
        'CertGetNameStringA': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pCertContext", "dwType", "dwFlags", "pvTypePara", "pszNameString", "cchNameString"]),
        #
        'CertGetNameStringW': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pCertContext", "dwType", "dwFlags", "pvTypePara", "pszNameString", "cchNameString"]),
        #
        'CryptSignMessage': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgEncodingType": SimTypeInt(signed=False, label="UInt32"), "pSigningCert": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvHashAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cMsgCert": SimTypeInt(signed=False, label="UInt32"), "rgpMsgCert": SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0), "cMsgCrl": SimTypeInt(signed=False, label="UInt32"), "rgpMsgCrl": SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), offset=0), "cAuthAttr": SimTypeInt(signed=False, label="UInt32"), "rgAuthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0), "cUnauthAttr": SimTypeInt(signed=False, label="UInt32"), "rgUnauthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwInnerContentType": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_SIGN_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSignPara", "fDetachedSignature", "cToBeSigned", "rgpbToBeSigned", "rgcbToBeSigned", "pbSignedBlob", "pcbSignedBlob"]),
        #
        'CryptVerifyMessageSignature': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pfnGetSignerCertificate": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["pvGetArg", "dwCertEncodingType", "pSignerId", "hMsgCertStore"]), offset=0), "pvGetArg": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_VERIFY_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pVerifyPara", "dwSignerIndex", "pbSignedBlob", "cbSignedBlob", "pbDecoded", "pcbDecoded", "ppSignerCert"]),
        #
        'CryptGetMessageSignerCount': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwMsgEncodingType", "pbSignedBlob", "cbSignedBlob"]),
        #
        'CryptGetMessageCertificates': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["dwMsgAndCertEncodingType", "hCryptProv", "dwFlags", "pbSignedBlob", "cbSignedBlob"]),
        #
        'CryptVerifyDetachedMessageSignature': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pfnGetSignerCertificate": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["pvGetArg", "dwCertEncodingType", "pSignerId", "hMsgCertStore"]), offset=0), "pvGetArg": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_VERIFY_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pVerifyPara", "dwSignerIndex", "pbDetachedSignBlob", "cbDetachedSignBlob", "cToBeSigned", "rgpbToBeSigned", "rgcbToBeSigned", "ppSignerCert"]),
        #
        'CryptEncryptMessage': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgEncodingType": SimTypeInt(signed=False, label="UInt32"), "hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ContentEncryptionAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvEncryptionAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwInnerContentType": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_ENCRYPT_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pEncryptPara", "cRecipientCert", "rgpRecipientCert", "pbToBeEncrypted", "cbToBeEncrypted", "pbEncryptedBlob", "pcbEncryptedBlob"]),
        #
        'CryptDecryptMessage': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "cCertStore": SimTypeInt(signed=False, label="UInt32"), "rghCertStore": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="CRYPT_DECRYPT_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDecryptPara", "pbEncryptedBlob", "cbEncryptedBlob", "pbDecrypted", "pcbDecrypted", "ppXchgCert"]),
        #
        'CryptSignAndEncryptMessage': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgEncodingType": SimTypeInt(signed=False, label="UInt32"), "pSigningCert": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvHashAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cMsgCert": SimTypeInt(signed=False, label="UInt32"), "rgpMsgCert": SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0), "cMsgCrl": SimTypeInt(signed=False, label="UInt32"), "rgpMsgCrl": SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), offset=0), "cAuthAttr": SimTypeInt(signed=False, label="UInt32"), "rgAuthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0), "cUnauthAttr": SimTypeInt(signed=False, label="UInt32"), "rgUnauthAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwInnerContentType": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_SIGN_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgEncodingType": SimTypeInt(signed=False, label="UInt32"), "hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ContentEncryptionAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvEncryptionAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwInnerContentType": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_ENCRYPT_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSignPara", "pEncryptPara", "cRecipientCert", "rgpRecipientCert", "pbToBeSignedAndEncrypted", "cbToBeSignedAndEncrypted", "pbSignedAndEncryptedBlob", "pcbSignedAndEncryptedBlob"]),
        #
        'CryptDecryptAndVerifyMessageSignature': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "cCertStore": SimTypeInt(signed=False, label="UInt32"), "rghCertStore": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="CRYPT_DECRYPT_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pfnGetSignerCertificate": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["pvGetArg", "dwCertEncodingType", "pSignerId", "hMsgCertStore"]), offset=0), "pvGetArg": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_VERIFY_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDecryptPara", "pVerifyPara", "dwSignerIndex", "pbEncryptedBlob", "cbEncryptedBlob", "pbDecrypted", "pcbDecrypted", "ppXchgCert", "ppSignerCert"]),
        #
        'CryptDecodeMessage': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "cCertStore": SimTypeInt(signed=False, label="UInt32"), "rghCertStore": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="CRYPT_DECRYPT_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pfnGetSignerCertificate": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["pvGetArg", "dwCertEncodingType", "pSignerId", "hMsgCertStore"]), offset=0), "pvGetArg": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_VERIFY_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwMsgTypeFlags", "pDecryptPara", "pVerifyPara", "dwSignerIndex", "pbEncodedBlob", "cbEncodedBlob", "dwPrevInnerContentType", "pdwMsgType", "pdwInnerContentType", "pbDecoded", "pcbDecoded", "ppXchgCert", "ppSignerCert"]),
        #
        'CryptHashMessage': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgEncodingType": SimTypeInt(signed=False, label="UInt32"), "hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvHashAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_HASH_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pHashPara", "fDetachedHash", "cToBeHashed", "rgpbToBeHashed", "rgcbToBeHashed", "pbHashedBlob", "pcbHashedBlob", "pbComputedHash", "pcbComputedHash"]),
        #
        'CryptVerifyMessageHash': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgEncodingType": SimTypeInt(signed=False, label="UInt32"), "hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvHashAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_HASH_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pHashPara", "pbHashedBlob", "cbHashedBlob", "pbToBeHashed", "pcbToBeHashed", "pbComputedHash", "pcbComputedHash"]),
        #
        'CryptVerifyDetachedMessageHash': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgEncodingType": SimTypeInt(signed=False, label="UInt32"), "hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvHashAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_HASH_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pHashPara", "pbDetachedHashBlob", "cbDetachedHashBlob", "cToBeHashed", "rgpbToBeHashed", "rgcbToBeHashed", "pbComputedHash", "pcbComputedHash"]),
        #
        'CryptSignMessageWithKey': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE"), "Anonymous": SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None"), "dwKeySpec": SimTypeInt(signed=False, label="CERT_KEY_SPEC"), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "pvHashAuxInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "PubKeyAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None)}, name="CRYPT_KEY_SIGN_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSignPara", "pbToBeSigned", "cbToBeSigned", "pbSignedBlob", "pcbSignedBlob"]),
        #
        'CryptVerifyMessageSignatureWithKey': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMsgEncodingType": SimTypeInt(signed=False, label="UInt32"), "hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="CRYPT_KEY_VERIFY_MESSAGE_PARA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pVerifyPara", "pPublicKeyInfo", "pbSignedBlob", "cbSignedBlob", "pbDecoded", "pcbDecoded"]),
        #
        'CertOpenSystemStoreA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hProv", "szSubsystemProtocol"]),
        #
        'CertOpenSystemStoreW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hProv", "szSubsystemProtocol"]),
        #
        'CertAddEncodedCertificateToSystemStoreA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["szCertStoreName", "pbCertEncoded", "cbCertEncoded"]),
        #
        'CertAddEncodedCertificateToSystemStoreW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["szCertStoreName", "pbCertEncoded", "cbCertEncoded"]),
        #
        'CryptQueryObject': SimTypeFunction([SimTypeInt(signed=False, label="CERT_QUERY_OBJECT_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CERT_QUERY_CONTENT_TYPE_FLAGS"), SimTypeInt(signed=False, label="CERT_QUERY_FORMAT_TYPE_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CERT_QUERY_CONTENT_TYPE"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CERT_QUERY_FORMAT_TYPE"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwObjectType", "pvObject", "dwExpectedContentTypeFlags", "dwExpectedFormatTypeFlags", "dwFlags", "pdwMsgAndCertEncodingType", "pdwContentType", "pdwFormatType", "phCertStore", "phMsg", "ppvContext"]),
        #
        'CryptMemAlloc': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbSize"]),
        #
        'CryptMemRealloc': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pv", "cbSize"]),
        #
        'CryptMemFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]),
        #
        'CryptCreateAsyncHandle': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwFlags", "phAsync"]),
        #
        'CryptSetAsyncParam': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pszParamOid", "pvParam"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hAsync", "pszParamOid", "pvParam", "pfnFree"]),
        #
        'CryptGetAsyncParam': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pszParamOid", "pvParam"]), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hAsync", "pszParamOid", "ppvParam", "ppfnFree"]),
        #
        'CryptCloseAsyncHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hAsync"]),
        #
        'CertCreateSelfSignCertificate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CERT_CREATE_SELFSIGN_FLAGS"), SimTypePointer(SimStruct({"pwszContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszProvName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwProvType": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="CRYPT_KEY_FLAGS"), "cProvParam": SimTypeInt(signed=False, label="UInt32"), "rgProvParam": SimTypePointer(SimStruct({"dwParam": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbData": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_KEY_PROV_PARAM", pack=False, align=None), offset=0), "dwKeySpec": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_KEY_PROV_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_EXTENSIONS", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCryptProvOrNCryptKey", "pSubjectIssuerBlob", "dwFlags", "pKeyProvInfo", "pSignatureAlgorithm", "pStartTime", "pEndTime", "pExtensions"]),
        #
        'CryptGetKeyIdentifierProperty': SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pKeyIdentifier", "dwPropId", "dwFlags", "pwszComputerName", "pvReserved", "pvData", "pcbData"]),
        #
        'CryptSetKeyIdentifierProperty': SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pKeyIdentifier", "dwPropId", "dwFlags", "pwszComputerName", "pvReserved", "pvData"]),
        #
        'CryptEnumKeyIdentifierProperties': SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pKeyIdentifier", "dwFlags", "pvReserved", "pvArg", "cProp", "rgdwPropId", "rgpvData", "rgcbData"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pKeyIdentifier", "dwPropId", "dwFlags", "pwszComputerName", "pvReserved", "pvArg", "pfnEnum"]),
        #
        'CryptCreateKeyIdentifierFromCSP': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"bType": SimTypeChar(label="Byte"), "bVersion": SimTypeChar(label="Byte"), "reserved": SimTypeShort(signed=False, label="UInt16"), "aiKeyAlg": SimTypeInt(signed=False, label="UInt32")}, name="PUBLICKEYSTRUC", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCertEncodingType", "pszPubKeyOID", "pPubKeyStruc", "cbPubKeyStruc", "dwFlags", "pvReserved", "pbHash", "pcbHash"]),
        #
        'CertCreateCertificateChainEngine': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hRestrictedRoot": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hRestrictedTrust": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hRestrictedOther": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cAdditionalStore": SimTypeInt(signed=False, label="UInt32"), "rghAdditionalStore": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwUrlRetrievalTimeout": SimTypeInt(signed=False, label="UInt32"), "MaximumCachedCertificates": SimTypeInt(signed=False, label="UInt32"), "CycleDetectionModulus": SimTypeInt(signed=False, label="UInt32"), "hExclusiveRoot": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hExclusiveTrustedPeople": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwExclusiveFlags": SimTypeInt(signed=False, label="UInt32")}, name="CERT_CHAIN_ENGINE_CONFIG", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pConfig", "phChainEngine"]),
        #
        'CertFreeCertificateChainEngine': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hChainEngine"]),
        #
        'CertResyncCertificateChainEngine': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChainEngine"]),
        #
        'CertGetCertificateChain': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "RequestedUsage": SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Usage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None)}, name="CERT_USAGE_MATCH", pack=False, align=None)}, name="CERT_CHAIN_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChainEngine", "pCertContext", "pTime", "hAdditionalStore", "pChainPara", "dwFlags", "pvReserved", "ppChainContext"]),
        #
        'CertFreeCertificateChain': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pChainContext"]),
        #
        'CertDuplicateCertificateChain': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), arg_names=["pChainContext"]),
        #
        'CertFindChainInStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CERT_FIND_CHAIN_IN_STORE_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), arg_names=["hCertStore", "dwCertEncodingType", "dwFindFlags", "dwFindType", "pvFindPara", "pPrevChainContext"]),
        #
        'CertVerifyCertificateChainPolicy': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="CERT_CHAIN_POLICY_FLAGS"), "pvExtraPolicyPara": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CHAIN_POLICY_PARA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwError": SimTypeInt(signed=False, label="UInt32"), "lChainIndex": SimTypeInt(signed=True, label="Int32"), "lElementIndex": SimTypeInt(signed=True, label="Int32"), "pvExtraPolicyStatus": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CHAIN_POLICY_STATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPolicyOID", "pChainContext", "pPolicyPara", "pPolicyStatus"]),
        #
        'CryptStringToBinaryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CRYPT_STRING"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszString", "cchString", "dwFlags", "pbBinary", "pcbBinary", "pdwSkip", "pdwFlags"]),
        #
        'CryptStringToBinaryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CRYPT_STRING"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszString", "cchString", "dwFlags", "pbBinary", "pcbBinary", "pdwSkip", "pdwFlags"]),
        #
        'CryptBinaryToStringA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CRYPT_STRING"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pbBinary", "cbBinary", "dwFlags", "pszString", "pcchString"]),
        #
        'CryptBinaryToStringW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CRYPT_STRING"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pbBinary", "cbBinary", "dwFlags", "pszString", "pcchString"]),
        #
        'PFXImportCertStore': SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="CRYPT_KEY_FLAGS")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pPFX", "szPassword", "dwFlags"]),
        #
        'PFXIsPFXBlob': SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPFX"]),
        #
        'PFXVerifyPassword': SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pPFX", "szPassword", "dwFlags"]),
        #
        'PFXExportCertStoreEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hStore", "pPFX", "szPassword", "pvPara", "dwFlags"]),
        #
        'PFXExportCertStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hStore", "pPFX", "szPassword", "dwFlags"]),
        #
        'CertOpenServerOcspResponse': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pcbUsedSize": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pwszOcspDirectory": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pfnUpdateCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pbEncodedOcspResponse": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbEncodedOcspResponse": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SERVER_OCSP_RESPONSE_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pChainContext", "pServerOcspResponseContext", "pNewCrlContext", "pPrevCrlContext", "pvArg", "dwWriteOcspFileError"]), offset=0), "pvUpdateCallbackArg": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_SERVER_OCSP_RESPONSE_OPEN_PARA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pChainContext", "dwFlags", "pOpenPara"]),
        #
        'CertAddRefServerOcspResponse': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hServerOcspResponse"]),
        #
        'CertCloseServerOcspResponse': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["hServerOcspResponse", "dwFlags"]),
        #
        'CertGetServerOcspResponseContext': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pbEncodedOcspResponse": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbEncodedOcspResponse": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SERVER_OCSP_RESPONSE_CONTEXT", pack=False, align=None), offset=0), arg_names=["hServerOcspResponse", "dwFlags", "pvReserved"]),
        #
        'CertAddRefServerOcspResponseContext': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pbEncodedOcspResponse": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbEncodedOcspResponse": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SERVER_OCSP_RESPONSE_CONTEXT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pServerOcspResponseContext"]),
        #
        'CertFreeServerOcspResponseContext': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pbEncodedOcspResponse": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbEncodedOcspResponse": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SERVER_OCSP_RESPONSE_CONTEXT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pServerOcspResponseContext"]),
        #
        'CertRetrieveLogoOrBiometricInfo': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "lpszLogoOrBiometricType", "dwRetrievalFlags", "dwTimeout", "dwFlags", "pvReserved", "ppbData", "pcbData", "ppwszMimeType"]),
        #
        'CertSelectCertificateChains': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"hChainEngine": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pTime": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), "hAdditionalStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pChainPara": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "RequestedUsage": SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Usage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None)}, name="CERT_USAGE_MATCH", pack=False, align=None)}, name="CERT_CHAIN_PARA", pack=False, align=None), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SELECT_CHAIN_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="CERT_SELECT_CRITERIA_TYPE"), "cPara": SimTypeInt(signed=False, label="UInt32"), "ppPara": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="CERT_SELECT_CRITERIA", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSelectionContext", "dwFlags", "pChainParameters", "cCriteria", "rgpCriteria", "hStore", "pcSelection", "pprgpSelection"]),
        #
        'CertFreeCertificateChainList': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["prgpSelection"]),
        #
        'CryptRetrieveTimeStamp': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"pszTSAPolicyId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fRequestCerts": SimTypeInt(signed=True, label="Int32"), "Nonce": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRYPT_TIMESTAMP_PARA", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"cbEncoded": SimTypeInt(signed=False, label="UInt32"), "pbEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTimeStamp": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "pszTSAPolicyId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "HashedMessage": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ftTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pvAccuracy": SimTypePointer(SimStruct({"dwSeconds": SimTypeInt(signed=False, label="UInt32"), "dwMillis": SimTypeInt(signed=False, label="UInt32"), "dwMicros": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_TIMESTAMP_ACCURACY", pack=False, align=None), offset=0), "fOrdering": SimTypeInt(signed=True, label="Int32"), "Nonce": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "Tsa": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRYPT_TIMESTAMP_INFO", pack=False, align=None), offset=0)}, name="CRYPT_TIMESTAMP_CONTEXT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["wszUrl", "dwRetrievalFlags", "dwTimeout", "pszHashId", "pPara", "pbData", "cbData", "ppTsContext", "ppTsSigner", "phStore"]),
        #
        'CryptVerifyTimeStampSignature': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cbEncoded": SimTypeInt(signed=False, label="UInt32"), "pbEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTimeStamp": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "pszTSAPolicyId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "HashedMessage": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ftTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pvAccuracy": SimTypePointer(SimStruct({"dwSeconds": SimTypeInt(signed=False, label="UInt32"), "dwMillis": SimTypeInt(signed=False, label="UInt32"), "dwMicros": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_TIMESTAMP_ACCURACY", pack=False, align=None), offset=0), "fOrdering": SimTypeInt(signed=True, label="Int32"), "Nonce": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "Tsa": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRYPT_TIMESTAMP_INFO", pack=False, align=None), offset=0)}, name="CRYPT_TIMESTAMP_CONTEXT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pbTSContentInfo", "cbTSContentInfo", "pbData", "cbData", "hAdditionalStore", "ppTsContext", "ppTsSigner", "phStore"]),
        #
        'CertIsWeakHash': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwHashUseType", "pwszCNGHashAlgid", "dwChainFlags", "pSignerChainContext", "pTimeStamp", "pwszFileName"]),
        #
        'CryptProtectData': SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwPromptFlags": SimTypeInt(signed=False, label="UInt32"), "hwndApp": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "szPrompt": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPTPROTECT_PROMPTSTRUCT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDataIn", "szDataDescr", "pOptionalEntropy", "pvReserved", "pPromptStruct", "dwFlags", "pDataOut"]),
        #
        'CryptUnprotectData': SimTypeFunction([SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwPromptFlags": SimTypeInt(signed=False, label="UInt32"), "hwndApp": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "szPrompt": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPTPROTECT_PROMPTSTRUCT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDataIn", "ppszDataDescr", "pOptionalEntropy", "pvReserved", "pPromptStruct", "dwFlags", "pDataOut"]),
        #
        'CryptUpdateProtectedState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pOldSid", "pwszOldPassword", "dwFlags", "pdwSuccessCount", "pdwFailureCount"]),
        #
        'CryptProtectMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pDataIn", "cbDataIn", "dwFlags"]),
        #
        'CryptUnprotectMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pDataIn", "cbDataIn", "dwFlags"]),
        #
        'CryptSIPLoad': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hSIP": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfGet": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "pdwEncodingType", "dwIndex", "pcbSignedDataMsg", "pbSignedDataMsg"]), offset=0), "pfPut": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "dwEncodingType", "pdwIndex", "cbSignedDataMsg", "pbSignedDataMsg"]), offset=0), "pfCreate": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "pcbIndirectData", "pIndirectData"]), offset=0), "pfVerify": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "pIndirectData"]), offset=0), "pfRemove": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "dwIndex"]), offset=0)}, name="SIP_DISPATCH_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pgSubject", "dwFlags", "pSipDispatch"]),
        #
        'CryptSIPRetrieveSubjectGuid': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileName", "hFileIn", "pgSubject"]),
        #
        'CryptSIPRetrieveSubjectGuidForCatalogFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileName", "hFileIn", "pgSubject"]),
        #
        'CryptSIPAddProvider': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pgSubject": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pwszDLLFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszMagicNumber": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszIsFunctionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszGetFuncName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPutFuncName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszCreateFuncName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszVerifyFuncName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszRemoveFuncName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszIsFunctionNameFmt2": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszGetCapFuncName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SIP_ADD_NEWPROVIDER", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psNewProv"]),
        #
        'CryptSIPRemoveProvider': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pgProv"]),
    }

lib.set_prototypes(prototypes)
