/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, 3.0lf), 0.0lf) => dvec2(-2.0lf, -2.0lf)
 * mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, 3.0lf), 0.0lf) => dvec2(2.0lf, 2.0lf)
 * mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, 3.0lf), 0.3333333333333333lf) => dvec2(-2.3333333333333335lf, -0.3333333333333335lf)
 * mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, 3.0lf), 0.3333333333333333lf) => dvec2(0.3333333333333335lf, 2.3333333333333335lf)
 * mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, 3.0lf), 0.6666666666666666lf) => dvec2(-2.666666666666667lf, 1.3333333333333333lf)
 * mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, 3.0lf), 0.6666666666666666lf) => dvec2(-1.3333333333333333lf, 2.666666666666667lf)
 * mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, 3.0lf), 1.0lf) => dvec2(-3.0lf, 3.0lf)
 * mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, 3.0lf), 1.0lf) => dvec2(-3.0lf, 3.0lf)
 */
#version 400

void main()
{
  double[distance(mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, 3.0lf), 0.0lf), dvec2(-2.0lf, -2.0lf)) <= 2.8284271247461902e-05lf ? 1 : -1] array0;
  double[distance(mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, 3.0lf), 0.0lf), dvec2(2.0lf, 2.0lf)) <= 2.8284271247461902e-05lf ? 1 : -1] array1;
  double[distance(mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, 3.0lf), 0.3333333333333333lf), dvec2(-2.3333333333333335lf, -0.3333333333333335lf)) <= 2.3570226039551588e-05lf ? 1 : -1] array2;
  double[distance(mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, 3.0lf), 0.3333333333333333lf), dvec2(0.3333333333333335lf, 2.3333333333333335lf)) <= 2.3570226039551588e-05lf ? 1 : -1] array3;
  double[distance(mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, 3.0lf), 0.6666666666666666lf), dvec2(-2.666666666666667lf, 1.3333333333333333lf)) <= 2.9814239699997203e-05lf ? 1 : -1] array4;
  double[distance(mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, 3.0lf), 0.6666666666666666lf), dvec2(-1.3333333333333333lf, 2.666666666666667lf)) <= 2.9814239699997203e-05lf ? 1 : -1] array5;
  double[distance(mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, 3.0lf), 1.0lf), dvec2(-3.0lf, 3.0lf)) <= 4.2426406871192855e-05lf ? 1 : -1] array6;
  double[distance(mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, 3.0lf), 1.0lf), dvec2(-3.0lf, 3.0lf)) <= 4.2426406871192855e-05lf ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
