/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 ^ (~ abs(ivec2(38, 35)))) => ivec2(-43, -48)
 * (12 ^ (~ abs(ivec2(64, -9)))) => ivec2(-77, -6)
 * (12 ^ (~ abs(ivec2(64, 9)))) => ivec2(-77, -6)
 * (-6 ^ (~ abs(ivec2(38, 35)))) => ivec2(35, 38)
 * (-6 ^ (~ abs(ivec2(64, -9)))) => ivec2(69, 12)
 * (-6 ^ (~ abs(ivec2(64, 9)))) => ivec2(69, 12)
 * (76 ^ (~ abs(ivec2(38, 35)))) => ivec2(-107, -112)
 * (76 ^ (~ abs(ivec2(64, -9)))) => ivec2(-13, -70)
 * (76 ^ (~ abs(ivec2(64, 9)))) => ivec2(-13, -70)
 * (-32 ^ (~ abs(ivec2(38, 35)))) => ivec2(57, 60)
 * (-32 ^ (~ abs(ivec2(64, -9)))) => ivec2(95, 22)
 * (-32 ^ (~ abs(ivec2(64, 9)))) => ivec2(95, 22)
 * (0 ^ (~ abs(ivec2(38, 35)))) => ivec2(-39, -36)
 * (0 ^ (~ abs(ivec2(64, -9)))) => ivec2(-65, -10)
 * (0 ^ (~ abs(ivec2(64, 9)))) => ivec2(-65, -10)
 */
#version 150

void main()
{
  float[all(equal((12 ^ (~ abs(ivec2(38, 35)))), ivec2(-43, -48))) ? 1 : -1] array0;
  float[all(equal((12 ^ (~ abs(ivec2(64, -9)))), ivec2(-77, -6))) ? 1 : -1] array1;
  float[all(equal((12 ^ (~ abs(ivec2(64, 9)))), ivec2(-77, -6))) ? 1 : -1] array2;
  float[all(equal((-6 ^ (~ abs(ivec2(38, 35)))), ivec2(35, 38))) ? 1 : -1] array3;
  float[all(equal((-6 ^ (~ abs(ivec2(64, -9)))), ivec2(69, 12))) ? 1 : -1] array4;
  float[all(equal((-6 ^ (~ abs(ivec2(64, 9)))), ivec2(69, 12))) ? 1 : -1] array5;
  float[all(equal((76 ^ (~ abs(ivec2(38, 35)))), ivec2(-107, -112))) ? 1 : -1] array6;
  float[all(equal((76 ^ (~ abs(ivec2(64, -9)))), ivec2(-13, -70))) ? 1 : -1] array7;
  float[all(equal((76 ^ (~ abs(ivec2(64, 9)))), ivec2(-13, -70))) ? 1 : -1] array8;
  float[all(equal((-32 ^ (~ abs(ivec2(38, 35)))), ivec2(57, 60))) ? 1 : -1] array9;
  float[all(equal((-32 ^ (~ abs(ivec2(64, -9)))), ivec2(95, 22))) ? 1 : -1] array10;
  float[all(equal((-32 ^ (~ abs(ivec2(64, 9)))), ivec2(95, 22))) ? 1 : -1] array11;
  float[all(equal((0 ^ (~ abs(ivec2(38, 35)))), ivec2(-39, -36))) ? 1 : -1] array12;
  float[all(equal((0 ^ (~ abs(ivec2(64, -9)))), ivec2(-65, -10))) ? 1 : -1] array13;
  float[all(equal((0 ^ (~ abs(ivec2(64, 9)))), ivec2(-65, -10))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
