/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(vec4(-2.0, -2.0, 2.0, 2.0), vec4(-3.0, 3.0, -3.0, 3.0), 0.0) => vec4(-2.0, -2.0, 2.0, 2.0)
 * mix(vec4(-2.0, -2.0, 2.0, 2.0), vec4(-3.0, 3.0, -3.0, 3.0), 0.33333334) => vec4(-2.3333333, -0.33333328, 0.33333328, 2.3333333)
 * mix(vec4(-2.0, -2.0, 2.0, 2.0), vec4(-3.0, 3.0, -3.0, 3.0), 0.6666667) => vec4(-2.6666667, 1.3333335, -1.3333335, 2.6666667)
 * mix(vec4(-2.0, -2.0, 2.0, 2.0), vec4(-3.0, 3.0, -3.0, 3.0), 1.0) => vec4(-3.0, 3.0, -3.0, 3.0)
 */
#version 150

void main()
{
  float[distance(mix(vec4(-2.0, -2.0, 2.0, 2.0), vec4(-3.0, 3.0, -3.0, 3.0), 0.0), vec4(-2.0, -2.0, 2.0, 2.0)) <= 4e-05 ? 1 : -1] array0;
  float[distance(mix(vec4(-2.0, -2.0, 2.0, 2.0), vec4(-3.0, 3.0, -3.0, 3.0), 0.33333334), vec4(-2.3333333, -0.33333328, 0.33333328, 2.3333333)) <= 3.3333334e-05 ? 1 : -1] array1;
  float[distance(mix(vec4(-2.0, -2.0, 2.0, 2.0), vec4(-3.0, 3.0, -3.0, 3.0), 0.6666667), vec4(-2.6666667, 1.3333335, -1.3333335, 2.6666667)) <= 4.2163705e-05 ? 1 : -1] array2;
  float[distance(mix(vec4(-2.0, -2.0, 2.0, 2.0), vec4(-3.0, 3.0, -3.0, 3.0), 1.0), vec4(-3.0, 3.0, -3.0, 3.0)) <= 6e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
