/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * greaterThan(vec3(-1.5, -1.5, -1.5), vec3(-1.5, -0.5, 0.5)) => bvec3(false, false, false)
 * greaterThan(vec3(-1.5, -0.5, -0.5), vec3(1.5, -1.5, -0.5)) => bvec3(false, true, false)
 * greaterThan(vec3(-0.5, -0.5, 0.5), vec3(0.5, 1.5, -1.5)) => bvec3(false, false, true)
 * greaterThan(vec3(0.5, 0.5, 0.5), vec3(-0.5, 0.5, 1.5)) => bvec3(true, false, false)
 * greaterThan(vec3(1.5, 1.5, 1.5), vec3(-1.5, -0.5, 0.5)) => bvec3(true, true, true)
 * greaterThan(vec3(1.5, -1.5, -1.5), vec3(1.5, -1.5, -0.5)) => bvec3(false, false, false)
 */
#version 150

void main()
{
  float[all(equal(greaterThan(vec3(-1.5, -1.5, -1.5), vec3(-1.5, -0.5, 0.5)), bvec3(false, false, false))) ? 1 : -1] array0;
  float[all(equal(greaterThan(vec3(-1.5, -0.5, -0.5), vec3(1.5, -1.5, -0.5)), bvec3(false, true, false))) ? 1 : -1] array1;
  float[all(equal(greaterThan(vec3(-0.5, -0.5, 0.5), vec3(0.5, 1.5, -1.5)), bvec3(false, false, true))) ? 1 : -1] array2;
  float[all(equal(greaterThan(vec3(0.5, 0.5, 0.5), vec3(-0.5, 0.5, 1.5)), bvec3(true, false, false))) ? 1 : -1] array3;
  float[all(equal(greaterThan(vec3(1.5, 1.5, 1.5), vec3(-1.5, -0.5, 0.5)), bvec3(true, true, true))) ? 1 : -1] array4;
  float[all(equal(greaterThan(vec3(1.5, -1.5, -1.5), vec3(1.5, -1.5, -0.5)), bvec3(false, false, false))) ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
