/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * tanh(-2.0) => -0.9640276
 * tanh(-0.6666667) => -0.582783
 * tanh(0.6666667) => 0.582783
 * tanh(2.0) => 0.9640276
 */
#version 130

void main()
{
  float[distance(tanh(-2.0), -0.9640276) <= 0.0009640276 ? 1 : -1] array0;
  float[distance(tanh(-0.6666667), -0.582783) <= 0.00058278296 ? 1 : -1] array1;
  float[distance(tanh(0.6666667), 0.582783) <= 0.00058278296 ? 1 : -1] array2;
  float[distance(tanh(2.0), 0.9640276) <= 0.0009640276 ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
