/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec2(13u, 26u) << 0u) => uvec2(13u, 26u)
 * (uvec2(13u, 26u) << 1u) => uvec2(26u, 52u)
 * (uvec2(13u, 26u) << 2u) => uvec2(52u, 104u)
 * (uvec2(13u, 26u) << 5u) => uvec2(416u, 832u)
 * (uvec2(13u, 26u) << 25u) => uvec2(436207616u, 872415232u)
 * (uvec2(13u, 26u) << 31u) => uvec2(2147483648u, 0u)
 * (uvec2(2u, 26u) << 0u) => uvec2(2u, 26u)
 * (uvec2(2u, 26u) << 1u) => uvec2(4u, 52u)
 * (uvec2(2u, 26u) << 2u) => uvec2(8u, 104u)
 * (uvec2(2u, 26u) << 5u) => uvec2(64u, 832u)
 * (uvec2(2u, 26u) << 25u) => uvec2(67108864u, 872415232u)
 * (uvec2(2u, 26u) << 31u) => uvec2(0u, 0u)
 */
#version 130

void main()
{
  float[all(equal((uvec2(13u, 26u) << 0u), uvec2(13u, 26u))) ? 1 : -1] array0;
  float[all(equal((uvec2(13u, 26u) << 1u), uvec2(26u, 52u))) ? 1 : -1] array1;
  float[all(equal((uvec2(13u, 26u) << 2u), uvec2(52u, 104u))) ? 1 : -1] array2;
  float[all(equal((uvec2(13u, 26u) << 5u), uvec2(416u, 832u))) ? 1 : -1] array3;
  float[all(equal((uvec2(13u, 26u) << 25u), uvec2(436207616u, 872415232u))) ? 1 : -1] array4;
  float[all(equal((uvec2(13u, 26u) << 31u), uvec2(2147483648u, 0u))) ? 1 : -1] array5;
  float[all(equal((uvec2(2u, 26u) << 0u), uvec2(2u, 26u))) ? 1 : -1] array6;
  float[all(equal((uvec2(2u, 26u) << 1u), uvec2(4u, 52u))) ? 1 : -1] array7;
  float[all(equal((uvec2(2u, 26u) << 2u), uvec2(8u, 104u))) ? 1 : -1] array8;
  float[all(equal((uvec2(2u, 26u) << 5u), uvec2(64u, 832u))) ? 1 : -1] array9;
  float[all(equal((uvec2(2u, 26u) << 25u), uvec2(67108864u, 872415232u))) ? 1 : -1] array10;
  float[all(equal((uvec2(2u, 26u) << 31u), uvec2(0u, 0u))) ? 1 : -1] array11;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
