/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u ^ (- uvec3(36u, 32u, 88u))) => uvec3(4294967260u, 4294967264u, 4294967208u)
 * (0u ^ (- uvec3(59u, 77u, 68u))) => uvec3(4294967237u, 4294967219u, 4294967228u)
 * (6u ^ (- uvec3(36u, 32u, 88u))) => uvec3(4294967258u, 4294967270u, 4294967214u)
 * (6u ^ (- uvec3(59u, 77u, 68u))) => uvec3(4294967235u, 4294967221u, 4294967226u)
 * (12u ^ (- uvec3(36u, 32u, 88u))) => uvec3(4294967248u, 4294967276u, 4294967204u)
 * (12u ^ (- uvec3(59u, 77u, 68u))) => uvec3(4294967241u, 4294967231u, 4294967216u)
 * (32u ^ (- uvec3(36u, 32u, 88u))) => uvec3(4294967292u, 4294967232u, 4294967176u)
 * (32u ^ (- uvec3(59u, 77u, 68u))) => uvec3(4294967269u, 4294967187u, 4294967196u)
 * (74u ^ (- uvec3(36u, 32u, 88u))) => uvec3(4294967190u, 4294967210u, 4294967266u)
 * (74u ^ (- uvec3(59u, 77u, 68u))) => uvec3(4294967183u, 4294967289u, 4294967286u)
 */
#version 130

void main()
{
  float[all(equal((0u ^ (- uvec3(36u, 32u, 88u))), uvec3(4294967260u, 4294967264u, 4294967208u))) ? 1 : -1] array0;
  float[all(equal((0u ^ (- uvec3(59u, 77u, 68u))), uvec3(4294967237u, 4294967219u, 4294967228u))) ? 1 : -1] array1;
  float[all(equal((6u ^ (- uvec3(36u, 32u, 88u))), uvec3(4294967258u, 4294967270u, 4294967214u))) ? 1 : -1] array2;
  float[all(equal((6u ^ (- uvec3(59u, 77u, 68u))), uvec3(4294967235u, 4294967221u, 4294967226u))) ? 1 : -1] array3;
  float[all(equal((12u ^ (- uvec3(36u, 32u, 88u))), uvec3(4294967248u, 4294967276u, 4294967204u))) ? 1 : -1] array4;
  float[all(equal((12u ^ (- uvec3(59u, 77u, 68u))), uvec3(4294967241u, 4294967231u, 4294967216u))) ? 1 : -1] array5;
  float[all(equal((32u ^ (- uvec3(36u, 32u, 88u))), uvec3(4294967292u, 4294967232u, 4294967176u))) ? 1 : -1] array6;
  float[all(equal((32u ^ (- uvec3(59u, 77u, 68u))), uvec3(4294967269u, 4294967187u, 4294967196u))) ? 1 : -1] array7;
  float[all(equal((74u ^ (- uvec3(36u, 32u, 88u))), uvec3(4294967190u, 4294967210u, 4294967266u))) ? 1 : -1] array8;
  float[all(equal((74u ^ (- uvec3(59u, 77u, 68u))), uvec3(4294967183u, 4294967289u, 4294967286u))) ? 1 : -1] array9;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
