/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 / ivec2(38, 35)) => ivec2(0, 0)
 * (12 / ivec2(64, -9)) => ivec2(0, -1)
 * (12 / ivec2(64, 9)) => ivec2(0, 1)
 * (-6 / ivec2(38, 35)) => ivec2(0, 0)
 * (-6 / ivec2(64, -9)) => ivec2(0, 0)
 * (-6 / ivec2(64, 9)) => ivec2(0, 0)
 * (76 / ivec2(38, 35)) => ivec2(2, 2)
 * (76 / ivec2(64, -9)) => ivec2(1, -8)
 * (76 / ivec2(64, 9)) => ivec2(1, 8)
 * (-32 / ivec2(38, 35)) => ivec2(0, 0)
 * (-32 / ivec2(64, -9)) => ivec2(0, 3)
 * (-32 / ivec2(64, 9)) => ivec2(0, -3)
 * (0 / ivec2(38, 35)) => ivec2(0, 0)
 * (0 / ivec2(64, -9)) => ivec2(0, 0)
 * (0 / ivec2(64, 9)) => ivec2(0, 0)
 */
#version 120

void main()
{
  float[all(equal((12 / ivec2(38, 35)), ivec2(0, 0))) ? 1 : -1] array0;
  float[all(equal((12 / ivec2(64, -9)), ivec2(0, -1))) ? 1 : -1] array1;
  float[all(equal((12 / ivec2(64, 9)), ivec2(0, 1))) ? 1 : -1] array2;
  float[all(equal((-6 / ivec2(38, 35)), ivec2(0, 0))) ? 1 : -1] array3;
  float[all(equal((-6 / ivec2(64, -9)), ivec2(0, 0))) ? 1 : -1] array4;
  float[all(equal((-6 / ivec2(64, 9)), ivec2(0, 0))) ? 1 : -1] array5;
  float[all(equal((76 / ivec2(38, 35)), ivec2(2, 2))) ? 1 : -1] array6;
  float[all(equal((76 / ivec2(64, -9)), ivec2(1, -8))) ? 1 : -1] array7;
  float[all(equal((76 / ivec2(64, 9)), ivec2(1, 8))) ? 1 : -1] array8;
  float[all(equal((-32 / ivec2(38, 35)), ivec2(0, 0))) ? 1 : -1] array9;
  float[all(equal((-32 / ivec2(64, -9)), ivec2(0, 3))) ? 1 : -1] array10;
  float[all(equal((-32 / ivec2(64, 9)), ivec2(0, -3))) ? 1 : -1] array11;
  float[all(equal((0 / ivec2(38, 35)), ivec2(0, 0))) ? 1 : -1] array12;
  float[all(equal((0 / ivec2(64, -9)), ivec2(0, 0))) ? 1 : -1] array13;
  float[all(equal((0 / ivec2(64, 9)), ivec2(0, 0))) ? 1 : -1] array14;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
