/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l << 0) => 0l
 * (0l << 1) => 0l
 * (0l << 2) => 0l
 * (0l << 5) => 0l
 * (0l << 25) => 0l
 * (0l << 31) => 0l
 * (3l << 0) => 3l
 * (3l << 1) => 6l
 * (3l << 2) => 12l
 * (3l << 5) => 96l
 * (3l << 25) => 100663296l
 * (3l << 31) => 6442450944l
 * (-1192l << 0) => -1192l
 * (-1192l << 1) => -2384l
 * (-1192l << 2) => -4768l
 * (-1192l << 5) => -38144l
 * (-1192l << 25) => -39996882944l
 * (-1192l << 31) => -2559800508416l
 * (1048576l << 0) => 1048576l
 * (1048576l << 1) => 2097152l
 * (1048576l << 2) => 4194304l
 * (1048576l << 5) => 33554432l
 * (1048576l << 25) => 35184372088832l
 * (1048576l << 31) => 2251799813685248l
 * (4251475l << 0) => 4251475l
 * (4251475l << 1) => 8502950l
 * (4251475l << 2) => 17005900l
 * (4251475l << 5) => 136047200l
 * (4251475l << 25) => 142655828787200l
 * (4251475l << 31) => 9129973042380800l
 * (29852643761l << 0) => 29852643761l
 * (29852643761l << 1) => 59705287522l
 * (29852643761l << 2) => 119410575044l
 * (29852643761l << 5) => 955284600352l
 * (29852643761l << 25) => 1001688505098698752l
 * (29852643761l << 31) => 8767832105188065280l
 * (-4398046511104l << 0) => -4398046511104l
 * (-4398046511104l << 1) => -8796093022208l
 * (-4398046511104l << 2) => -17592186044416l
 * (-4398046511104l << 5) => -140737488355328l
 * (-4398046511104l << 25) => 0l
 * (-4398046511104l << 31) => 0l
 * (-3948976685146l << 0) => -3948976685146l
 * (-3948976685146l << 1) => -7897953370292l
 * (-3948976685146l << 2) => -15795906740584l
 * (-3948976685146l << 5) => -126367253924672l
 * (-3948976685146l << 25) => -3378461135350005760l
 * (-3948976685146l << 31) => 5139416222114250752l
 * (-135763469567146206l << 0) => -135763469567146206l
 * (-135763469567146206l << 1) => -271526939134292412l
 * (-135763469567146206l << 2) => -543053878268584824l
 * (-135763469567146206l << 5) => -4344431026148678592l
 * (-135763469567146206l << 25) => -5765184155612610560l
 * (-135763469567146206l << 31) => -36904485016043520l
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[(0l << 0) == 0l ? 1 : -1] array0;
  float[(0l << 1) == 0l ? 1 : -1] array1;
  float[(0l << 2) == 0l ? 1 : -1] array2;
  float[(0l << 5) == 0l ? 1 : -1] array3;
  float[(0l << 25) == 0l ? 1 : -1] array4;
  float[(0l << 31) == 0l ? 1 : -1] array5;
  float[(3l << 0) == 3l ? 1 : -1] array6;
  float[(3l << 1) == 6l ? 1 : -1] array7;
  float[(3l << 2) == 12l ? 1 : -1] array8;
  float[(3l << 5) == 96l ? 1 : -1] array9;
  float[(3l << 25) == 100663296l ? 1 : -1] array10;
  float[(3l << 31) == 6442450944l ? 1 : -1] array11;
  float[(-1192l << 0) == -1192l ? 1 : -1] array12;
  float[(-1192l << 1) == -2384l ? 1 : -1] array13;
  float[(-1192l << 2) == -4768l ? 1 : -1] array14;
  float[(-1192l << 5) == -38144l ? 1 : -1] array15;
  float[(-1192l << 25) == -39996882944l ? 1 : -1] array16;
  float[(-1192l << 31) == -2559800508416l ? 1 : -1] array17;
  float[(1048576l << 0) == 1048576l ? 1 : -1] array18;
  float[(1048576l << 1) == 2097152l ? 1 : -1] array19;
  float[(1048576l << 2) == 4194304l ? 1 : -1] array20;
  float[(1048576l << 5) == 33554432l ? 1 : -1] array21;
  float[(1048576l << 25) == 35184372088832l ? 1 : -1] array22;
  float[(1048576l << 31) == 2251799813685248l ? 1 : -1] array23;
  float[(4251475l << 0) == 4251475l ? 1 : -1] array24;
  float[(4251475l << 1) == 8502950l ? 1 : -1] array25;
  float[(4251475l << 2) == 17005900l ? 1 : -1] array26;
  float[(4251475l << 5) == 136047200l ? 1 : -1] array27;
  float[(4251475l << 25) == 142655828787200l ? 1 : -1] array28;
  float[(4251475l << 31) == 9129973042380800l ? 1 : -1] array29;
  float[(29852643761l << 0) == 29852643761l ? 1 : -1] array30;
  float[(29852643761l << 1) == 59705287522l ? 1 : -1] array31;
  float[(29852643761l << 2) == 119410575044l ? 1 : -1] array32;
  float[(29852643761l << 5) == 955284600352l ? 1 : -1] array33;
  float[(29852643761l << 25) == 1001688505098698752l ? 1 : -1] array34;
  float[(29852643761l << 31) == 8767832105188065280l ? 1 : -1] array35;
  float[(-4398046511104l << 0) == -4398046511104l ? 1 : -1] array36;
  float[(-4398046511104l << 1) == -8796093022208l ? 1 : -1] array37;
  float[(-4398046511104l << 2) == -17592186044416l ? 1 : -1] array38;
  float[(-4398046511104l << 5) == -140737488355328l ? 1 : -1] array39;
  float[(-4398046511104l << 25) == 0l ? 1 : -1] array40;
  float[(-4398046511104l << 31) == 0l ? 1 : -1] array41;
  float[(-3948976685146l << 0) == -3948976685146l ? 1 : -1] array42;
  float[(-3948976685146l << 1) == -7897953370292l ? 1 : -1] array43;
  float[(-3948976685146l << 2) == -15795906740584l ? 1 : -1] array44;
  float[(-3948976685146l << 5) == -126367253924672l ? 1 : -1] array45;
  float[(-3948976685146l << 25) == -3378461135350005760l ? 1 : -1] array46;
  float[(-3948976685146l << 31) == 5139416222114250752l ? 1 : -1] array47;
  float[(-135763469567146206l << 0) == -135763469567146206l ? 1 : -1] array48;
  float[(-135763469567146206l << 1) == -271526939134292412l ? 1 : -1] array49;
  float[(-135763469567146206l << 2) == -543053878268584824l ? 1 : -1] array50;
  float[(-135763469567146206l << 5) == -4344431026148678592l ? 1 : -1] array51;
  float[(-135763469567146206l << 25) == -5765184155612610560l ? 1 : -1] array52;
  float[(-135763469567146206l << 31) == -36904485016043520l ? 1 : -1] array53;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length() + array36.length() + array37.length() + array38.length() + array39.length() + array40.length() + array41.length() + array42.length() + array43.length() + array44.length() + array45.length() + array46.length() + array47.length() + array48.length() + array49.length() + array50.length() + array51.length() + array52.length() + array53.length());
}
