/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * inversesqrt(dvec3(0.1lf, 0.7333333333333333lf, 1.3666666666666667lf)) => dvec3(3.162277660168379lf, 1.1677484162422846lf, 0.8553989227683015lf)
 * inversesqrt(dvec3(2.0lf, 0.1lf, 0.7333333333333333lf)) => dvec3(0.7071067811865475lf, 3.162277660168379lf, 1.1677484162422846lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(inversesqrt(dvec3(0.1lf, 0.7333333333333333lf, 1.3666666666666667lf)), dvec3(3.162277660168379lf, 1.1677484162422846lf, 0.8553989227683015lf)) <= 3.477836062943384e-05lf ? 1 : -1] array0;
  double[distance(inversesqrt(dvec3(2.0lf, 0.1lf, 0.7333333333333333lf)), dvec3(0.7071067811865475lf, 3.162277660168379lf, 1.1677484162422846lf)) <= 3.4443629837222974e-05lf ? 1 : -1] array1;
  gl_Position = vec4(array0.length() + array1.length());
}
