/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_AMD_shader_trinary_minmax
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * min3(ivec4(-5, -5, -5, -5), ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -5, -5, -5), ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-5, -2, -2, -2), ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-2, -2, -2, -2), ivec4(-5, -5, -5, -5), ivec4(0, 1, 2, 5)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-2, -2, -2, -2), ivec4(-2, -2, -2, -2), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -2, -2)
 * min3(ivec4(-2, -2, -2, -2), ivec4(-2, -2, -2, -1), ivec4(1, 2, 5, -5)) => ivec4(-2, -2, -2, -5)
 * min3(ivec4(-2, -2, -2, -2), ivec4(-1, -1, -1, -1), ivec4(-2, -1, 0, 1)) => ivec4(-2, -2, -2, -2)
 * min3(ivec4(-2, -2, -2, -2), ivec4(-1, -1, 0, 0), ivec4(2, 5, -5, -2)) => ivec4(-2, -2, -5, -2)
 * min3(ivec4(-2, -2, -2, -2), ivec4(0, 0, 0, 0), ivec4(-1, 0, 1, 2)) => ivec4(-2, -2, -2, -2)
 * min3(ivec4(-2, -2, -2, -2), ivec4(0, 1, 1, 1), ivec4(5, -5, -2, -1)) => ivec4(-2, -5, -2, -2)
 * min3(ivec4(-2, -2, -2, -2), ivec4(1, 1, 1, 1), ivec4(0, 1, 2, 5)) => ivec4(-2, -2, -2, -2)
 * min3(ivec4(-2, -2, -2, -2), ivec4(2, 2, 2, 2), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -2, -2)
 * min3(ivec4(-2, -2, -2, -2), ivec4(2, 2, 2, 5), ivec4(1, 2, 5, -5)) => ivec4(-2, -2, -2, -5)
 * min3(ivec4(-2, -2, -2, -2), ivec4(5, 5, 5, 5), ivec4(-2, -1, 0, 1)) => ivec4(-2, -2, -2, -2)
 * min3(ivec4(-2, -2, -1, -1), ivec4(5, 5, -5, -5), ivec4(2, 5, -5, -2)) => ivec4(-2, -2, -5, -5)
 * min3(ivec4(-1, -1, -1, -1), ivec4(-5, -5, -5, -5), ivec4(-1, 0, 1, 2)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(-1, -1, -1, -1), ivec4(-5, -2, -2, -2), ivec4(5, -5, -2, -1)) => ivec4(-5, -5, -2, -2)
 * min3(ivec4(-1, -1, -1, -1), ivec4(-2, -2, -2, -2), ivec4(0, 1, 2, 5)) => ivec4(-2, -2, -2, -2)
 * min3(ivec4(-1, -1, -1, -1), ivec4(-1, -1, -1, -1), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -1, -1)
 * min3(ivec4(-1, -1, -1, -1), ivec4(-1, -1, -1, 0), ivec4(1, 2, 5, -5)) => ivec4(-1, -1, -1, -5)
 * min3(ivec4(-1, -1, -1, -1), ivec4(0, 0, 0, 0), ivec4(-2, -1, 0, 1)) => ivec4(-2, -1, -1, -1)
 * min3(ivec4(-1, -1, -1, -1), ivec4(0, 0, 1, 1), ivec4(2, 5, -5, -2)) => ivec4(-1, -1, -5, -2)
 * min3(ivec4(-1, -1, -1, -1), ivec4(1, 1, 1, 1), ivec4(-1, 0, 1, 2)) => ivec4(-1, -1, -1, -1)
 * min3(ivec4(-1, -1, -1, -1), ivec4(1, 2, 2, 2), ivec4(5, -5, -2, -1)) => ivec4(-1, -5, -2, -1)
 * min3(ivec4(-1, -1, -1, -1), ivec4(2, 2, 2, 2), ivec4(0, 1, 2, 5)) => ivec4(-1, -1, -1, -1)
 * min3(ivec4(-1, -1, -1, -1), ivec4(5, 5, 5, 5), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -1, -1)
 * min3(ivec4(-1, -1, -1, 0), ivec4(5, 5, 5, -5), ivec4(1, 2, 5, -5)) => ivec4(-1, -1, -1, -5)
 * min3(ivec4(0, 0, 0, 0), ivec4(-5, -5, -5, -5), ivec4(-2, -1, 0, 1)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(0, 0, 0, 0), ivec4(-5, -5, -2, -2), ivec4(2, 5, -5, -2)) => ivec4(-5, -5, -5, -2)
 * min3(ivec4(0, 0, 0, 0), ivec4(-2, -2, -2, -2), ivec4(-1, 0, 1, 2)) => ivec4(-2, -2, -2, -2)
 * min3(ivec4(0, 0, 0, 0), ivec4(-2, -1, -1, -1), ivec4(5, -5, -2, -1)) => ivec4(-2, -5, -2, -1)
 * min3(ivec4(0, 0, 0, 0), ivec4(-1, -1, -1, -1), ivec4(0, 1, 2, 5)) => ivec4(-1, -1, -1, -1)
 * min3(ivec4(0, 0, 0, 0), ivec4(0, 0, 0, 0), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -1, 0)
 * min3(ivec4(0, 0, 0, 0), ivec4(0, 0, 0, 1), ivec4(1, 2, 5, -5)) => ivec4(0, 0, 0, -5)
 * min3(ivec4(0, 0, 0, 0), ivec4(1, 1, 1, 1), ivec4(-2, -1, 0, 1)) => ivec4(-2, -1, 0, 0)
 * min3(ivec4(0, 0, 0, 0), ivec4(1, 1, 2, 2), ivec4(2, 5, -5, -2)) => ivec4(0, 0, -5, -2)
 * min3(ivec4(0, 0, 0, 0), ivec4(2, 2, 2, 2), ivec4(-1, 0, 1, 2)) => ivec4(-1, 0, 0, 0)
 * min3(ivec4(0, 0, 0, 0), ivec4(2, 5, 5, 5), ivec4(5, -5, -2, -1)) => ivec4(0, -5, -2, -1)
 * min3(ivec4(0, 0, 0, 0), ivec4(5, 5, 5, 5), ivec4(0, 1, 2, 5)) => ivec4(0, 0, 0, 0)
 * min3(ivec4(1, 1, 1, 1), ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(1, 1, 1, 1), ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(1, 1, 1, 1), ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1)) => ivec4(-2, -2, -2, -2)
 * min3(ivec4(1, 1, 1, 1), ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2)) => ivec4(-2, -2, -5, -2)
 * min3(ivec4(1, 1, 1, 1), ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2)) => ivec4(-1, -1, -1, -1)
 * min3(ivec4(1, 1, 1, 1), ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1)) => ivec4(-1, -5, -2, -1)
 * min3(ivec4(1, 1, 1, 1), ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5)) => ivec4(0, 0, 0, 0)
 * min3(ivec4(1, 1, 1, 1), ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -1, 0)
 * min3(ivec4(1, 1, 1, 1), ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5)) => ivec4(1, 1, 1, -5)
 * min3(ivec4(1, 1, 1, 1), ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1)) => ivec4(-2, -1, 0, 1)
 * min3(ivec4(1, 1, 1, 1), ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2)) => ivec4(1, 1, -5, -2)
 * min3(ivec4(1, 1, 1, 1), ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2)) => ivec4(-1, 0, 1, 1)
 * min3(ivec4(1, 2, 2, 2), ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1)) => ivec4(1, -5, -5, -5)
 * min3(ivec4(2, 2, 2, 2), ivec4(-5, -5, -5, -5), ivec4(0, 1, 2, 5)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(2, 2, 2, 2), ivec4(-2, -2, -2, -2), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -2, -2)
 * min3(ivec4(2, 2, 2, 2), ivec4(-2, -2, -2, -1), ivec4(1, 2, 5, -5)) => ivec4(-2, -2, -2, -5)
 * min3(ivec4(2, 2, 2, 2), ivec4(-1, -1, -1, -1), ivec4(-2, -1, 0, 1)) => ivec4(-2, -1, -1, -1)
 * min3(ivec4(2, 2, 2, 2), ivec4(-1, -1, 0, 0), ivec4(2, 5, -5, -2)) => ivec4(-1, -1, -5, -2)
 * min3(ivec4(2, 2, 2, 2), ivec4(0, 0, 0, 0), ivec4(-1, 0, 1, 2)) => ivec4(-1, 0, 0, 0)
 * min3(ivec4(2, 2, 2, 2), ivec4(0, 1, 1, 1), ivec4(5, -5, -2, -1)) => ivec4(0, -5, -2, -1)
 * min3(ivec4(2, 2, 2, 2), ivec4(1, 1, 1, 1), ivec4(0, 1, 2, 5)) => ivec4(0, 1, 1, 1)
 * min3(ivec4(2, 2, 2, 2), ivec4(2, 2, 2, 2), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -1, 0)
 * min3(ivec4(2, 2, 2, 2), ivec4(2, 2, 2, 5), ivec4(1, 2, 5, -5)) => ivec4(1, 2, 2, -5)
 * min3(ivec4(2, 2, 2, 2), ivec4(5, 5, 5, 5), ivec4(-2, -1, 0, 1)) => ivec4(-2, -1, 0, 1)
 * min3(ivec4(2, 2, 5, 5), ivec4(5, 5, -5, -5), ivec4(2, 5, -5, -2)) => ivec4(2, 2, -5, -5)
 * min3(ivec4(5, 5, 5, 5), ivec4(-5, -5, -5, -5), ivec4(-1, 0, 1, 2)) => ivec4(-5, -5, -5, -5)
 * min3(ivec4(5, 5, 5, 5), ivec4(-5, -2, -2, -2), ivec4(5, -5, -2, -1)) => ivec4(-5, -5, -2, -2)
 * min3(ivec4(5, 5, 5, 5), ivec4(-2, -2, -2, -2), ivec4(0, 1, 2, 5)) => ivec4(-2, -2, -2, -2)
 * min3(ivec4(5, 5, 5, 5), ivec4(-1, -1, -1, -1), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -1, -1)
 * min3(ivec4(5, 5, 5, 5), ivec4(-1, -1, -1, 0), ivec4(1, 2, 5, -5)) => ivec4(-1, -1, -1, -5)
 * min3(ivec4(5, 5, 5, 5), ivec4(0, 0, 0, 0), ivec4(-2, -1, 0, 1)) => ivec4(-2, -1, 0, 0)
 * min3(ivec4(5, 5, 5, 5), ivec4(0, 0, 1, 1), ivec4(2, 5, -5, -2)) => ivec4(0, 0, -5, -2)
 * min3(ivec4(5, 5, 5, 5), ivec4(1, 1, 1, 1), ivec4(-1, 0, 1, 2)) => ivec4(-1, 0, 1, 1)
 * min3(ivec4(5, 5, 5, 5), ivec4(1, 2, 2, 2), ivec4(5, -5, -2, -1)) => ivec4(1, -5, -2, -1)
 * min3(ivec4(5, 5, 5, 5), ivec4(2, 2, 2, 2), ivec4(0, 1, 2, 5)) => ivec4(0, 1, 2, 2)
 * min3(ivec4(5, 5, 5, 5), ivec4(5, 5, 5, 5), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -1, 0)
 * min3(ivec4(5, 5, 5, -5), ivec4(5, 5, 5, -5), ivec4(1, 2, 5, -5)) => ivec4(1, 2, 5, -5)
 */
#version 150
#extension GL_AMD_shader_trinary_minmax : require

void main()
{
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array0;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array1;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array2;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array3;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array4;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array5;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array6;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array7;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array8;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array9;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array10;
  float[all(equal(min3(ivec4(-5, -5, -5, -5), ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array11;
  float[all(equal(min3(ivec4(-5, -2, -2, -2), ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array12;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(-5, -5, -5, -5), ivec4(0, 1, 2, 5)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array13;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(-2, -2, -2, -2), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -2, -2))) ? 1 : -1] array14;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(-2, -2, -2, -1), ivec4(1, 2, 5, -5)), ivec4(-2, -2, -2, -5))) ? 1 : -1] array15;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(-1, -1, -1, -1), ivec4(-2, -1, 0, 1)), ivec4(-2, -2, -2, -2))) ? 1 : -1] array16;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(-1, -1, 0, 0), ivec4(2, 5, -5, -2)), ivec4(-2, -2, -5, -2))) ? 1 : -1] array17;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(0, 0, 0, 0), ivec4(-1, 0, 1, 2)), ivec4(-2, -2, -2, -2))) ? 1 : -1] array18;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(0, 1, 1, 1), ivec4(5, -5, -2, -1)), ivec4(-2, -5, -2, -2))) ? 1 : -1] array19;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(1, 1, 1, 1), ivec4(0, 1, 2, 5)), ivec4(-2, -2, -2, -2))) ? 1 : -1] array20;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(2, 2, 2, 2), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -2, -2))) ? 1 : -1] array21;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(2, 2, 2, 5), ivec4(1, 2, 5, -5)), ivec4(-2, -2, -2, -5))) ? 1 : -1] array22;
  float[all(equal(min3(ivec4(-2, -2, -2, -2), ivec4(5, 5, 5, 5), ivec4(-2, -1, 0, 1)), ivec4(-2, -2, -2, -2))) ? 1 : -1] array23;
  float[all(equal(min3(ivec4(-2, -2, -1, -1), ivec4(5, 5, -5, -5), ivec4(2, 5, -5, -2)), ivec4(-2, -2, -5, -5))) ? 1 : -1] array24;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(-5, -5, -5, -5), ivec4(-1, 0, 1, 2)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array25;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(-5, -2, -2, -2), ivec4(5, -5, -2, -1)), ivec4(-5, -5, -2, -2))) ? 1 : -1] array26;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(-2, -2, -2, -2), ivec4(0, 1, 2, 5)), ivec4(-2, -2, -2, -2))) ? 1 : -1] array27;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(-1, -1, -1, -1), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -1, -1))) ? 1 : -1] array28;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(-1, -1, -1, 0), ivec4(1, 2, 5, -5)), ivec4(-1, -1, -1, -5))) ? 1 : -1] array29;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(0, 0, 0, 0), ivec4(-2, -1, 0, 1)), ivec4(-2, -1, -1, -1))) ? 1 : -1] array30;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(0, 0, 1, 1), ivec4(2, 5, -5, -2)), ivec4(-1, -1, -5, -2))) ? 1 : -1] array31;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(1, 1, 1, 1), ivec4(-1, 0, 1, 2)), ivec4(-1, -1, -1, -1))) ? 1 : -1] array32;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(1, 2, 2, 2), ivec4(5, -5, -2, -1)), ivec4(-1, -5, -2, -1))) ? 1 : -1] array33;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(2, 2, 2, 2), ivec4(0, 1, 2, 5)), ivec4(-1, -1, -1, -1))) ? 1 : -1] array34;
  float[all(equal(min3(ivec4(-1, -1, -1, -1), ivec4(5, 5, 5, 5), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -1, -1))) ? 1 : -1] array35;
  float[all(equal(min3(ivec4(-1, -1, -1, 0), ivec4(5, 5, 5, -5), ivec4(1, 2, 5, -5)), ivec4(-1, -1, -1, -5))) ? 1 : -1] array36;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(-5, -5, -5, -5), ivec4(-2, -1, 0, 1)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array37;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(-5, -5, -2, -2), ivec4(2, 5, -5, -2)), ivec4(-5, -5, -5, -2))) ? 1 : -1] array38;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(-2, -2, -2, -2), ivec4(-1, 0, 1, 2)), ivec4(-2, -2, -2, -2))) ? 1 : -1] array39;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(-2, -1, -1, -1), ivec4(5, -5, -2, -1)), ivec4(-2, -5, -2, -1))) ? 1 : -1] array40;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(-1, -1, -1, -1), ivec4(0, 1, 2, 5)), ivec4(-1, -1, -1, -1))) ? 1 : -1] array41;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(0, 0, 0, 0), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -1, 0))) ? 1 : -1] array42;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(0, 0, 0, 1), ivec4(1, 2, 5, -5)), ivec4(0, 0, 0, -5))) ? 1 : -1] array43;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(1, 1, 1, 1), ivec4(-2, -1, 0, 1)), ivec4(-2, -1, 0, 0))) ? 1 : -1] array44;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(1, 1, 2, 2), ivec4(2, 5, -5, -2)), ivec4(0, 0, -5, -2))) ? 1 : -1] array45;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(2, 2, 2, 2), ivec4(-1, 0, 1, 2)), ivec4(-1, 0, 0, 0))) ? 1 : -1] array46;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(2, 5, 5, 5), ivec4(5, -5, -2, -1)), ivec4(0, -5, -2, -1))) ? 1 : -1] array47;
  float[all(equal(min3(ivec4(0, 0, 0, 0), ivec4(5, 5, 5, 5), ivec4(0, 1, 2, 5)), ivec4(0, 0, 0, 0))) ? 1 : -1] array48;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array49;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array50;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1)), ivec4(-2, -2, -2, -2))) ? 1 : -1] array51;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2)), ivec4(-2, -2, -5, -2))) ? 1 : -1] array52;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2)), ivec4(-1, -1, -1, -1))) ? 1 : -1] array53;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1)), ivec4(-1, -5, -2, -1))) ? 1 : -1] array54;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5)), ivec4(0, 0, 0, 0))) ? 1 : -1] array55;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -1, 0))) ? 1 : -1] array56;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5)), ivec4(1, 1, 1, -5))) ? 1 : -1] array57;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1)), ivec4(-2, -1, 0, 1))) ? 1 : -1] array58;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2)), ivec4(1, 1, -5, -2))) ? 1 : -1] array59;
  float[all(equal(min3(ivec4(1, 1, 1, 1), ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2)), ivec4(-1, 0, 1, 1))) ? 1 : -1] array60;
  float[all(equal(min3(ivec4(1, 2, 2, 2), ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1)), ivec4(1, -5, -5, -5))) ? 1 : -1] array61;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(-5, -5, -5, -5), ivec4(0, 1, 2, 5)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array62;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(-2, -2, -2, -2), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -2, -2))) ? 1 : -1] array63;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(-2, -2, -2, -1), ivec4(1, 2, 5, -5)), ivec4(-2, -2, -2, -5))) ? 1 : -1] array64;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(-1, -1, -1, -1), ivec4(-2, -1, 0, 1)), ivec4(-2, -1, -1, -1))) ? 1 : -1] array65;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(-1, -1, 0, 0), ivec4(2, 5, -5, -2)), ivec4(-1, -1, -5, -2))) ? 1 : -1] array66;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(0, 0, 0, 0), ivec4(-1, 0, 1, 2)), ivec4(-1, 0, 0, 0))) ? 1 : -1] array67;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(0, 1, 1, 1), ivec4(5, -5, -2, -1)), ivec4(0, -5, -2, -1))) ? 1 : -1] array68;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(1, 1, 1, 1), ivec4(0, 1, 2, 5)), ivec4(0, 1, 1, 1))) ? 1 : -1] array69;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(2, 2, 2, 2), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -1, 0))) ? 1 : -1] array70;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(2, 2, 2, 5), ivec4(1, 2, 5, -5)), ivec4(1, 2, 2, -5))) ? 1 : -1] array71;
  float[all(equal(min3(ivec4(2, 2, 2, 2), ivec4(5, 5, 5, 5), ivec4(-2, -1, 0, 1)), ivec4(-2, -1, 0, 1))) ? 1 : -1] array72;
  float[all(equal(min3(ivec4(2, 2, 5, 5), ivec4(5, 5, -5, -5), ivec4(2, 5, -5, -2)), ivec4(2, 2, -5, -5))) ? 1 : -1] array73;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(-5, -5, -5, -5), ivec4(-1, 0, 1, 2)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array74;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(-5, -2, -2, -2), ivec4(5, -5, -2, -1)), ivec4(-5, -5, -2, -2))) ? 1 : -1] array75;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(-2, -2, -2, -2), ivec4(0, 1, 2, 5)), ivec4(-2, -2, -2, -2))) ? 1 : -1] array76;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(-1, -1, -1, -1), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -1, -1))) ? 1 : -1] array77;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(-1, -1, -1, 0), ivec4(1, 2, 5, -5)), ivec4(-1, -1, -1, -5))) ? 1 : -1] array78;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(0, 0, 0, 0), ivec4(-2, -1, 0, 1)), ivec4(-2, -1, 0, 0))) ? 1 : -1] array79;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(0, 0, 1, 1), ivec4(2, 5, -5, -2)), ivec4(0, 0, -5, -2))) ? 1 : -1] array80;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(1, 1, 1, 1), ivec4(-1, 0, 1, 2)), ivec4(-1, 0, 1, 1))) ? 1 : -1] array81;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(1, 2, 2, 2), ivec4(5, -5, -2, -1)), ivec4(1, -5, -2, -1))) ? 1 : -1] array82;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(2, 2, 2, 2), ivec4(0, 1, 2, 5)), ivec4(0, 1, 2, 2))) ? 1 : -1] array83;
  float[all(equal(min3(ivec4(5, 5, 5, 5), ivec4(5, 5, 5, 5), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -1, 0))) ? 1 : -1] array84;
  float[all(equal(min3(ivec4(5, 5, 5, -5), ivec4(5, 5, 5, -5), ivec4(1, 2, 5, -5)), ivec4(1, 2, 5, -5))) ? 1 : -1] array85;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length() + array36.length() + array37.length() + array38.length() + array39.length() + array40.length() + array41.length() + array42.length() + array43.length() + array44.length() + array45.length() + array46.length() + array47.length() + array48.length() + array49.length() + array50.length() + array51.length() + array52.length() + array53.length() + array54.length() + array55.length() + array56.length() + array57.length() + array58.length() + array59.length() + array60.length() + array61.length() + array62.length() + array63.length() + array64.length() + array65.length() + array66.length() + array67.length() + array68.length() + array69.length() + array70.length() + array71.length() + array72.length() + array73.length() + array74.length() + array75.length() + array76.length() + array77.length() + array78.length() + array79.length() + array80.length() + array81.length() + array82.length() + array83.length() + array84.length() + array85.length());
}
