/*
 * [config]
 * expect_result: fail
 * glsl_version: 1.50
 * require_extensions: GL_ARB_shader_image_load_store
 * [end config]
 */
#version 150
#extension GL_ARB_shader_image_load_store: require

/*
 * From the ARB_shader_image_load_store spec:
 *
 * "The 'IMAGE_INFO' placeholder is replaced by one of the following
 *  parameter lists:
 *       gimage1D image, int coord
 *       gimage2D image, ivec2 coord
 *       gimage3D image, ivec3 coord
 *       gimage2DRect image, ivec2 coord
 *       gimageCube image, ivec3 coord
 *       gimageBuffer image, int coord
 *       gimage1DArray image, ivec2 coord
 *       gimage2DArray image, ivec3 coord
 *       gimageCubeArray image, ivec3 coord
 *       gimage2DMS image, ivec2 coord, int sample
 *       gimage2DMSArray image, ivec3 coord, int sample"
 *
 * Pass an argument as address coordinate that doesn't match the
 * dimensionality of the specified image.
 */
layout(r32i) uniform iimageCubeArray img;

void main()
{
    imageAtomicMin(img , int(0) , int(0));
}
