/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.disposables;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Cancellable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class CancellableDisposable
extends AtomicReference<Cancellable>
implements Disposable {
    private static final long serialVersionUID = 5718521705281392066L;

    public CancellableDisposable(Cancellable cancellable) {
        super(cancellable);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == null;
    }

    @Override
    public void dispose() {
        Cancellable c;
        if (this.get() != null && (c = (Cancellable)this.getAndSet(null)) != null) {
            try {
                c.cancel();
            }
            catch (Exception ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }
    }
}

