/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.internal.engine.action;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.model.script.actions.Things;
import org.openhab.core.model.script.engine.action.ActionService;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.ThingStatusInfo;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.binding.ThingActions;
import org.openhab.core.thing.binding.ThingActionsScope;
import org.openhab.core.thing.binding.ThingHandler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(immediate=true)
public class ThingActionService
implements ActionService {
    private static final Map<String, ThingActions> THING_ACTIONS_MAP = new HashMap<String, ThingActions>();
    private static @Nullable ThingRegistry thingRegistry;

    @Activate
    public ThingActionService(@Reference ThingRegistry thingRegistry) {
        ThingActionService.thingRegistry = thingRegistry;
    }

    @Override
    public Class<?> getActionClass() {
        return Things.class;
    }

    public static @Nullable ThingStatusInfo getThingStatusInfo(String thingUid) {
        ThingUID uid = new ThingUID(thingUid);
        Thing thing = thingRegistry.get(uid);
        if (thing != null) {
            return thing.getStatusInfo();
        }
        return null;
    }

    public static @Nullable ThingActions getActions(String scope, String thingUid) {
        ThingHandler handler;
        ThingUID uid = new ThingUID(thingUid);
        Thing thing = thingRegistry.get(uid);
        if (thing != null && (handler = thing.getHandler()) != null) {
            return THING_ACTIONS_MAP.get(ThingActionService.getKey(scope, thingUid));
        }
        return null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    public void addThingActions(ThingActions thingActions) {
        String key = ThingActionService.getKey(thingActions);
        THING_ACTIONS_MAP.put(key, thingActions);
    }

    public void removeThingActions(ThingActions thingActions) {
        String key = ThingActionService.getKey(thingActions);
        THING_ACTIONS_MAP.remove(key);
    }

    private static String getKey(ThingActions thingActions) {
        String scope = ThingActionService.getScope(thingActions);
        String thingUID = ThingActionService.getThingUID(thingActions);
        return ThingActionService.getKey(scope, thingUID);
    }

    private static String getKey(String scope, String thingUID) {
        return scope + "-" + thingUID;
    }

    private static String getThingUID(ThingActions actions) {
        return actions.getThingHandler().getThing().getUID().getAsString();
    }

    private static String getScope(ThingActions actions) {
        ThingActionsScope scopeAnnotation = actions.getClass().getAnnotation(ThingActionsScope.class);
        return scopeAnnotation.name();
    }
}

