/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicMarkableReference;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.client.AbstractHttpClientTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.http2.client.http.HttpConnectionOverHTTP2;
import org.eclipse.jetty.http2.client.http.HttpDestinationOverHTTP2;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@ManagedObject(value="The HTTP/2 client transport")
public class HttpClientTransportOverHTTP2
extends AbstractHttpClientTransport {
    private final HTTP2Client client;
    private ClientConnectionFactory connectionFactory;
    private boolean useALPN = true;

    public HttpClientTransportOverHTTP2(HTTP2Client client) {
        this.client = client;
        this.setConnectionPoolFactory(destination -> {
            HttpClient httpClient = this.getHttpClient();
            return new MultiplexConnectionPool(destination, httpClient.getMaxConnectionsPerDestination(), (Callback)destination, 1);
        });
    }

    public HTTP2Client getHTTP2Client() {
        return this.client;
    }

    @ManagedAttribute(value="The number of selectors", readonly=true)
    public int getSelectors() {
        return this.client.getSelectors();
    }

    @ManagedAttribute(value="Whether ALPN should be used when establishing connections")
    public boolean isUseALPN() {
        return this.useALPN;
    }

    public void setUseALPN(boolean useALPN) {
        this.useALPN = useALPN;
    }

    protected void doStart() throws Exception {
        if (!this.client.isStarted()) {
            HttpClient httpClient = this.getHttpClient();
            this.client.setExecutor(httpClient.getExecutor());
            this.client.setScheduler(httpClient.getScheduler());
            this.client.setByteBufferPool(httpClient.getByteBufferPool());
            this.client.setConnectTimeout(httpClient.getConnectTimeout());
            this.client.setIdleTimeout(httpClient.getIdleTimeout());
            this.client.setInputBufferSize(httpClient.getResponseBufferSize());
            this.client.setConnectBlocking(httpClient.isConnectBlocking());
            this.client.setBindAddress(httpClient.getBindAddress());
            this.client.setTCPNoDelay(httpClient.isTCPNoDelay());
        }
        this.addBean(this.client);
        super.doStart();
        this.connectionFactory = new HTTP2ClientConnectionFactory();
        this.client.setClientConnectionFactory((endPoint, context) -> {
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            return destination.getClientConnectionFactory().newConnection(endPoint, context);
        });
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.client);
    }

    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP2(this.getHttpClient(), origin);
    }

    public void connect(InetSocketAddress address, Map<String, Object> context) {
        HttpClient httpClient = this.getHttpClient();
        this.client.setConnectTimeout(httpClient.getConnectTimeout());
        this.client.setConnectBlocking(httpClient.isConnectBlocking());
        this.client.setBindAddress(httpClient.getBindAddress());
        SessionListenerPromise listenerPromise = new SessionListenerPromise(context);
        HttpDestinationOverHTTP2 destination = (HttpDestinationOverHTTP2)((Object)context.get("http.destination"));
        SslContextFactory sslContextFactory = null;
        if (HttpScheme.HTTPS.is(destination.getScheme())) {
            sslContextFactory = httpClient.getSslContextFactory();
        }
        this.connect(sslContextFactory, address, (Session.Listener)listenerPromise, listenerPromise, context);
    }

    protected void connect(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        this.getHTTP2Client().connect(sslContextFactory, address, listener, promise, context);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        boolean ssl;
        endPoint.setIdleTimeout(this.getHttpClient().getIdleTimeout());
        ClientConnectionFactory factory = this.connectionFactory;
        HttpDestinationOverHTTP2 destination = (HttpDestinationOverHTTP2)((Object)context.get("http.destination"));
        ProxyConfiguration.Proxy proxy = destination.getProxy();
        boolean bl = ssl = proxy == null ? HttpScheme.HTTPS.is(destination.getScheme()) : proxy.isSecure();
        if (ssl && this.isUseALPN()) {
            factory = new ALPNClientConnectionFactory(this.client.getExecutor(), factory, this.client.getProtocols());
        }
        return factory.newConnection(endPoint, context);
    }

    protected HttpConnectionOverHTTP2 newHttpConnection(HttpDestination destination, Session session) {
        return new HttpConnectionOverHTTP2(destination, session);
    }

    protected void onClose(HttpConnectionOverHTTP2 connection, GoAwayFrame frame) {
        connection.close();
    }

    private class SessionListenerPromise
    extends Session.Listener.Adapter
    implements Promise<Session> {
        private final AtomicMarkableReference<HttpConnectionOverHTTP2> connection = new AtomicMarkableReference<Object>(null, false);
        private final Map<String, Object> context;

        private SessionListenerPromise(Map<String, Object> context) {
            this.context = context;
        }

        public void succeeded(Session session) {
        }

        public void failed(Throwable failure) {
            this.failConnectionPromise(failure);
        }

        private HttpDestinationOverHTTP2 destination() {
            return (HttpDestinationOverHTTP2)((Object)this.context.get("http.destination"));
        }

        private Promise<org.eclipse.jetty.client.api.Connection> connectionPromise() {
            return (Promise)this.context.get("http.connection.promise");
        }

        public void onSettings(Session session, SettingsFrame frame) {
            if (!this.connection.isMarked()) {
                this.onServerPreface(session);
            }
        }

        private void onServerPreface(Session session) {
            HttpConnectionOverHTTP2 connection = HttpClientTransportOverHTTP2.this.newHttpConnection((HttpDestination)this.destination(), session);
            if (this.connection.compareAndSet(null, connection, false, true)) {
                this.connectionPromise().succeeded((Object)connection);
            }
        }

        public void onGoAway(Session session, GoAwayFrame frame) {
            if (this.failConnectionPromise(new ClosedChannelException())) {
                return;
            }
            HttpConnectionOverHTTP2 connection = this.getConnection();
            if (connection != null) {
                connection.remove();
            }
        }

        public void onClose(Session session, GoAwayFrame frame) {
            if (this.failConnectionPromise(new ClosedChannelException())) {
                return;
            }
            HttpConnectionOverHTTP2 connection = this.getConnection();
            if (connection != null) {
                HttpClientTransportOverHTTP2.this.onClose(connection, frame);
            }
        }

        public boolean onIdleTimeout(Session session) {
            long idleTimeout = ((HTTP2Session)session).getEndPoint().getIdleTimeout();
            if (this.failConnectionPromise(new TimeoutException("Idle timeout expired: " + idleTimeout + " ms"))) {
                return true;
            }
            HttpConnectionOverHTTP2 connection = this.getConnection();
            if (connection != null) {
                return connection.onIdleTimeout(idleTimeout);
            }
            return true;
        }

        public void onFailure(Session session, Throwable failure) {
            if (this.failConnectionPromise(failure)) {
                return;
            }
            HttpConnectionOverHTTP2 connection = this.getConnection();
            if (connection != null) {
                connection.close(failure);
            }
        }

        private boolean failConnectionPromise(Throwable failure) {
            boolean result = this.connection.compareAndSet(null, null, false, true);
            if (result) {
                this.connectionPromise().failed(failure);
            }
            return result;
        }

        private HttpConnectionOverHTTP2 getConnection() {
            return this.connection.getReference();
        }
    }
}

