/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.types;

import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.types.State;

@NonNullByDefault
public class TimeSeries {
    private final TreeSet<Entry> states = new TreeSet<Entry>(Comparator.comparing(e -> e.timestamp));
    private final Policy policy;

    public TimeSeries(Policy policy) {
        this.policy = policy;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public Instant getBegin() {
        return this.states.isEmpty() ? Instant.MAX : this.states.first().timestamp();
    }

    public Instant getEnd() {
        return this.states.isEmpty() ? Instant.MIN : this.states.last().timestamp();
    }

    public int size() {
        return this.states.size();
    }

    public void add(Instant timestamp, State state) {
        this.states.add(new Entry(timestamp, state));
    }

    public Stream<Entry> getStates() {
        return List.copyOf(this.states).stream();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeries that = (TimeSeries)o;
        return Objects.equals(this.states, that.states) && this.policy == that.policy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.states, this.policy});
    }

    public record Entry(Instant timestamp, State state) {
    }

    public static enum Policy {
        ADD,
        REPLACE;

    }
}

