/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ShellUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

@Command(scope="bundle", name="find-class", description="Locates a specified class in any deployed bundle")
@Service
public class FindClass
implements Action {
    @Argument(index=0, name="className", description="Class name or partial class name to be found", required=true, multiValued=false)
    String className;
    @Reference
    BundleContext bundleContext;
    @Option(name="-v", aliases={}, description="Show more information about the classes/resource", required=false, multiValued=false)
    boolean verbose;

    public Object execute() throws Exception {
        this.findResource();
        return null;
    }

    protected void findResource() {
        String filter;
        String path;
        Bundle[] bundles = this.bundleContext.getBundles();
        int idx = this.className.lastIndexOf(46);
        if (idx >= 0) {
            path = this.className.substring(0, idx).replace('.', '/');
            if (path.isEmpty() || path.charAt(0) != '/') {
                path = "/" + path;
            }
            filter = this.className.substring(idx + 1) + ".class";
        } else {
            path = "/";
            filter = "*" + this.className + "*";
        }
        if (!this.verbose) {
            for (Bundle bundle : bundles) {
                BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                if (wiring != null) {
                    Collection resources = wiring.listResources(path, filter, 1);
                    if (resources.size() > 0) {
                        String title = ShellUtil.getBundleName((Bundle)bundle);
                        System.out.println("\n" + (String)title);
                    }
                    for (String resource : resources) {
                        System.out.println(resource);
                    }
                    continue;
                }
                System.out.println("Bundle " + bundle.getBundleId() + " is not resolved.");
            }
        } else {
            for (Bundle bundle : bundles) {
                BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                if (wiring != null) {
                    boolean hasResources;
                    List entries = wiring.findEntries(path, filter, 1);
                    boolean hasEntries = entries != null && !entries.isEmpty();
                    Collection resources = wiring.listResources(path, filter, 1);
                    boolean bl = hasResources = resources != null && !resources.isEmpty();
                    if (hasEntries || hasResources) {
                        String title = ShellUtil.getBundleName((Bundle)bundle);
                        System.out.println("\n" + (String)title);
                    }
                    if (hasEntries) {
                        System.out.println("  Resources from this bundle (and its fragments) content:");
                        for (URL entry : entries) {
                            System.out.println("    " + entry);
                        }
                    }
                    if (!hasResources) continue;
                    LinkedHashSet<String> reqBundles = new LinkedHashSet<String>();
                    LinkedHashSet<String> importedPackages = new LinkedHashSet<String>();
                    for (BundleWire bw : wiring.getRequiredWires(null)) {
                        BundleRevision rcap;
                        BundleCapability cap = bw.getCapability();
                        BundleRevision bundleRevision = rcap = cap == null ? null : cap.getResource();
                        if (cap == null || rcap == null || rcap.getWiring() == null || rcap.getWiring().getBundle() == null) continue;
                        Collection res = rcap.getWiring().listResources(path, filter, 1);
                        for (String r : res) {
                            if (cap.getNamespace().equals("osgi.wiring.package")) {
                                importedPackages.add("    " + r + " (visible through " + "osgi.wiring.package" + " from " + ShellUtil.getBundleName((Bundle)rcap.getWiring().getBundle()) + ")");
                                continue;
                            }
                            if (!cap.getNamespace().equals("osgi.wiring.bundle")) continue;
                            reqBundles.add("    " + r + " (visible through " + "osgi.wiring.bundle" + " from " + ShellUtil.getBundleName((Bundle)rcap.getWiring().getBundle()) + ")");
                        }
                    }
                    if (importedPackages.isEmpty() && reqBundles.isEmpty()) continue;
                    System.out.println("  Resources from bundle or wired bundles:");
                    for (String v : importedPackages) {
                        System.out.println(v);
                    }
                    for (String v : reqBundles) {
                        System.out.println(v);
                    }
                    continue;
                }
                System.out.println("Bundle " + bundle.getBundleId() + " is not resolved.");
            }
        }
    }
}

