/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configadmin.plugin.interpolation;

import java.io.File;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.felix.configadmin.plugin.interpolation.InterpolationConfigurationPlugin;

public class StandaloneInterpolator {
    final InterpolationConfigurationPlugin plugin;

    public StandaloneInterpolator(Map<String, String> frameworkProperties, File ... secretsLocations) {
        this(frameworkProperties, (String)null, secretsLocations);
    }

    public StandaloneInterpolator(Map<String, String> frameworkProperties, String encoding, File ... secretsLocations) {
        if (secretsLocations == null) {
            secretsLocations = new File[]{};
        }
        String locations = Arrays.asList(secretsLocations).stream().map(File::toString).collect(Collectors.joining(","));
        this.plugin = new InterpolationConfigurationPlugin(frameworkProperties::get, locations, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpolate(String pid, Dictionary<String, Object> dict) {
        boolean pidAdded = false;
        try {
            if (dict.get("service.pid") == null) {
                dict.put("service.pid", pid);
                pidAdded = true;
            }
            this.plugin.modifyConfiguration(null, dict);
        }
        finally {
            if (pidAdded) {
                dict.remove("service.pid");
            }
        }
    }
}

