/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish.pubcomp;

import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.publish.pubcomp.MqttPubComp;
import com.hivemq.client.internal.mqtt.message.publish.pubrel.MqttPubRel;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubcomp.Mqtt5PubCompBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubcomp.Mqtt5PubCompReasonCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttPubCompBuilder
implements Mqtt5PubCompBuilder {
    @NotNull
    private final MqttPubRel pubRel;
    @NotNull
    private Mqtt5PubCompReasonCode reasonCode = MqttPubComp.DEFAULT_REASON_CODE;
    @Nullable
    private MqttUtf8StringImpl reasonString;
    @NotNull
    private MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.NO_USER_PROPERTIES;

    public MqttPubCompBuilder(@NotNull MqttPubRel pubRel) {
        this.pubRel = pubRel;
    }

    @NotNull
    public MqttPubCompBuilder reasonCode(@NotNull Mqtt5PubCompReasonCode reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Override
    @NotNull
    public MqttPubCompBuilder reasonString(@Nullable String reasonString) {
        this.reasonString = MqttChecks.reasonString(reasonString);
        return this;
    }

    @Override
    @NotNull
    public MqttPubCompBuilder reasonString(@Nullable MqttUtf8String reasonString) {
        this.reasonString = MqttChecks.reasonString(reasonString);
        return this;
    }

    @Override
    @NotNull
    public MqttPubCompBuilder userProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = MqttChecks.userProperties(userProperties);
        return this;
    }

    public @NotNull MqttUserPropertiesImplBuilder.Nested<MqttPubCompBuilder> userProperties() {
        return new MqttUserPropertiesImplBuilder.Nested<MqttPubCompBuilder>(this.userProperties, this::userProperties);
    }

    @Override
    @NotNull
    public Mqtt5PubCompReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @NotNull
    public MqttPubRel getPubRel() {
        return this.pubRel;
    }

    @NotNull
    public MqttPubComp build() {
        return new MqttPubComp(this.pubRel.getPacketIdentifier(), this.reasonCode, this.reasonString, this.userProperties);
    }
}

