/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.FixedLengthAudioStream;

@NonNullByDefault
public class ByteArrayAudioStream
extends FixedLengthAudioStream {
    private final byte[] bytes;
    private final AudioFormat format;
    private final ByteArrayInputStream stream;

    public ByteArrayAudioStream(byte[] bytes, AudioFormat format) {
        this.bytes = bytes;
        this.format = format;
        this.stream = new ByteArrayInputStream(bytes);
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public long length() {
        return this.bytes.length;
    }

    @Override
    public InputStream getClonedStream() {
        return new ByteArrayAudioStream(this.bytes, this.format);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

