/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.manifest;

import java.util.ArrayList;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;

public final class Parser {
    private Parser() {
    }

    public static Clause[] parseHeader(String header) throws IllegalArgumentException {
        Clause[] clauses = null;
        if (header != null) {
            if (header.length() == 0) {
                throw new IllegalArgumentException("The header cannot be an empty string.");
            }
            String[] ss = Parser.parseDelimitedString(header, ",");
            clauses = Parser.parseClauses(ss);
        }
        return clauses == null ? new Clause[]{} : clauses;
    }

    public static Clause[] parseClauses(String[] ss) throws IllegalArgumentException {
        if (ss == null) {
            return null;
        }
        ArrayList<Clause> completeList = new ArrayList<Clause>();
        for (int ssIdx = 0; ssIdx < ss.length; ++ssIdx) {
            String[] pieces = Parser.parseDelimitedString(ss[ssIdx], ";");
            int pathCount = 0;
            for (int pieceIdx = 0; pieceIdx < pieces.length && pieces[pieceIdx].indexOf(61) < 0; ++pieceIdx) {
                ++pathCount;
            }
            if (pathCount == 0) {
                throw new IllegalArgumentException("No path specified on clause: " + ss[ssIdx]);
            }
            Directive[] dirs = new Directive[pieces.length - pathCount];
            Attribute[] attrs = new Attribute[pieces.length - pathCount];
            int dirCount = 0;
            int attrCount = 0;
            int idx = -1;
            String sep = null;
            for (int pieceIdx = pathCount; pieceIdx < pieces.length; ++pieceIdx) {
                idx = pieces[pieceIdx].indexOf("=");
                if (idx <= 0) {
                    throw new IllegalArgumentException("Not a directive/attribute: " + ss[ssIdx]);
                }
                if (pieces[pieceIdx].charAt(idx - 1) == ':') {
                    --idx;
                    sep = ":=";
                } else {
                    sep = "=";
                }
                String key = pieces[pieceIdx].substring(0, idx).trim();
                String value = pieces[pieceIdx].substring(idx + sep.length()).trim();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (sep.equals(":=")) {
                    dirs[dirCount++] = new Directive(key, value);
                    continue;
                }
                attrs[attrCount++] = new Attribute(key, value);
            }
            Directive[] dirsFinal = new Directive[dirCount];
            System.arraycopy(dirs, 0, dirsFinal, 0, dirCount);
            Attribute[] attrsFinal = new Attribute[attrCount];
            System.arraycopy(attrs, 0, attrsFinal, 0, attrCount);
            Clause[] pkgs = new Clause[pathCount];
            for (int pkgIdx = 0; pkgIdx < pathCount; ++pkgIdx) {
                pkgs[pkgIdx] = new Clause(pieces[pkgIdx], dirsFinal, attrsFinal);
                completeList.add(pkgs[pkgIdx]);
            }
        }
        Clause[] pkgs = completeList.toArray(new Clause[completeList.size()]);
        return pkgs;
    }

    public static String[] parseDelimitedString(String value, String delim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: " + value);
        }
        String s = sb.toString().trim();
        if (s.length() > 0) {
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }
}

