/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist.antlr;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.ide.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.xtext.ConditionEvaluator;
import org.eclipse.xtext.xtext.ParameterConfigHelper;

public class FollowElementCalculator
extends XtextSwitch<Boolean> {
    protected IFollowElementAcceptor acceptor;
    private List<AbstractElement> handledAlternatives;
    private UnorderedGroup group;
    private Collection<RuleCall> visitedRuleCalls = Sets.newHashSet();
    private int parameterConfig = 0;
    private Set<Parameter> currentConfig = null;

    public void setAcceptor(IFollowElementAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void setParameterConfig(int parameterConfig) {
        this.parameterConfig = parameterConfig;
    }

    public void doSwitch(UnorderedGroup group, List<AbstractElement> handledAlternatives) {
        this.group = group;
        this.handledAlternatives = handledAlternatives;
        try {
            this.doSwitch((EObject)group);
        }
        finally {
            this.handledAlternatives = null;
            this.group = null;
        }
    }

    public Boolean caseAlternatives(Alternatives object) {
        boolean more = false;
        for (AbstractElement element : object.getElements()) {
            boolean bl = more = (Boolean)this.doSwitch((EObject)element) != false || more;
        }
        if (!more && !this.isOptional((AbstractElement)object)) {
            return false;
        }
        return true;
    }

    public Boolean caseUnorderedGroup(UnorderedGroup object) {
        if (object == this.group) {
            boolean more = true;
            for (AbstractElement element : object.getElements()) {
                if (this.handledAlternatives != null && this.handledAlternatives.contains(element)) continue;
                this.group = null;
                more = (Boolean)this.doSwitch((EObject)element) != false && more;
                this.group = object;
            }
            if (more && GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                this.handledAlternatives = null;
                this.group = null;
                return this.caseUnorderedGroup(object);
            }
            if (!more && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }
        boolean more = true;
        for (AbstractElement element : object.getElements()) {
            boolean bl = more = (Boolean)this.doSwitch((EObject)element) != false && more;
        }
        if (!more && !this.isOptional((AbstractElement)object)) {
            return false;
        }
        return true;
    }

    public Boolean caseGroup(Group object) {
        boolean more = true;
        if (object.getGuardCondition() != null) {
            Set<Parameter> parameterValues = this.getParameterValues((AbstractElement)object);
            more = new ConditionEvaluator(parameterValues).evaluate(object.getGuardCondition());
        }
        if (more) {
            for (AbstractElement element : object.getElements()) {
                boolean bl = more = more && (Boolean)this.doSwitch((EObject)element) != false;
            }
        }
        if (!more && !this.isOptional((AbstractElement)object)) {
            return false;
        }
        return true;
    }

    private Set<Parameter> getParameterValues(AbstractElement object) {
        Set<Object> parameterValues = Collections.emptySet();
        parameterValues = this.currentConfig != null ? this.currentConfig : ParameterConfigHelper.getAssignedParameters((AbstractElement)object, (int)this.parameterConfig);
        return parameterValues;
    }

    public Boolean caseAction(Action object) {
        return true;
    }

    public Boolean caseAssignment(Assignment object) {
        this.acceptor.accept((AbstractElement)object);
        if (!((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue() && !this.isOptional((AbstractElement)object)) {
            return false;
        }
        return true;
    }

    public Boolean caseCrossReference(CrossReference object) {
        return Boolean.FALSE;
    }

    public Boolean caseParserRule(ParserRule object) {
        if (GrammarUtil.isDatatypeRule((ParserRule)object)) {
            return Boolean.FALSE;
        }
        return (Boolean)this.doSwitch((EObject)object.getAlternatives());
    }

    public Boolean caseEnumRule(EnumRule object) {
        return (Boolean)this.doSwitch((EObject)object.getAlternatives());
    }

    public Boolean caseEnumLiteralDeclaration(EnumLiteralDeclaration object) {
        return (Boolean)this.doSwitch((EObject)object.getLiteral());
    }

    public Boolean caseRuleCall(RuleCall object) {
        if (!this.visitedRuleCalls.add(object)) {
            return this.isOptional((AbstractElement)object);
        }
        this.acceptor.accept((AbstractElement)object);
        Set<Parameter> oldConfig = this.currentConfig;
        try {
            this.currentConfig = !object.getArguments().isEmpty() ? ParameterConfigHelper.getAssignedArguments((RuleCall)object, this.getParameterValues((AbstractElement)object)) : Collections.emptySet();
            Boolean result = (Boolean)this.doSwitch((EObject)object.getRule()) != false || this.isOptional((AbstractElement)object);
            this.visitedRuleCalls.remove(object);
            Boolean bl = result;
            return bl;
        }
        finally {
            this.currentConfig = oldConfig;
        }
    }

    public Boolean caseTerminalRule(TerminalRule object) {
        return Boolean.FALSE;
    }

    public Boolean caseKeyword(Keyword object) {
        this.acceptor.accept((AbstractElement)object);
        return this.isOptional((AbstractElement)object);
    }

    public boolean isOptional(AbstractElement element) {
        return GrammarUtil.isOptionalCardinality((AbstractElement)element);
    }
}

