/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.internal.resources.beans;

import java.lang.management.ManagementFactory;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;

@NonNullByDefault
public class SystemInfoBean {
    public final SystemInfo systemInfo;

    public SystemInfoBean(int startLevel) {
        this.systemInfo = new SystemInfo(startLevel);
    }

    public static class SystemInfo {
        public final String configFolder = OpenHAB.getConfigFolder();
        public final String userdataFolder = OpenHAB.getUserDataFolder();
        public final @Nullable String logFolder = System.getProperty("openhab.logdir");
        public final @Nullable String javaVersion = System.getProperty("java.version");
        public final @Nullable String javaVendor = System.getProperty("java.vendor");
        public final @Nullable String javaVendorVersion = System.getProperty("java.vendor.version");
        public final @Nullable String osName = System.getProperty("os.name");
        public final @Nullable String osVersion = System.getProperty("os.version");
        public final @Nullable String osArchitecture = System.getProperty("os.arch");
        public final int availableProcessors = Runtime.getRuntime().availableProcessors();
        public final long freeMemory = Runtime.getRuntime().freeMemory();
        public final long totalMemory = Runtime.getRuntime().totalMemory();
        public final long uptime = ManagementFactory.getRuntimeMXBean().getUptime() / 1000L;
        public final int startLevel;

        public SystemInfo(int startLevel) {
            this.startLevel = startLevel;
        }
    }
}

