/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.cmd;

import java.net.InetAddress;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.io.ModbusTCPTransaction;
import net.wimpi.modbus.msg.ReadInputDiscretesRequest;
import net.wimpi.modbus.msg.ReadInputDiscretesResponse;
import net.wimpi.modbus.msg.WriteCoilRequest;
import net.wimpi.modbus.net.TCPMasterConnection;

public class DIDOTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        InetAddress addr = null;
        TCPMasterConnection con = null;
        ReadInputDiscretesRequest di_req = null;
        WriteCoilRequest do_req = null;
        ModbusTCPTransaction di_trans = null;
        ModbusTCPTransaction do_trans = null;
        int di_ref = 0;
        int do_ref = 0;
        int port = 502;
        try {
            try {
                if (args.length < 3) {
                    DIDOTest.printUsage();
                    System.exit(1);
                } else {
                    try {
                        String astr = args[0];
                        int idx = astr.indexOf(58);
                        if (idx > 0) {
                            port = Integer.parseInt(astr.substring(idx + 1));
                            astr = astr.substring(0, idx);
                        }
                        addr = InetAddress.getByName(astr);
                        di_ref = Integer.parseInt(args[1]);
                        do_ref = Integer.parseInt(args[2]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        DIDOTest.printUsage();
                        System.exit(1);
                    }
                }
                con = new TCPMasterConnection(addr);
                con.setPort(port);
                con.connect();
                if (Modbus.debug) {
                    System.out.println("Connected to " + addr.toString() + ":" + con.getPort());
                }
                di_req = new ReadInputDiscretesRequest(di_ref, 1);
                do_req = new WriteCoilRequest();
                do_req.setReference(do_ref);
                di_req.setUnitID(0);
                do_req.setUnitID(0);
                di_trans = new ModbusTCPTransaction(con);
                di_trans.setRequest(di_req);
                di_trans.setReconnecting(false);
                do_trans = new ModbusTCPTransaction(con);
                do_trans.setRequest(do_req);
                do_trans.setReconnecting(false);
                boolean last_out = false;
                boolean new_in = false;
                while (true) {
                    di_trans.execute();
                    new_in = ((ReadInputDiscretesResponse)di_trans.getResponse()).getDiscreteStatus(0);
                    if (new_in == last_out) continue;
                    do_req.setCoil(new_in);
                    do_trans.execute();
                    last_out = new_in;
                    if (!Modbus.debug) continue;
                    System.out.println("Updated coil with state from DI.");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                con.close();
            }
        }
        catch (Throwable throwable) {
            con.close();
            throw throwable;
        }
    }

    private static void printUsage() {
        System.out.println("java net.wimpi.modbus.cmd.DIDOTest <address{:<port>} [String]> <register d_in [int16]> <register d_out [int16]>");
    }
}

