/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.util.ITypeReferenceVisitor;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.compiler.BrokenTypeRefDetector;
import org.eclipse.xtext.xbase.compiler.IElementIssueProvider;
import org.eclipse.xtext.xbase.compiler.LoopParams;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.compiler.output.ErrorTreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ErrorSafeExtensions {
    @Inject
    private TypeReferenceSerializer typeReferenceSerializer;
    @Inject
    private IElementIssueProvider.Factory issueProviderFactory;

    public Iterable<Issue> getErrors(EObject element) {
        IElementIssueProvider issueProvider = this.issueProviderFactory.get(element.eResource());
        return Iterables.filter(issueProvider.getIssues(element), it -> Severity.ERROR.equals((Object)it.getSeverity()));
    }

    public boolean hasErrors(EObject element) {
        return !IterableExtensions.isEmpty(this.getErrors(element));
    }

    public <T extends EObject> void forEachSafely(ITreeAppendable appendable, Iterable<T> elements, Procedures.Procedure1<? super LoopParams> loopInitializer, Procedures.Procedure2<? super T, ? super ITreeAppendable> body) {
        if (Iterables.isEmpty(elements)) {
            return;
        }
        LoopParams loopParams = (LoopParams)ObjectExtensions.operator_doubleArrow((Object)new LoopParams(), loopInitializer);
        boolean allElementsBroken = Iterables.size((Iterable)Iterables.filter(elements, it -> this.hasErrors((EObject)it))) == Iterables.size(elements);
        ITreeAppendable currentAppendable = null;
        currentAppendable = allElementsBroken ? this.openErrorAppendable(appendable, null) : appendable;
        loopParams.appendPrefix(currentAppendable);
        boolean isFirst = true;
        boolean isFirstBroken = true;
        for (EObject element : elements) {
            if (!this.hasErrors(element)) {
                currentAppendable = this.closeErrorAppendable(appendable, currentAppendable);
                if (!isFirst) {
                    loopParams.appendSeparator(appendable);
                }
                isFirst = false;
                body.apply((Object)element, (Object)appendable);
                continue;
            }
            if (!allElementsBroken) {
                currentAppendable = this.openErrorAppendable(appendable, currentAppendable);
            }
            if (!isFirst || !isFirstBroken) {
                loopParams.appendSeparator(currentAppendable);
            }
            isFirstBroken = false;
            try {
                body.apply((Object)element, (Object)currentAppendable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!allElementsBroken) {
            currentAppendable = this.closeErrorAppendable(appendable, currentAppendable);
        }
        loopParams.appendSuffix(currentAppendable);
        this.closeErrorAppendable(appendable, currentAppendable);
    }

    protected ITreeAppendable openErrorAppendable(ITreeAppendable parent, ITreeAppendable child) {
        if (child instanceof ErrorTreeAppendable) {
            return child;
        }
        return parent.errorChild().append("/* ");
    }

    protected ITreeAppendable closeErrorAppendable(ITreeAppendable parent, ITreeAppendable child) {
        if (child instanceof ErrorTreeAppendable && !Objects.equals(child, parent)) {
            child.append(" */");
        }
        return parent;
    }

    public void serializeSafely(JvmTypeReference typeRef, ITreeAppendable appendable) {
        this.serializeSafely(typeRef, null, appendable);
    }

    public void serializeSafely(JvmTypeReference typeRef, String surrogateType, ITreeAppendable appendable) {
        if (typeRef == null || typeRef.getType() == null) {
            if (typeRef instanceof JvmSpecializedTypeReference) {
                this.serializeSafely(((JvmSpecializedTypeReference)typeRef).getEquivalent(), surrogateType, appendable);
            } else if (typeRef instanceof JvmUnknownTypeReference) {
                appendable.append(((JvmUnknownTypeReference)typeRef).getQualifiedName());
            } else {
                appendable.append("Object");
                ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable);
                errorChild.append("type is 'null'");
                this.closeErrorAppendable(appendable, errorChild);
            }
        } else if (((Boolean)typeRef.accept((ITypeReferenceVisitor)new BrokenTypeRefDetector())).booleanValue()) {
            ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable);
            try {
                this.typeReferenceSerializer.serialize(typeRef, typeRef.eContainer(), errorChild);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.closeErrorAppendable(appendable, errorChild);
            if (surrogateType != null) {
                appendable.append(surrogateType);
            }
        } else {
            this.typeReferenceSerializer.serialize(typeRef, typeRef.eContainer(), appendable);
        }
    }

    public void serializeSafely(JvmAnnotationReference annotationRef, ITreeAppendable appendable, Procedures.Procedure1<? super ITreeAppendable> onSuccess) {
        if (annotationRef == null || annotationRef.getAnnotation() == null) {
            ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable);
            errorChild.append("annotation is 'null'");
            this.closeErrorAppendable(appendable, errorChild);
        } else if (annotationRef.getAnnotation().eIsProxy()) {
            ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable);
            appendable.append("@");
            appendable.append((JvmType)annotationRef.getAnnotation());
            this.closeErrorAppendable(appendable, errorChild);
        } else {
            appendable.append("@");
            appendable.append((JvmType)annotationRef.getAnnotation());
            onSuccess.apply((Object)appendable);
        }
    }
}

