/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongSMS {
    private static final Logger logger = LoggerFactory.getLogger(LongSMS.class);
    private static final int MAX_MESSAGE_SEGMENT_8BIT = 133;
    private static final byte UDHIE_IDENTIFIER_SAR = 8;
    private static final byte UDHIE_SAR_LENGTH = 4;
    private static int referenceNumber = 0;

    private LongSMS() {
        throw new InstantiationError("This class must not be instantiated");
    }

    private static synchronized int getReferenceNumber() {
        if (++referenceNumber >= 65536) {
            referenceNumber = 0;
        }
        return referenceNumber;
    }

    private static byte[] copyShort2Bytes(int integer) {
        byte[] bytes = new byte[]{(byte)(integer >> 8 & 0xFF), (byte)(integer & 0xFF)};
        return bytes;
    }

    public static byte[][] splitMessage8Bit(byte[] aMessage) {
        int segmentNum = aMessage.length / 133;
        int messageLength = aMessage.length;
        if (segmentNum > 255) {
            segmentNum = 255;
            messageLength = segmentNum * 133;
        }
        if (messageLength % 133 > 0) {
            ++segmentNum;
        }
        byte[][] segments = new byte[segmentNum][];
        byte[] referenceNumber = LongSMS.copyShort2Bytes(LongSMS.getReferenceNumber());
        for (int i = 0; i < segmentNum; ++i) {
            logger.debug("i = " + i);
            int lengthOfData = segmentNum - i == 1 ? messageLength - i * 133 : 133;
            logger.debug("Length of data = " + lengthOfData);
            segments[i] = new byte[7 + lengthOfData];
            logger.debug("segments[" + i + "].length = " + segments[i].length);
            segments[i][0] = 6;
            segments[i][1] = 8;
            segments[i][2] = 4;
            System.arraycopy(referenceNumber, 0, segments[i], 3, 2);
            segments[i][5] = (byte)segmentNum;
            segments[i][6] = (byte)(i + 1);
            System.arraycopy(aMessage, i * 133, segments[i], 7, lengthOfData);
        }
        return segments;
    }
}

