<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Paramètres du compte',
    'sidebar_personalization' => 'Personnalisation',
    'sidebar_settings_storage' => 'Espace de stockage',
    'sidebar_settings_export' => 'Exporter les données',
    'sidebar_settings_users' => 'Utilisateurs',
    'sidebar_settings_subscriptions' => 'Abonnement',
    'sidebar_settings_import' => 'Importation de données',
    'sidebar_settings_tags' => 'Gestion des étiquettes',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'Ressources DAV',
    'sidebar_settings_security' => 'Sécurité',
    'sidebar_settings_auditlogs' => 'Journal d’audit',

    'title_general' => 'Informations générales',
    'title_i18n' => 'Paramètres internationaux',
    'title_layout' => 'Disposition',

    'me_title' => 'Moi en tant que contact',
    'me_help' => 'Ceci est le contact qui <em>vous</em> représente sur Monica',
    'me_select' => 'Sélectionner un contact',
    'me_no_contact' => 'Aucun contact sélectionné.',
    'me_select_click' => 'Cliquer ici pour sélectionner un contact.',
    'me_remove_contact' => 'Supprimer l’association',
    'me_choose' => 'Choisissez votre contact',
    'me_choose_placeholder' => 'Choisissez votre contact',

    'export_title' => 'Exporter les données de votre compte',
    'export_be_patient' => 'Cliquez sur le bouton pour commencer l’export. Cela peut prendre plusieurs minutes pour préparer l’export – merci d’être patient et de ne pas spammer le bouton.',
    'export_title_sql' => 'Exporter en SQL',
    'export_sql_explanation' => 'L’exportation de vos données au format SQL vous permet de prendre vos données et de les importer dans votre propre instance Monica. Ceci n’est utile que si vous avez votre propre serveur.',
    'export_sql_cta' => 'Exporter en SQL',
    'export_sql_link_instructions' => 'Remarque : <a href=":url">lisez les instructions</a> pour en savoir plus sur l’importation de ce fichier dans votre instance.',
    'export_title_json' => 'Exporter en Json',
    'export_submitted' => 'Votre exportation a été envoyée, elle sera disponible dans quelques instants…',
    'export_json_explanation' => 'Exportation de vos données au format Json pour la sauvegarde.',
    'export_json_beta' => 'L’exportation en Json est en phase de test. Dites-nous ce que vous en pensez :',
    'export_json_cta' => 'Exporter en Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Date de création',
    'export_header_status' => 'Statut',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Dernières exportations',
    'export_empty_title' => 'Aucune exportation pour le moment',
    'export_type_json' => 'Export Json',
    'export_type_sql' => 'Export SQL',
    'export_status_todo' => 'Soumis',
    'export_status_doing' => 'En cours',
    'export_status_done' => 'Terminé',
    'export_status_failed' => 'Echoué',
    'export_not_done' => 'Téléchargement impossible, cet export n’est pas encore terminé.',

    'firstname' => 'Prénom',
    'lastname' => 'Nom de famille',
    'name_order' => 'Ordre des noms',
    'name_order_firstname_lastname' => '<Prénom> <Nom> – Jean Dupont',
    'name_order_lastname_firstname' => '<Nom> <Prénom> – Dupont Jean',
    'name_order_firstname_lastname_nickname' => '<Prénom> <Nom> (<Surnom>) – Jean Dupont (Jojo)',
    'name_order_firstname_nickname_lastname' => '<Prénom> (<Surnom>) <Nom> – Jean (Jojo) Dupont',
    'name_order_lastname_firstname_nickname' => '<Nom> <Prénom> (<Surnom>) – Dupont Jean (Jojo)',
    'name_order_lastname_nickname_firstname' => '<Nom> (<Surnom>) <Prénom> – Dupont (Jojo) Jean',
    'name_order_nickname_firstname_lastname' => '<Surnom> (<Prénom> <Nom>) – Jojo (Jean Dupont)',
    'name_order_nickname_lastname_firstname' => '<Surnom> (<Nom> <Prénom>) – Jojo (Dupont Jean)',
    'name_order_nickname' => '<Surnom> – Jojo',
    'currency' => 'Devise',
    'name' => 'Votre nom : :name',
    'email' => 'Adresse courriel',
    'email_placeholder' => 'Entrez l’adresse courriel',
    'email_help' => 'Cette adresse courriel est utilisée pour vous connecter à votre compte, et c\'est aussi l\'adresse à laquelle Monica enverra vos rappels.',
    'timezone' => 'Fuseau horaire',
    'temperature_scale' => 'Échelle de température',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Disposition',
    'layout_small' => 'Maximum de 1200 pixels de large',
    'layout_big' => 'Largeur maximale du navigateur',
    'save' => 'Mettre à jour',
    'delete_title' => 'Supprimer votre compte',
    'delete_desc' => 'Voulez-vous supprimer votre compte ? La suppression est permanente et toutes vos données seront définitivement supprimées. Si vous avez un abonnement, il sera immédiatement annulé.',
    'delete_other_desc' => 'Vos données dans la base de données principale seront supprimées immédiatement. Comme décrit dans notre politique de confidentialité, nous faisons des sauvegardes quotidiennes et sécurisées de la base de données. Ces sauvegardes sont conservées pendant 30 jours, puis elles sont complètement supprimées. Nous ne pouvons pas supprimer des données spécifiques des sauvegardes que nous effectuons auparavant. Toutes vos données seront complètement supprimées dans les 31 jours suivant la suppression de votre compte.',
    'reset_desc' => 'Souhaitez-vous remettre à zéro votre compte ? Ceci effacera tous les contacts ainsi que les données associées. Votre compte ne sera pas effacé.',
    'reset_title' => 'Remettre à zéro votre compte',
    'reset_cta' => 'Remettre à zéro',
    'reset_notice' => 'Êtes-vous sûr de vouloir réinitialiser votre compte ? Ceci est permanent et ne peut pas être annulé.',
    'reset_success' => 'Votre compte a été réinitialisé.',
    'delete_notice' => 'Êtes-vous sûr de vouloir supprimer votre compte ? Cette action est permanente et ne peut pas être annulée. Toutes vos données seront supprimées et ne seront pas récupérables.',
    'delete_cta' => 'Effacer le compte',
    'settings_success' => 'Préférences mises à jour',
    'locale' => 'Langue',
    'locale_help' => 'Voulez-vous aider à traduire Monica ou ajouter une nouvelle langue ? Veuillez suivre <a href=":url" target="_blank" lang="en">ce lien pour plus d’informations</a>.',
    'locale_ar' => 'Arabe',
    'locale_cs' => 'Tchèque',
    'locale_de' => 'Allemand',
    'locale_el' => 'Grec',
    'locale_en' => 'Anglais',
    'locale_en-GB' => 'Anglais (Royaume-Uni)',
    'locale_es' => 'Espagnol',
    'locale_fr' => 'Francais',
    'locale_he' => 'Hébreu',
    'locale_hr' => 'Croate',
    'locale_id' => 'Indonésien',
    'locale_it' => 'Italien',
    'locale_ja' => 'Japonais',
    'locale_nl' => 'Néerlandais',
    'locale_pt' => 'Portugais',
    'locale_pt-BR' => 'Portugais du Brésil',
    'locale_ru' => 'Russe',
    'locale_sv' => 'Suédois',
    'locale_vi' => 'Vietnamien',
    'locale_zh' => 'Chinois Simplifié',
    'locale_zh-TW' => 'Chinois Traditionnel',
    'locale_tr' => 'Turc',

    'security_title' => 'Sécurité',
    'security_help' => 'Changer les questions de sécurité pour votre compte.',
    'password_change' => 'Modifier votre mot de passe',
    'password_current' => 'Mot de passe actuel',
    'password_current_placeholder' => 'Entrez votre mot de passe actuel',
    'password_new1' => 'Nouveau mot de passe',
    'password_new1_placeholder' => 'Entrez votre nouveau mot de passe',
    'password_new2' => 'Confirmez votre nouveau mot de passe',
    'password_new2_placeholder' => 'Retapez votre nouveau mot de passe',
    'password_btn' => 'Changer votre mot de passe',
    '2fa_title' => 'Authentification à deux facteurs',
    '2fa_otp_title' => 'Application mobile d’authentification à deux facteurs',
    '2fa_enable_title' => 'Activer l’authentification à deux facteurs',
    '2fa_enable_description' => 'Activer l’authentification à deux facteurs pour renforcer la sécurité de votre compte.',
    '2fa_enable_otp' => 'Ouvrez votre application mobile pour l’authentification à deux facteurs et scannez le QR code suivant :',
    '2fa_enable_otp_help' => 'Si votre application mobile pour l’authentification à deux facteurs ne supporte pas les QR codes, entrez le code suivant :',
    '2fa_enable_otp_validate' => 'Merci de valider le nouvel appareil que vous venez de configurer :',
    '2fa_enable_success' => 'L’authentification à deux facteurs est active',
    '2fa_enable_error' => 'Erreur lors de l’activation de l’authentification à deux facteurs',
    '2fa_enable_error_already_set' => 'L’authentification à deux facteurs est déjà activé',
    '2fa_disable_title' => 'Désactiver l’authentification à deux facteurs',
    '2fa_disable_description' => 'Désactiver l’authentification à deux facteurs pour votre compte. Attention, votre compte ne sera plus sécurisé !',
    '2fa_disable_success' => 'L’authentification à deux facteurs a été désactivée',
    '2fa_disable_error' => 'Erreur lors de la désactivation de l’authentification à deux facteurs',

    'webauthn_title' => 'Clé de sécurité — Protocole WebAuthn',
    'webauthn_enable_description' => 'Ajouter une nouvelle clé de sécurité',
    'webauthn_key_name_help' => 'Donnez un nom à votre clé.',
    'webauthn_key_name' => 'Nom de la clé :',
    'webauthn_success' => 'Votre clé est détectée et validée.',
    'webauthn_last_use' => 'Dernière utilisation : {timestamp}',
    'webauthn_delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer cette clé ?',
    'webauthn_delete_success' => 'Clé supprimée',
    'webauthn_insertKey' => 'Insérer votre clé de sécurité.',
    'webauthn_buttonAdvise' => 'Si votre clé de sécurité dispose d’un bouton, appuyez dessus.',
    'webauthn_noButtonAdvise' => 'Si ce n’est pas le cas, enlevez-la et insérez là à nouveau.',
    'webauthn_not_supported' => 'Votre navigateur ne supporte pas encore WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn ne supporte que les connexions sécurisées. Veuillez charger cette page en https.',
    'webauthn_error_already_used' => 'Cette clé est déjà enregistrée. Il n’est pas nécessaire de l’enregistrer à nouveau.',
    'webauthn_error_not_allowed' => 'L’opération a expiré ou n’a pas été autorisée.',

    'recovery_title' => 'Codes de récupération',
    'recovery_show' => 'Obtenez des codes de récupération',
    'recovery_copy_help' => 'Copier les codes dans votre presse-papiers',
    'recovery_help_intro' => 'Voici vos codes de récupération :',
    'recovery_help_information' => 'Vous pouvez utiliser chaque code de récupération une fois.',
    'recovery_clipboard' => 'Codes copiés dans le presse-papiers.',
    'recovery_generate' => 'Générer de nouveaux codes …',
    'recovery_generate_help' => 'Générez de nouveaux codes invalidera les codes générés précédemment.',
    'recovery_already_used_help' => 'Ce code a déjà été utilisé.',

    'users_list_title' => 'Utilisateurs avec accès à votre compte',
    'users_list_add_user' => 'Inviter un nouvel utilisateur',
    'users_list_you' => 'C’est vous',
    'users_list_invitations_title' => 'Invitations en attente',
    'users_list_invitations_explanation' => 'Voici les personnes que vous avez invité à rejoindre Monica comme collaborateurs.',
    'users_list_invitations_invited_by' => 'invité par :name',
    'users_list_invitations_sent_date' => 'envoyé le :date',
    'users_blank_title' => 'Vous êtes la seule personne qui a accès à ce compte.',
    'users_blank_add_title' => 'Souhaitez-vous inviter quelqu’un d’autre ?',
    'users_blank_description' => 'Cette personne aura le même accès que vous et sera en mesure d’ajouter, modifier ou supprimer les informations de contact.',
    'users_blank_cta' => 'Inviter quelqu’un',
    'users_add_title' => 'Invitez un nouvel utilisateur à votre compte par courriel',
    'users_add_description' => 'Cette personne aura le même accès que vous, et pourra également inviter ou supprimer d’autres utilisateurs, vous compris. Assurez-vous de faire confiance à cette personne avant de lui donner ces accès.',
    'users_add_email_field' => 'Entrez le courriel de la personne que vous souhaitez inviter',
    'users_add_confirmation' => 'Je confirme que je veux inviter cet utilisateur dans mon compte. Je comprends que cette personne aura accès à toutes mes données et verra exactement ce que je vois.',
    'users_add_cta' => 'Inviter l’utilisateur par courriel',
    'users_accept_title' => 'Accepter l’invitation et créer un nouveau compte',
    'users_error_please_confirm' => 'Merci de confirmer que vous souhaitez bien inviter cette personne avant d’envoyer l’invitation',
    'users_error_email_already_taken' => 'Cette adresse courriel est déjà prise. Veuillez en choisir une autre',
    'users_error_already_invited' => 'Vous avez déjà invité cet utilisateur. Veuillez choisir une autre adresse courriel.',
    'users_error_email_not_similar' => 'Ce n’est pas le courriel de la personne qui vous a invité.',
    'users_invitation_deleted_confirmation_message' => 'L’invitation a été supprimée avec succès',
    'users_invitations_delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer de cette invitation ?',
    'users_list_delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer cet utilisateur de votre compte ?',
    'users_invitation_need_subscription' => 'L’ajout d’utilisateurs nécessite un abonnement.',

    'subscriptions_account_current_plan' => 'Votre offre actuelle',
    'subscriptions_account_current_legacy' => 'Plan actuel, plus sélectionnable :',
    'subscriptions_account_current_paid_plan' => 'Vous êtes sur l’offre :name. Merci beaucoup pour votre inscription.',

    'subscriptions_account_next_billing_title' => 'Prochaine facturation',
    'subscriptions_account_next_billing' => 'Votre abonnement va être renouvelé automatiquement le <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'Nous vous facturerons <strong>:price</strong> pour un <strong>mois</strong> de plus.',
    'subscriptions_account_bill_annual' => 'Nous vous facturerons <strong>:price</strong> pour une <strong>année</strong> de plus.',
    'subscriptions_account_change' => 'Changer d’offre',

    'subscriptions_account_cancel_title' => 'Annuler votre abonnement',
    'subscriptions_account_cancel_action' => 'Annuler votre abonnement',
    'subscriptions_account_cancel' => 'Vous pouvez annuler votre abonnement à tout moment.',
    'subscriptions_account_free_plan' => 'Vous êtes sur l’offre gratuite.',
    'subscriptions_account_free_plan_upgrade' => 'Vous pouvez mettre à niveau votre compte en passant à l’offre :name, qui coûte :price $ par mois. En voici les avantages :',
    'subscriptions_account_free_plan_benefits_users' => 'Nombre illimité d’utilisateurs',
    'subscriptions_account_free_plan_benefits_reminders' => 'Rappels par courriel',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Import de vos contacts au format vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Supporter le projet sur le long terme, afin de pouvoir vous proposer plus de fonctionnalités.',
    'subscriptions_account_upgrade' => 'Mettre à jour votre compte',
    'subscriptions_account_upgrade_title' => 'Mettez à niveau Monica aujourd’hui et ayez des relations encore plus significatives.',
    'subscriptions_account_upgrade_choice' => 'Choisissez une offre ci-dessous et rejoignez plus de :customers personnes qui ont mis à niveau leur Monica.',
    'subscriptions_account_update_title' => 'Modifier l’abonnement à Monica',
    'subscriptions_account_update_description' => 'Vous pouvez modifier la fréquence de votre abonnement ici.',
    'subscriptions_account_update_information' => 'Vous serez facturé immédiatement pour le nouveau montant. Votre abonnement sera prolongé jusqu\'à la nouvelle période, selon votre choix.',
    'subscriptions_account_invoices' => 'Factures',
    'subscriptions_account_invoices_download' => 'Télécharger',
    'subscriptions_account_invoices_subscription' => 'Abonnement du :startDate au :endDate',
    'subscriptions_account_payment' => 'Quelle option de paiement vous convient le mieux ?',
    'subscriptions_account_confirm_payment' => 'Votre paiement est actuellement incomplet, merci de <a href=":url">confirmer votre paiement</a>.',
    'subscriptions_downgrade_title' => 'Passez votre compte sur l’offre gratuite',
    'subscriptions_downgrade_limitations' => 'L’offre gratuite a des limitations. Afin de pouvoir passer à cette offre, vous devez passer les points suivants :',
    'subscriptions_downgrade_rule_users' => 'Vous devez avoir un seul utilisateur dans votre compte',
    'subscriptions_downgrade_rule_users_constraint' => 'Vous avez actuellement <a href=":url">:count utilisateur</a> dans votre compte.|Vous avez actuellement <a href=":url">:count utilisateurs</a> dans votre compte.',
    'subscriptions_downgrade_rule_invitations' => 'Vous ne devez pas avoir d’invitation en attente',
    'subscriptions_downgrade_rule_invitations_constraint' => 'Vous avez actuellement <a href=":url">1 invitiation</a> en attente.|Vous avez actuellement <a href=":url">:count invitations</a> en attente.',
    'subscriptions_downgrade_rule_contacts' => 'Vous ne devez pas avoir plus de :number contacts actifs',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Vous avez actuellement <a href=":url">:count contact</a>.|Vous avez actuellement <a href=":url">:count contacts</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'Nous pouvons également <a href=":url">archiver tous vos contacts pour vous</a> – cela effacerait cette règle et vous laisserait passer le processus de rétrogradation de votre compte.',
    'subscriptions_downgrade_cta' => 'Passer au plan inférieur',
    'subscriptions_downgrade_success' => 'Vous êtes de retour sur l’offre gratuite !',
    'subscriptions_downgrade_thanks' => 'Merci beaucoup d’avoir essayé l’offre payante. Nous continuons à apporter de nouvelles fonctionnalités sur Monica tout le temps – vous pouvez donc revenir à l’occasion pour voir si vous pourriez à nouveau être intéressé·e pour prendre un abonnement.',
    'subscriptions_back' => 'Retourner aux paramètres',
    'subscriptions_upgrade_title' => 'Passer au plan supérieur',
    'subscriptions_upgrade_choose' => 'Vous avez choisi l’offre :plan.',
    'subscriptions_upgrade_infos' => 'Nous ne pourrions être plus heureux. Entrez vos informations de paiement ci-dessous.',
    'subscriptions_upgrade_name' => 'Nom sur la carte',
    'subscriptions_upgrade_zip' => 'Code postal',
    'subscriptions_upgrade_credit' => 'Carte de crédit ou de débit',
    'subscriptions_upgrade_submit' => 'Payer {amount}',
    'subscriptions_upgrade_charge' => 'Nous débiterons votre carte de :price maintenant. Le prochain paiement aura lieu le :date. Si jamais vous changez d’avis, vous pourrez annuler à tout moment, sans poser de questions.',
    'subscriptions_upgrade_charge_handled' => 'Le paiement est géré par <a href=":url">Stripe</a>. Aucune information bancaire n’arrive sur notre serveur.',
    'subscriptions_upgrade_success' => 'Merci ! Vous êtes maintenant inscrit.',
    'subscriptions_upgrade_thanks' => 'Bienvenue dans la communauté de personnes qui essaient de rendre le monde un peu meilleur.',

    'subscriptions_payment_confirm_title' => 'Confirmez votre paiement de :amount',
    'subscriptions_payment_confirm_information' => 'Une confirmation supplémentaire est nécessaire pour traiter votre paiement. Veuillez confirmer votre paiement en remplissant vos informations de paiement ci-dessous.',
    'subscriptions_payment_succeeded_title' => 'Paiement validé',
    'subscriptions_payment_succeeded' => 'Ce paiement a déjà été confirmé avec succès.',
    'subscriptions_payment_cancelled_title' => 'Paiement annulé',
    'subscriptions_payment_cancelled' => 'Ce paiement a été annulé.',
    'subscriptions_payment_error_name' => 'Veuillez fournir votre nom.',
    'subscriptions_payment_success' => 'Votre paiement a été effectué.',

    'subscriptions_pdf_title' => 'Votre abonnement :name mensuel',
    'subscriptions_plan_frequency_year' => ':amount / an',
    'subscriptions_plan_frequency_month' => ':amount / mois',
    'subscriptions_plan_choose' => 'Choisir cette offre',
    'subscriptions_plan_year_title' => 'Payer annuellement',
    'subscriptions_plan_year_bonus' => 'Tranquillité d’esprit pendant toute une année',
    'subscriptions_plan_month_title' => 'Payer tous les mois',
    'subscriptions_plan_month_bonus' => 'Annuler à tout moment',
    'subscriptions_plan_include1' => 'Inclus avec votre mise à niveau :',
    'subscriptions_plan_include2' => 'Nombre illimité de contacts • Nombre illimité d’utilisateurs • Rappels par courriel • Importer des vCard • Personnalisation de la vue d’un contact',
    'subscriptions_plan_include3' => '100% des bénéfices vont à l’élaboration de ce beau projet open source.',
    'subscriptions_help_title' => 'Détails supplémentaires, qui peuvent attiser votre curiosité',
    'subscriptions_help_opensource_title' => 'Qu’est-ce qu’un projet open source ?',
    'subscriptions_help_opensource_desc' => 'Monica est un projet open source. Il est le fruit du travail d’une communauté de bénévoles qui veulent juste créer un outil pour le bien de tous. Être un projet open source signifie que le code est disponible pour tous sur GitHub, et que tout le monde peut l’inspecter, le modifier et l’améliorer. Tout l’argent que nous récoltons sert uniquement à créer des fonctionnalités, payer de nouveaux serveurs puissants, et autres coûts. Merci pour votre aide. Nous ne pourrions rien faire sans vous.',
    'subscriptions_help_limits_title' => 'Y a-t-il une limite au nombre de contacts que nous pouvons avoir sur l’offre gratuite ?',
    'subscriptions_help_limits_plan' => 'Oui. L’offre gratuite vous permet de gérer :number contacts.',
    'subscriptions_help_discounts_title' => 'Avez-vous des réductions pour les organismes sans but lucratif et les organismes d’éducation ?',
    'subscriptions_help_discounts_desc' => 'En effet ! Monica est gratuit pour les étudiants, les organismes sans but lucratif et les organismes de bienfaisance. Il suffit de contacter le <a href=":support">support</a> avec un justificatif de votre statut et nous allons appliquer ce statut spécial dans votre compte.',
    'subscriptions_help_change_title' => 'Que se passe-t-il si je change d’avis ?',
    'subscriptions_help_change_desc' => 'Vous pouvez annuler à tout moment, sans question, et par vous-même – aucun support requis. Toutefois, vous ne serez pas remboursé pour la période en cours.',

    'stripe_error_card' => 'Votre carte est refusée. Le message de refus est : :message',
    'stripe_error_api_connection' => 'Problèmes de communication avec Stripe. Veuillez réessayer plus tard.',
    'stripe_error_rate_limit' => 'Trop de requêtes avec Stripe actuellement. Veuillez réessayer plus tard.',
    'stripe_error_invalid_request' => 'Paramètres invalides. Réessayez plus tard.',
    'stripe_error_authentication' => 'Mauvaise authentification avec Stripe',

    'import_title' => 'Importer les contacts dans votre compte',
    'import_cta' => 'Importer des contacts',
    'import_stat' => 'Vous avez importé :number fichiers jusqu’à présent.',
    'import_result_stat' => ':count contact vCard envoyé (:total_imported importé, :total_skipped ignoré)|:count contacts vCard envoyés (:total_imported importés, :total_skipped ignorés)',
    'import_view_report' => 'Voir le rapport',
    'import_in_progress' => 'L’import est en cours. Veuillez recharger la page dans quelques minutes.',
    'import_upload_title' => 'Importer vos contacts depuis un fichier vCard',
    'import_upload_rules_desc' => 'Nous avons toutefois quelques règles :',
    'import_upload_rule_format' => 'Nous supportons les formats <code>.vcard</code> et <code>.vcf</code>.',
    'import_upload_rule_vcard' => 'Nous supportons le format vCard 3.0, qui est le format par défaut de l’application macOS Contacts.app et Google Contacts.',
    'import_upload_rule_instructions' => 'Instructions d’export pour <a href=":url1" target="_blank" rel="noopener noreferrer">macOS Contacts.app</a> et <a href=":url2" target="_blank" rel="noopener noreferrer">Google Contacts</a>.',
    'import_upload_rule_multiple' => 'Si vos contacts ont plusieurs adresses courriels ou numéros de téléphone, seule la première entrée sera sauvegardée.',
    'import_upload_rule_limit' => 'Les fichiers sont limités à 10 Mo.',
    'import_upload_rule_time' => 'Cela peut prendre une minute pour importer les contacts et les traiter. Merci de votre patience.',
    'import_upload_rule_cant_revert' => 'Veuillez vous assurer que les données sont fiables avant d’importer, car l’import ne peut être annulé.',
    'import_upload_form_file' => 'Votre fichier <code>.vcf</code> ou <code>.vCard</code> :',
    'import_upload_behaviour' => 'Comportement pour l’importation :',
    'import_upload_behaviour_add' => 'Ajouter les nouveaux contacts et passer les contacts existants',
    'import_upload_behaviour_replace' => 'Remplacer les contacts existants',
    'import_upload_behaviour_help' => 'Remplacer les contacts mettra à jour toutes les données trouvées dans la vCard, mais gardera les autre valeurs existantes du contact.',
    'import_report_title' => 'Rapport d’import',
    'import_report_date' => 'Date de l’import',
    'import_report_type' => 'Type d’import',
    'import_report_number_contacts' => 'Nombre de contacts dans le fichier',
    'import_report_number_contacts_imported' => 'Nombre de contacts importés',
    'import_report_number_contacts_skipped' => 'Nombre de contacts ignorés',
    'import_report_status_imported' => 'Importés',
    'import_report_status_skipped' => 'Ignorés',
    'import_vcard_parse_error' => 'Erreur lors de l’analyse de l’entrée vCard',
    'import_vcard_contact_exist' => 'Le contact existe déjà',
    'import_vcard_contact_no_firstname' => 'Pas de prénom (obligatoire)',
    'import_vcard_file_not_found' => 'Fichier non trouvé',
    'import_vcard_unknown_entry' => 'Nom de contact inconnu',
    'import_vcard_file_no_entries' => 'Le fichier ne contient pas de donnée',
    'import_blank_title' => 'Vous n’avez encore importé aucun contact.',
    'import_blank_question' => 'Souhaitez-vous importer vos contacts maintenant ?',
    'import_blank_description' => 'Nous pouvons importer les fichiers vCard que vous avez dans votre Google Contacts ou votre gestionnaire de contacts.',
    'import_blank_cta' => 'Importer une vCard',
    'import_need_subscription' => 'L’importation de données nécessite une souscription.',

    'tags_list_title' => 'Étiquettes',
    'tags_list_description' => 'Vous pouvez organiser vos contact avec des étiquettes. Les étiquettes sont comme des dossiers, mais vous pouvez avoir autant d’étiquettes que vous le souhaitez par contact.',
    'tags_list_contact_number' => ':count contact|:count contacts',
    'tags_list_delete_success' => 'L’étiquette a été supprimée avec succès',
    'tags_list_edit_success' => 'The tag has been successfully updated',
    'tags_list_delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer cette étiquette ? Aucun contact ne sera supprimé, seulement l’étiquette.',
    'tags_blank_title' => 'Les étiquettes sont une excellente manière de catégoriser vos contacts.',
    'tags_blank_description' => 'Les étiquettent fonctionnent comme des dossiers, mais vous pouvez ajouter plus d\'une étiquette à un contact. Allez à un contact et taguez un ami, juste en dessous du nom. Une fois qu\'un contact est étiqueté, revenez ici pour gérer toutes les étiquettes de votre compte.',

    'api_title' => 'Accès avec l’API',
    'api_description' => 'L’API peut être utilisée pour manipuler les données de Monica depuis une application externe, comme une application mobile par exemple.',
    'api_help' => 'Pour utiliser l’API, un jeton est obligatoire. Vous pouvez soit créer un jeton d’accès personnel (authentification Bearer), soit autoriser un client OAuth à le créer pour vous. Voir la <a href=":url">documentation de l’API</a>.',
    'api_endpoint' => 'Le point de terminaison de l’API pour cette instance Monica est :',

    'api_personal_access_tokens' => 'Jeton d’accès personnel',
    'api_pao_description' => 'Faites attention à ne fournir ce jeton qu’à des personnes de confiance – elles pourront accéder à toutes vos données.',
    'api_token_title' => 'Jetons d’accès personnels',
    'api_token_create_new' => 'Créer un nouveau jeton',
    'api_token_not_created' => 'Vous n’avez pas encore créé de jeton d’accès personnel.',
    'api_token_name' => 'Nom du jeton',
    'api_token_expire' => 'Expire le {date}',
    'api_token_delete' => 'Supprimer',
    'api_token_create' => 'Créer un jeton',
    'api_token_scopes' => 'Périmètres',
    'api_token_help' => 'Voici votre nouveau jeton d’accès personnel. Ceci est la seule fois où vous pourrez le voir, ne le perdez pas ! Vous pouvez dès à présent utiliser ce jeton pour lancer des requêtes avec l’API.',

    'api_oauth_clients' => 'Vos clients OAuth',
    'api_oauth_clients_desc' => 'Cette section vous permet d’enregistrer votre propre client OAuth.',
    'api_oauth_clients_desc2' => 'Utilisez cet identifiant de client pour demander un nouveau jeton et convertir les codes d’autorisation pour accéder aux jetons. Voir <a href="{url}">la documentation de Laravel Passport</a> pour plus d’informations.',
    'api_oauth_title' => 'Clients OAuth',
    'api_oauth_create_new' => 'Créer de nouveaux clients',
    'api_oauth_edit' => 'Modifier le client',
    'api_oauth_not_created' => 'Vous n’avez pas encore créé de client OAuth.',
    'api_oauth_clientid' => 'Identifiant du client',
    'api_oauth_name' => 'Nom',
    'api_oauth_name_help' => 'Quelque chose que vos utilisateurs reconnaîtront et inspirera la confiance.',
    'api_oauth_secret' => 'Secret',
    'api_oauth_create' => 'Créer un client',
    'api_oauth_redirecturl' => 'URL de redirection',
    'api_oauth_redirecturl_help' => 'URL de rappel d’autorisation de votre application.',

    'api_authorized_clients' => 'Liste de clients autorisés',
    'api_authorized_clients_desc' => 'Cette section liste tous les clients que vous avez autorisé à accéder aux données de votre demande. Vous pouvez révoquer cette autorisation à tout moment.',
    'api_authorized_clients_title' => 'Applications autorisées',
    'api_authorized_clients_none' => 'Il n’y a pas encore de client autorisé.',
    'api_authorized_clients_name' => 'Nom',
    'api_authorized_clients_scopes' => 'Périmètres',

    'personalization_tab_title' => 'Personnalisez votre compte',

    'personalization_title' => 'Ici vous pouvez configurer les différents paramètres de votre compte. Ces fonctionnalités sont pour les « utilisateurs avancés » qui veulent un contrôle maximal sur Monica.',
    'personalization_contact_field_type_title' => 'Types de champs de contact',
    'personalization_contact_field_type_add' => 'Ajouter un nouveau type de champ',
    'personalization_contact_field_type_description' => 'Vous pouvez configurer les différents type de champs de contact que vous pouvez associer à tous vos contacts. Par exemple si un nouveau réseau social apparaît, vous pourrez ajouter un nouveau type de communication pour vos contacts ici.',
    'personalization_contact_field_type_table_name' => 'Nom',
    'personalization_contact_field_type_table_protocol' => 'Protocole',
    'personalization_contact_field_type_table_actions' => 'Actions',
    'personalization_contact_field_type_modal_title' => 'Ajouter un nouveau type de champ',
    'personalization_contact_field_type_modal_edit_title' => 'Editer un type de champ existant',
    'personalization_contact_field_type_modal_delete_title' => 'Supprimer un type de champ existant',
    'personalization_contact_field_type_modal_delete_description' => 'Êtes-vous sûr de vouloir supprimer ce type de champ de contact ? Supprimer ce type de contact effacera TOUTES les données avec ce type de champ pour tous vos contacts.',
    'personalization_contact_field_type_modal_name' => 'Nom',
    'personalization_contact_field_type_modal_protocol' => 'Protocole (optionnel)',
    'personalization_contact_field_type_modal_protocol_help' => 'Chaque nouveau type de champ de contact peut être cliquable. Si un protocole est défini, nous l’utiliserons pour lancer l’action indiquée par le navigateur.',
    'personalization_contact_field_type_modal_icon' => 'Icone (optionnel)',
    'personalization_contact_field_type_modal_icon_help' => 'Vous pouvez associer un icône pour ce champ. Vous devez utiliser une référence vers une icône FontAwesome.',
    'personalization_contact_field_type_delete_success' => 'Le type de champ de contact a été supprimé avec succès.',
    'personalization_contact_field_type_add_success' => 'Le type de champ de contact a été ajouté avec succès.',
    'personalization_contact_field_type_edit_success' => 'Le type de champ de contact a été mis à jour avec succès.',

    'personalization_genders_title' => 'Types de genre',
    'personalization_genders_add' => 'Ajouter un nouveau type de genre',
    'personalization_genders_desc' => 'Vous pouvez définir autant de genres dont vous avez besoin. Il vous faut avoir au moins un type de genre dans votre compte.',
    'personalization_genders_modal_add' => 'Ajouter un nouveau type de genre',
    'personalization_genders_modal_edit' => 'Mettre à jour le type de genre',
    'personalization_genders_modal_name' => 'Nom',
    'personalization_genders_modal_name_help' => 'Nom utilisé pour afficher le genre sur la page d’un contact.',
    'personalization_genders_modal_sex' => 'Sexe',
    'personalization_genders_modal_sex_help' => 'Utilisé pour définir les relations, et pendant le processus d’importation/exportation VCard.',
    'personalization_genders_modal_default' => 'Sélectionnez le genre par défaut pour un nouveau contact',
    'personalization_genders_modal_delete' => 'Supprimer le type de genre',
    'personalization_genders_modal_delete_desc' => 'Voulez-vous vraiment supprimer le genre « {name} » ?',
    'personalization_genders_modal_delete_question' => 'Vous avez actuellement {count} contact utilisant ce genre. Si vous supprimez ce genre, quel genre ce contact devrait avoir ?|Vous avez actuellement {count} contacts utilisant ce genre. Si vous supprimez ce genre, quel genre ces contacts devraient avoir ?',
    'personalization_genders_modal_delete_question_default' => 'Ce genre est celui par défaut. Si vous le supprimez, quel sera le prochain genre par défaut ?',
    'personalization_genders_modal_error' => 'Merci de choisir un genre depuis cette liste.',
    'personalization_genders_list_contact_number' => '{count} contact|{count} contacts',
    'personalization_genders_table_name' => 'Nom',
    'personalization_genders_table_sex' => 'Sexe',
    'personalization_genders_table_default' => 'Défaut',
    'personalization_genders_default' => 'Genre par défaut',
    'personalization_genders_make_default' => 'Modifier le genre par défaut',
    'personalization_genders_select_default' => 'Choisir le genre par défaut',
    'personalization_genders_m' => 'Masculin',
    'personalization_genders_f' => 'Féminin',
    'personalization_genders_o' => 'Autre',
    'personalization_genders_u' => 'Inconnu',
    'personalization_genders_n' => 'Aucun ou non applicable',

    'personalization_reminder_rule_save' => 'Les modifications ont été enregistrées',
    'personalization_reminder_rule_title' => 'Règles de rappel',
    'personalization_reminder_rule_line' => '{count} jour avant|{count} jours avant',
    'personalization_reminder_rule_desc' => 'Pour chaque rappel que vous mettez en place, Monica peut envoyer un courriel plusieurs jours avant que l’évènement se passe. Vous pouvez ajuster ces préférences de notifications ici. Ces notifications ne s’appliquent qu’aux rappels mensuels et annuels.',

    'personalization_module_save' => 'Les modifications ont été enregistrées',
    'personalization_module_title' => 'Fonctionnalités',
    'personalization_module_desc' => 'Vous n’avez peut-être pas besoin de toutes ces fonctionnalités. Ci-dessous vous pouvez activer ou désactiver des fonctionnalités spécifiques qui sont utilisées sur la vue d’un contact. Ces modifications s’appliqueront à tous vos contacts. Désactiver une fonctionnalité ne supprime aucune donnée, cela masque juste la fonctionnalité.',

    'personalisation_paid_upgrade' => 'Il s’agit d’une fonctionnalité premium qui nécessite un abonnement payant pour être activée. Mettez à niveau votre compte en visitant <a href=":url">Paramètres > Abonnement</a>.',
    'personalisation_paid_upgrade_vue' => 'Il s’agit d’une fonctionnalité premium qui nécessite un abonnement payant pour être activée. Mettez à niveau votre compte en visitant <a href="{url}">Paramètres > Abonnement</a>.',

    'reminder_time_to_send' => 'Heure du jour à laquelle les rappels doivent être envoyés',
    'reminder_time_to_send_help' => 'Votre prochain rappel sera envoyé le <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Catégories de types d’activité',
    'personalization_activity_type_category_add' => 'Ajouter une nouvelle catégorie de type d’activité',
    'personalization_activity_type_category_table_name' => 'Nom',
    'personalization_activity_type_category_description' => 'Une activité avec l’un de vos contacts peut avoir un type et un type de catégorie. Votre compte est configuré par défaut avec un ensemble de types de catégories prédéfinies, mais vous pouvez les personnaliser ici.',
    'personalization_activity_type_category_table_actions' => 'Actions',
    'personalization_activity_type_category_modal_add' => 'Ajouter une nouvelle catégorie de type d’activité',
    'personalization_activity_type_category_modal_edit' => 'Modifier une catégorie de type d’activité',
    'personalization_activity_type_category_modal_question' => 'Comment nommer cette nouvelle catégorie ?',
    'personalization_activity_type_add_button' => 'Ajouter un nouveau type d’activité',
    'personalization_activity_type_modal_add' => 'Ajouter un nouveau type d’activité',
    'personalization_activity_type_modal_question' => 'Comment nommer ce nouveau type d’activité ?',
    'personalization_activity_type_modal_edit' => 'Modifier un type d’activité',
    'personalization_activity_type_category_modal_delete' => 'Supprimer une catégorie de type d’activité',
    'personalization_activity_type_category_modal_delete_desc' => 'Êtes-vous sûr de vouloir supprimer cette catégorie ? La suppression entraînera la suppression de tous les types d’activités associées. Les activités qui appartiennent à cette catégorie ne seront pas affectées par cette suppression.',
    'personalization_activity_type_modal_delete' => 'Supprimer un type d’activité',
    'personalization_activity_type_modal_delete_desc' => 'Êtes-vous sûr de vouloir supprimer ce type d’activité ? Les activités qui appartiennent à cette catégorie ne seront pas affectées par cette suppression.',
    'personalization_activity_type_modal_delete_error' => 'Impossible de trouver ce type d’activité.',
    'personalization_activity_type_category_modal_delete_error' => 'Impossible de trouver cette catégorie de type d’activité.',

    'personalization_life_event_category_title' => 'Catégories d’évènements marquants',
    'personalization_live_event_category_table_name' => 'Nom',
    'personalization_life_event_category_description' => 'Un évènement marquant peut avoir un type et une catégorie. Votre compte est fourni par défaut avec un ensemble de catégories et types prédéfinis, mais vous pouvez personnaliser les types d’évènements marquants ici.',
    'personalization_live_event_category_table_actions' => 'Actions',
    'personalization_life_event_type_add_button' => 'Ajouter un nouveau type d’évènement',
    'personalization_life_event_type_modal_add' => 'Ajouter un nouveau type d’évènement',
    'personalization_life_event_type_modal_question' => 'Comment nommer ce nouveau type d’évènement ?',
    'personalization_life_event_type_modal_edit' => 'Éditer un type d’évènement',
    'personalization_life_event_type_modal_delete' => 'Supprimer un type d’évènement',
    'personalization_life_event_type_modal_delete_desc' => 'Êtes-vous sûr de vouloir supprimer ce type d’événement ? Les évènements qui appartiennent à ce type seront supprimés en effectuant cette action.',
    'personalization_life_event_type_modal_delete_error' => 'Impossible de trouver ce type d’évènement.',

    'personalization_life_event_category_work_education' => 'Travail & formation',
    'personalization_life_event_category_family_relationships' => 'Famille & relations',
    'personalization_life_event_category_home_living' => 'Foyer & vie domestique',
    'personalization_life_event_category_travel_experiences' => 'Voyages & expériences',
    'personalization_life_event_category_health_wellness' => 'Santé & bien-être',

    'personalization_life_event_type_new_job' => 'Nouveau travail',
    'personalization_life_event_type_retirement' => 'Retraite',
    'personalization_life_event_type_new_school' => 'Nouvelle école',
    'personalization_life_event_type_study_abroad' => 'Allé étudier à l’étranger',
    'personalization_life_event_type_volunteer_work' => 'Travail bénévole',
    'personalization_life_event_type_published_book_or_paper' => 'Publication d’un livre ou d’un papier',
    'personalization_life_event_type_military_service' => 'Service militaire',
    'personalization_life_event_type_first_met' => 'Première rencontre',
    'personalization_life_event_type_new_relationship' => 'Nouvelle relation',
    'personalization_life_event_type_engagement' => 'Fiançailles',
    'personalization_life_event_type_marriage' => 'Mariage',
    'personalization_life_event_type_anniversary' => 'Anniversaire',
    'personalization_life_event_type_expecting_a_baby' => 'Attend un bébé',
    'personalization_life_event_type_new_child' => 'Nouvel enfant',
    'personalization_life_event_type_new_family_member' => 'Nouveau membre dans la famille',
    'personalization_life_event_type_new_pet' => 'Nouvel animal de compagnie',
    'personalization_life_event_type_end_of_relationship' => 'Fin de relation',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Perte d’un être cher',
    'personalization_life_event_type_moved' => 'Déménagement',
    'personalization_life_event_type_bought_a_home' => 'Nouvelle maison',
    'personalization_life_event_type_home_improvement' => 'Améliorations de la maison',
    'personalization_life_event_type_holidays' => 'Vacances',
    'personalization_life_event_type_new_vehicle' => 'Nouveau véhicule',
    'personalization_life_event_type_new_roommate' => 'Nouveau colocataire',
    'personalization_life_event_type_overcame_an_illness' => 'A surmonté une maladie',
    'personalization_life_event_type_quit_a_habit' => 'Perte d’une habitude',
    'personalization_life_event_type_new_eating_habits' => 'Nouvelles habitudes alimentaires',
    'personalization_life_event_type_weight_loss' => 'Perte de poids',
    'personalization_life_event_type_wear_glass_or_contact' => 'A commencé à porter des lunettes ou des lentilles de contact',
    'personalization_life_event_type_broken_bone' => 'S’est cassé un os',
    'personalization_life_event_type_removed_braces' => 'S’est fait retiré son appareil dentaire',
    'personalization_life_event_type_surgery' => 'A eu une opération chirurgicale',
    'personalization_life_event_type_dentist' => 'A eu un traitement dentaire',
    'personalization_life_event_type_new_sport' => 'A commencé un nouveau sport',
    'personalization_life_event_type_new_hobby' => 'A commencé un nouveau passe-temps',
    'personalization_life_event_type_new_instrument' => 'A commencé à jouer d’un nouvel instrument',
    'personalization_life_event_type_new_language' => 'A commencé à apprendre une nouvelle langue',
    'personalization_life_event_type_tattoo_or_piercing' => 'Tatouage ou piercing',
    'personalization_life_event_type_new_license' => 'Nouveau permis',
    'personalization_life_event_type_travel' => 'Voyage',
    'personalization_life_event_type_achievement_or_award' => 'Récompense ou prix',
    'personalization_life_event_type_changed_beliefs' => 'Changement de croyances',
    'personalization_life_event_type_first_word' => 'Premier mot',
    'personalization_life_event_type_first_kiss' => 'Premier baiser',

    'storage_title' => 'Espace de stockage',
    'storage_account_info' => 'La limite de votre compte est : :accountLimit Mo. Votre utilisation actuelle est : :currentAccountSize Mo (environ :percentUsage %).',
    'storage_upgrade_notice' => 'Mettez à niveau votre compte pour pouvoir télécharger des documents et des photos.',
    'storage_description' => 'Ici vous pouvez voir tous les documents et photos téléchargés sur vos contacts.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Vous trouverez ici tous les paramètres pour utiliser les ressources WebDAV pour CardDAV et CalDAV.',
    'dav_copy_help' => 'Copier dans votre presse-papier',
    'dav_clipboard_copied' => 'Valeur copiée dans le presse-papier',
    'dav_url_base' => 'Url de base pour toutes les ressources CardDAV et CalDAV :',
    'dav_connect_help' => 'Vous pouvez connecter vos contacts et/ou calendriers avec cette url de base sur votre téléphone ou ordinateur.',
    'dav_connect_help2' => 'Utilisez votre login (email) et créez un jeton API en tant que mot de passe pour vous authentifier.',
    'dav_url_carddav' => 'Url CardDAV pour les Contacts :',
    'dav_url_caldav_birthdays' => 'Url CalDAV pour les Anniversaires :',
    'dav_url_caldav_tasks' => 'Url CalDAV pour les Tâches :',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Exporter tous les contacts dans un seul fichier',
    'dav_caldav_birthdays_export' => 'Exporter tous les anniversaires dans un seul fichier',
    'dav_caldav_tasks_export' => 'Exporter toutes les tâches dans un seul fichier',

    'archive_title' => 'Archiver tous les contacts de votre compte',
    'archive_desc' => 'Ceci va archiver tous les contacts de votre compte.',
    'archive_cta' => 'Archiver tous vos contacts',

    'logs_title' => 'Tout ce qui est arrivé à ce compte',
    'logs_actor' => 'Acteur',
    'logs_timestamp' => 'Horodatage',
    'logs_description' => 'Description',
    'logs_subject' => 'Sujet',
    'logs_size' => 'Taille (Ko)',
    'logs_object' => 'Objet',
];
