/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import javax.swing.JComponent;
import javax.swing.JSlider;
import org.jhotdraw.gui.AttributeEditor;

public class JAttributeSlider
extends JSlider
implements AttributeEditor<Double> {
    private boolean isMultipleValues;
    private Double attributeValue;
    private double scaleFactor = 1.0;

    public JAttributeSlider() {
        this(1, 0, 100, 50);
    }

    public JAttributeSlider(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setAttributeValue(Double d) {
        this.attributeValue = d;
        this.setValue((int)(d * this.scaleFactor));
    }

    @Override
    public Double getAttributeValue() {
        return this.attributeValue;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setMultipleValues(boolean bl) {
        boolean bl2 = this.isMultipleValues;
        this.isMultipleValues = bl;
        this.firePropertyChange("multipleValues", bl2, bl);
    }

    @Override
    public boolean isMultipleValues() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
        Double d = this.attributeValue;
        this.attributeValue = (double)this.getValue() / this.scaleFactor;
        this.firePropertyChange("attributeValue", d, this.attributeValue);
    }

    private void initComponents() {
    }
}

