/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JTextField;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.TextHolderFigure;

public class FloatingTextField {
    private TextHolderFigure editedFigure;
    private JTextField textField;
    private DrawingView view;
    private FigureListener figureHandler = new FigureAdapter(){

        @Override
        public void attributeChanged(FigureEvent figureEvent) {
            FloatingTextField.this.updateWidget();
        }
    };

    public FloatingTextField() {
        this.textField = new JTextField(20);
    }

    public void createOverlay(DrawingView drawingView) {
        this.createOverlay(drawingView, null);
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void createOverlay(DrawingView drawingView, TextHolderFigure textHolderFigure) {
        drawingView.getComponent().add((Component)this.textField, 0);
        this.textField.setText(textHolderFigure.getText());
        this.textField.setColumns(textHolderFigure.getTextColumns());
        this.textField.selectAll();
        this.textField.setVisible(true);
        this.editedFigure = textHolderFigure;
        this.editedFigure.addFigureListener(this.figureHandler);
        this.view = drawingView;
        this.updateWidget();
    }

    protected void updateWidget() {
        Font font = this.editedFigure.getFont();
        font = font.deriveFont(font.getStyle(), (float)((double)this.editedFigure.getFontSize() * this.view.getScaleFactor()));
        this.textField.setFont(font);
        this.textField.setForeground(this.editedFigure.getTextColor());
        this.textField.setBackground(this.editedFigure.getFillColor());
        Rectangle2D.Double double_ = this.editedFigure.getBounds();
        Point2D.Double double_2 = new Point2D.Double(double_.getX(), double_.getY());
        if (this.editedFigure.get(AttributeKeys.TRANSFORM) != null) {
            this.editedFigure.get(AttributeKeys.TRANSFORM).transform(double_2, double_2);
        }
        Point point = this.view.drawingToView(double_2);
        Rectangle rectangle = this.view.drawingToView(double_);
        rectangle.x = point.x;
        rectangle.y = point.y;
        Dimension dimension = this.textField.getPreferredSize();
        Insets insets = this.textField.getInsets();
        float f = this.textField.getGraphics().getFontMetrics(font).getMaxAscent();
        double d = this.editedFigure.getBaseline() * this.view.getScaleFactor();
        this.textField.setBounds(rectangle.x - insets.left, rectangle.y - insets.top - (int)((double)f - d), Math.max(rectangle.width + insets.left + insets.right, dimension.width), Math.max(rectangle.height + insets.top + insets.bottom, dimension.height));
    }

    public Insets getInsets() {
        return this.textField.getInsets();
    }

    public void addActionListener(ActionListener actionListener) {
        this.textField.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.textField.removeActionListener(actionListener);
    }

    public String getText() {
        return this.textField.getText();
    }

    public Dimension getPreferredSize(int n) {
        this.textField.setColumns(n);
        return this.textField.getPreferredSize();
    }

    public void endOverlay() {
        this.view.getComponent().requestFocus();
        if (this.textField != null) {
            this.textField.setVisible(false);
            this.view.getComponent().remove(this.textField);
            Rectangle rectangle = this.textField.getBounds();
            this.view.getComponent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.editedFigure != null) {
            this.editedFigure.removeFigureListener(this.figureHandler);
            this.editedFigure = null;
        }
    }
}

