/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.internal.AbstractMavenPluginDependenciesValidator;
import org.apache.maven.plugin.internal.DefaultPluginValidationManager;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

@Singleton
@Named
class MavenScopeDependenciesValidator
extends AbstractMavenPluginDependenciesValidator {
    @Inject
    MavenScopeDependenciesValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected void doValidate(RepositorySystemSession session, Artifact pluginArtifact, ArtifactDescriptorResult artifactDescriptorResult) {
        Set mavenArtifacts = artifactDescriptorResult.getDependencies().stream().filter(d -> !"provided".equals(d.getScope()) && !"test".equals(d.getScope())).map(Dependency::getArtifact).filter(a -> "org.apache.maven".equals(a.getGroupId())).filter(a -> !DefaultPluginValidationManager.EXPECTED_PROVIDED_SCOPE_EXCLUSIONS_GA.contains(a.getGroupId() + ":" + a.getArtifactId())).filter(a -> a.getVersion().startsWith("3.")).map(a -> a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion()).collect(Collectors.toSet());
        if (!mavenArtifacts.isEmpty()) {
            this.pluginValidationManager.reportPluginValidationIssue(PluginValidationManager.IssueLocality.EXTERNAL, session, pluginArtifact, "Plugin should declare Maven artifacts in `provided` scope. If the plugin already declares them in `provided` scope, update the maven-plugin-plugin to latest version. Artifacts found with wrong scope: " + mavenArtifacts);
        }
    }
}

