/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHandJointLocationEXT;
import org.lwjgl.openxr.XrHandJointVelocitiesEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandJointLocationsEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ISACTIVE;
    public static final int JOINTCOUNT;
    public static final int JOINTLOCATIONS;

    public XrHandJointLocationsEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandJointLocationsEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandJointLocationsEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandJointLocationsEXT.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrHandJointLocationsEXT.nisActive(this.address()) != 0;
    }

    @NativeType(value="uint32_t")
    public int jointCount() {
        return XrHandJointLocationsEXT.njointCount(this.address());
    }

    @NativeType(value="XrHandJointLocationEXT *")
    public XrHandJointLocationEXT.Buffer jointLocations() {
        return XrHandJointLocationsEXT.njointLocations(this.address());
    }

    public XrHandJointLocationsEXT type(@NativeType(value="XrStructureType") int value) {
        XrHandJointLocationsEXT.ntype(this.address(), value);
        return this;
    }

    public XrHandJointLocationsEXT type$Default() {
        return this.type(1000051003);
    }

    public XrHandJointLocationsEXT next(@NativeType(value="void *") long value) {
        XrHandJointLocationsEXT.nnext(this.address(), value);
        return this;
    }

    public XrHandJointLocationsEXT next(XrHandJointVelocitiesEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrHandJointLocationsEXT isActive(@NativeType(value="XrBool32") boolean value) {
        XrHandJointLocationsEXT.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrHandJointLocationsEXT jointLocations(@NativeType(value="XrHandJointLocationEXT *") XrHandJointLocationEXT.Buffer value) {
        XrHandJointLocationsEXT.njointLocations(this.address(), value);
        return this;
    }

    public XrHandJointLocationsEXT set(int type, long next, boolean isActive, XrHandJointLocationEXT.Buffer jointLocations) {
        this.type(type);
        this.next(next);
        this.isActive(isActive);
        this.jointLocations(jointLocations);
        return this;
    }

    public XrHandJointLocationsEXT set(XrHandJointLocationsEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandJointLocationsEXT malloc() {
        return (XrHandJointLocationsEXT)XrHandJointLocationsEXT.wrap(XrHandJointLocationsEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrHandJointLocationsEXT calloc() {
        return (XrHandJointLocationsEXT)XrHandJointLocationsEXT.wrap(XrHandJointLocationsEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrHandJointLocationsEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrHandJointLocationsEXT)XrHandJointLocationsEXT.wrap(XrHandJointLocationsEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrHandJointLocationsEXT create(long address) {
        return (XrHandJointLocationsEXT)XrHandJointLocationsEXT.wrap(XrHandJointLocationsEXT.class, (long)address);
    }

    @Nullable
    public static XrHandJointLocationsEXT createSafe(long address) {
        return address == 0L ? null : (XrHandJointLocationsEXT)XrHandJointLocationsEXT.wrap(XrHandJointLocationsEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrHandJointLocationsEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrHandJointLocationsEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrHandJointLocationsEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandJointLocationsEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrHandJointLocationsEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrHandJointLocationsEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrHandJointLocationsEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrHandJointLocationsEXT malloc(MemoryStack stack) {
        return (XrHandJointLocationsEXT)XrHandJointLocationsEXT.wrap(XrHandJointLocationsEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandJointLocationsEXT calloc(MemoryStack stack) {
        return (XrHandJointLocationsEXT)XrHandJointLocationsEXT.wrap(XrHandJointLocationsEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrHandJointLocationsEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrHandJointLocationsEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nisActive(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISACTIVE);
    }

    public static int njointCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)JOINTCOUNT);
    }

    public static XrHandJointLocationEXT.Buffer njointLocations(long struct) {
        return XrHandJointLocationEXT.create(MemoryUtil.memGetAddress((long)(struct + (long)JOINTLOCATIONS)), XrHandJointLocationsEXT.njointCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nisActive(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ISACTIVE, value);
    }

    public static void njointCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)JOINTCOUNT, value);
    }

    public static void njointLocations(long struct, XrHandJointLocationEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)JOINTLOCATIONS), (long)value.address());
        XrHandJointLocationsEXT.njointCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)JOINTLOCATIONS)));
    }

    static {
        Struct.Layout layout = XrHandJointLocationsEXT.__struct((Struct.Member[])new Struct.Member[]{XrHandJointLocationsEXT.__member((int)4), XrHandJointLocationsEXT.__member((int)POINTER_SIZE), XrHandJointLocationsEXT.__member((int)4), XrHandJointLocationsEXT.__member((int)4), XrHandJointLocationsEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ISACTIVE = layout.offsetof(2);
        JOINTCOUNT = layout.offsetof(3);
        JOINTLOCATIONS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrHandJointLocationsEXT, Buffer>
    implements NativeResource {
        private static final XrHandJointLocationsEXT ELEMENT_FACTORY = XrHandJointLocationsEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHandJointLocationsEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandJointLocationsEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandJointLocationsEXT.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrHandJointLocationsEXT.nisActive(this.address()) != 0;
        }

        @NativeType(value="uint32_t")
        public int jointCount() {
            return XrHandJointLocationsEXT.njointCount(this.address());
        }

        @NativeType(value="XrHandJointLocationEXT *")
        public XrHandJointLocationEXT.Buffer jointLocations() {
            return XrHandJointLocationsEXT.njointLocations(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandJointLocationsEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000051003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandJointLocationsEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrHandJointVelocitiesEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrHandJointLocationsEXT.nisActive(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer jointLocations(@NativeType(value="XrHandJointLocationEXT *") XrHandJointLocationEXT.Buffer value) {
            XrHandJointLocationsEXT.njointLocations(this.address(), value);
            return this;
        }
    }
}

