/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtensionProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int EXTENSIONNAME;
    public static final int EXTENSIONVERSION;

    public XrExtensionProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrExtensionProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrExtensionProperties.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrExtensionProperties.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer extensionName() {
        return XrExtensionProperties.nextensionName(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
    public String extensionNameString() {
        return XrExtensionProperties.nextensionNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int extensionVersion() {
        return XrExtensionProperties.nextensionVersion(this.address());
    }

    public XrExtensionProperties type(@NativeType(value="XrStructureType") int value) {
        XrExtensionProperties.ntype(this.address(), value);
        return this;
    }

    public XrExtensionProperties type$Default() {
        return this.type(2);
    }

    public XrExtensionProperties next(@NativeType(value="void *") long value) {
        XrExtensionProperties.nnext(this.address(), value);
        return this;
    }

    public XrExtensionProperties set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrExtensionProperties set(XrExtensionProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExtensionProperties malloc() {
        return (XrExtensionProperties)XrExtensionProperties.wrap(XrExtensionProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrExtensionProperties calloc() {
        return (XrExtensionProperties)XrExtensionProperties.wrap(XrExtensionProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrExtensionProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrExtensionProperties)XrExtensionProperties.wrap(XrExtensionProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrExtensionProperties create(long address) {
        return (XrExtensionProperties)XrExtensionProperties.wrap(XrExtensionProperties.class, (long)address);
    }

    @Nullable
    public static XrExtensionProperties createSafe(long address) {
        return address == 0L ? null : (XrExtensionProperties)XrExtensionProperties.wrap(XrExtensionProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrExtensionProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrExtensionProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrExtensionProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtensionProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrExtensionProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrExtensionProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrExtensionProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrExtensionProperties malloc(MemoryStack stack) {
        return (XrExtensionProperties)XrExtensionProperties.wrap(XrExtensionProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrExtensionProperties calloc(MemoryStack stack) {
        return (XrExtensionProperties)XrExtensionProperties.wrap(XrExtensionProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrExtensionProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrExtensionProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static ByteBuffer nextensionName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)EXTENSIONNAME), (int)128);
    }

    public static String nextensionNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)EXTENSIONNAME));
    }

    public static int nextensionVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)EXTENSIONVERSION);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrExtensionProperties.__struct((Struct.Member[])new Struct.Member[]{XrExtensionProperties.__member((int)4), XrExtensionProperties.__member((int)POINTER_SIZE), XrExtensionProperties.__array((int)1, (int)128), XrExtensionProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        EXTENSIONNAME = layout.offsetof(2);
        EXTENSIONVERSION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrExtensionProperties, Buffer>
    implements NativeResource {
        private static final XrExtensionProperties ELEMENT_FACTORY = XrExtensionProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrExtensionProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrExtensionProperties.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrExtensionProperties.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer extensionName() {
            return XrExtensionProperties.nextensionName(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
        public String extensionNameString() {
            return XrExtensionProperties.nextensionNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int extensionVersion() {
            return XrExtensionProperties.nextensionVersion(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrExtensionProperties.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(2);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrExtensionProperties.nnext(this.address(), value);
            return this;
        }
    }
}

