/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEventDataDisplayRefreshRateChangedFB;
import org.lwjgl.openxr.XrEventDataEventsLost;
import org.lwjgl.openxr.XrEventDataInstanceLossPending;
import org.lwjgl.openxr.XrEventDataInteractionProfileChanged;
import org.lwjgl.openxr.XrEventDataMainSessionVisibilityChangedEXTX;
import org.lwjgl.openxr.XrEventDataMarkerTrackingUpdateVARJO;
import org.lwjgl.openxr.XrEventDataPerfSettingsEXT;
import org.lwjgl.openxr.XrEventDataReferenceSpaceChangePending;
import org.lwjgl.openxr.XrEventDataSessionStateChanged;
import org.lwjgl.openxr.XrEventDataVisibilityMaskChangedKHR;
import org.lwjgl.openxr.XrEventDataViveTrackerConnectedHTCX;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataBaseHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrEventDataBaseHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrEventDataBaseHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataBaseHeader.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataBaseHeader.nnext(this.address());
    }

    public XrEventDataBaseHeader type(@NativeType(value="XrStructureType") int value) {
        XrEventDataBaseHeader.ntype(this.address(), value);
        return this;
    }

    public XrEventDataBaseHeader next(@NativeType(value="void const *") long value) {
        XrEventDataBaseHeader.nnext(this.address(), value);
        return this;
    }

    public XrEventDataBaseHeader set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrEventDataBaseHeader set(XrEventDataBaseHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrEventDataBaseHeader malloc() {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrEventDataBaseHeader calloc() {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrEventDataBaseHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrEventDataBaseHeader create(long address) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (long)address);
    }

    @Nullable
    public static XrEventDataBaseHeader createSafe(long address) {
        return address == 0L ? null : (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (long)address);
    }

    public static XrEventDataBaseHeader create(XrEventDataEventsLost value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static XrEventDataBaseHeader create(XrEventDataInstanceLossPending value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static XrEventDataBaseHeader create(XrEventDataSessionStateChanged value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static XrEventDataBaseHeader create(XrEventDataReferenceSpaceChangePending value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static XrEventDataBaseHeader create(XrEventDataInteractionProfileChanged value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static XrEventDataBaseHeader create(XrEventDataPerfSettingsEXT value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static XrEventDataBaseHeader create(XrEventDataVisibilityMaskChangedKHR value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static XrEventDataBaseHeader create(XrEventDataMainSessionVisibilityChangedEXTX value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static XrEventDataBaseHeader create(XrEventDataDisplayRefreshRateChangedFB value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static XrEventDataBaseHeader create(XrEventDataViveTrackerConnectedHTCX value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static XrEventDataBaseHeader create(XrEventDataMarkerTrackingUpdateVARJO value) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (Struct)value);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrEventDataBaseHeader.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataBaseHeader.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static Buffer create(XrEventDataEventsLost.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrEventDataInstanceLossPending.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrEventDataSessionStateChanged.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrEventDataReferenceSpaceChangePending.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrEventDataInteractionProfileChanged.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrEventDataPerfSettingsEXT.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrEventDataVisibilityMaskChangedKHR.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrEventDataMainSessionVisibilityChangedEXTX.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrEventDataDisplayRefreshRateChangedFB.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrEventDataViveTrackerConnectedHTCX.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrEventDataMarkerTrackingUpdateVARJO.Buffer value) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static XrEventDataBaseHeader malloc(MemoryStack stack) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrEventDataBaseHeader calloc(MemoryStack stack) {
        return (XrEventDataBaseHeader)XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrEventDataBaseHeader.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrEventDataBaseHeader.__struct((Struct.Member[])new Struct.Member[]{XrEventDataBaseHeader.__member((int)4), XrEventDataBaseHeader.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataBaseHeader, Buffer>
    implements NativeResource {
        private static final XrEventDataBaseHeader ELEMENT_FACTORY = XrEventDataBaseHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrEventDataBaseHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataBaseHeader.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataBaseHeader.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataBaseHeader.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataBaseHeader.nnext(this.address(), value);
            return this;
        }
    }
}

