/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBaseOutStructure
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrBaseOutStructure(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBaseOutStructure.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBaseOutStructure.ntype(this.address());
    }

    @NativeType(value="XrBaseOutStructure *")
    public XrBaseOutStructure next() {
        return XrBaseOutStructure.nnext(this.address());
    }

    public XrBaseOutStructure type(@NativeType(value="XrStructureType") int value) {
        XrBaseOutStructure.ntype(this.address(), value);
        return this;
    }

    public XrBaseOutStructure next(@NativeType(value="XrBaseOutStructure *") XrBaseOutStructure value) {
        XrBaseOutStructure.nnext(this.address(), value);
        return this;
    }

    public XrBaseOutStructure set(int type, XrBaseOutStructure next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrBaseOutStructure set(XrBaseOutStructure src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBaseOutStructure malloc() {
        return (XrBaseOutStructure)XrBaseOutStructure.wrap(XrBaseOutStructure.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrBaseOutStructure calloc() {
        return (XrBaseOutStructure)XrBaseOutStructure.wrap(XrBaseOutStructure.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrBaseOutStructure create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrBaseOutStructure)XrBaseOutStructure.wrap(XrBaseOutStructure.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrBaseOutStructure create(long address) {
        return (XrBaseOutStructure)XrBaseOutStructure.wrap(XrBaseOutStructure.class, (long)address);
    }

    @Nullable
    public static XrBaseOutStructure createSafe(long address) {
        return address == 0L ? null : (XrBaseOutStructure)XrBaseOutStructure.wrap(XrBaseOutStructure.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrBaseOutStructure.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrBaseOutStructure.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrBaseOutStructure.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBaseOutStructure.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrBaseOutStructure.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrBaseOutStructure.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrBaseOutStructure.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrBaseOutStructure malloc(MemoryStack stack) {
        return (XrBaseOutStructure)XrBaseOutStructure.wrap(XrBaseOutStructure.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrBaseOutStructure calloc(MemoryStack stack) {
        return (XrBaseOutStructure)XrBaseOutStructure.wrap(XrBaseOutStructure.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBaseOutStructure.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBaseOutStructure.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static XrBaseOutStructure nnext(long struct) {
        return XrBaseOutStructure.create(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, XrBaseOutStructure value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    static {
        Struct.Layout layout = XrBaseOutStructure.__struct((Struct.Member[])new Struct.Member[]{XrBaseOutStructure.__member((int)4), XrBaseOutStructure.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBaseOutStructure, Buffer>
    implements NativeResource {
        private static final XrBaseOutStructure ELEMENT_FACTORY = XrBaseOutStructure.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrBaseOutStructure getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBaseOutStructure.ntype(this.address());
        }

        @NativeType(value="XrBaseOutStructure *")
        public XrBaseOutStructure next() {
            return XrBaseOutStructure.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBaseOutStructure.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="XrBaseOutStructure *") XrBaseOutStructure value) {
            XrBaseOutStructure.nnext(this.address(), value);
            return this;
        }
    }
}

