/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct parsl_position")
public class ParSLPosition
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public ParSLPosition(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ParSLPosition.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return ParSLPosition.nx(this.address());
    }

    public float y() {
        return ParSLPosition.ny(this.address());
    }

    public ParSLPosition x(float value) {
        ParSLPosition.nx(this.address(), value);
        return this;
    }

    public ParSLPosition y(float value) {
        ParSLPosition.ny(this.address(), value);
        return this;
    }

    public ParSLPosition set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public ParSLPosition set(ParSLPosition src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ParSLPosition malloc() {
        return (ParSLPosition)ParSLPosition.wrap(ParSLPosition.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ParSLPosition calloc() {
        return (ParSLPosition)ParSLPosition.wrap(ParSLPosition.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ParSLPosition create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ParSLPosition)ParSLPosition.wrap(ParSLPosition.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ParSLPosition create(long address) {
        return (ParSLPosition)ParSLPosition.wrap(ParSLPosition.class, (long)address);
    }

    @Nullable
    public static ParSLPosition createSafe(long address) {
        return address == 0L ? null : (ParSLPosition)ParSLPosition.wrap(ParSLPosition.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ParSLPosition.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ParSLPosition.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ParSLPosition.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ParSLPosition.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ParSLPosition.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ParSLPosition.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ParSLPosition.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static ParSLPosition mallocStack() {
        return ParSLPosition.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ParSLPosition callocStack() {
        return ParSLPosition.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ParSLPosition mallocStack(MemoryStack stack) {
        return ParSLPosition.malloc(stack);
    }

    @Deprecated
    public static ParSLPosition callocStack(MemoryStack stack) {
        return ParSLPosition.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ParSLPosition.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ParSLPosition.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ParSLPosition.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ParSLPosition.calloc(capacity, stack);
    }

    public static ParSLPosition malloc(MemoryStack stack) {
        return (ParSLPosition)ParSLPosition.wrap(ParSLPosition.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ParSLPosition calloc(MemoryStack stack) {
        return (ParSLPosition)ParSLPosition.wrap(ParSLPosition.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)ParSLPosition.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)ParSLPosition.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = ParSLPosition.__struct((Struct.Member[])new Struct.Member[]{ParSLPosition.__member((int)4), ParSLPosition.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<ParSLPosition, Buffer>
    implements NativeResource {
        private static final ParSLPosition ELEMENT_FACTORY = ParSLPosition.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ParSLPosition getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return ParSLPosition.nx(this.address());
        }

        public float y() {
            return ParSLPosition.ny(this.address());
        }

        public Buffer x(float value) {
            ParSLPosition.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            ParSLPosition.ny(this.address(), value);
            return this;
        }
    }
}

