/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUexecAffinitySmCount;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUexecAffinityParam
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int PARAM;
    public static final int PARAM_SMCOUNT;

    public CUexecAffinityParam(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUexecAffinityParam.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUexecAffinityType")
    public int type() {
        return CUexecAffinityParam.ntype(this.address());
    }

    public CUexecAffinitySmCount param_smCount() {
        return CUexecAffinityParam.nparam_smCount(this.address());
    }

    public CUexecAffinityParam type(@NativeType(value="CUexecAffinityType") int value) {
        CUexecAffinityParam.ntype(this.address(), value);
        return this;
    }

    public CUexecAffinityParam param_smCount(CUexecAffinitySmCount value) {
        CUexecAffinityParam.nparam_smCount(this.address(), value);
        return this;
    }

    public CUexecAffinityParam param_smCount(Consumer<CUexecAffinitySmCount> consumer) {
        consumer.accept(this.param_smCount());
        return this;
    }

    public CUexecAffinityParam set(CUexecAffinityParam src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUexecAffinityParam malloc() {
        return (CUexecAffinityParam)CUexecAffinityParam.wrap(CUexecAffinityParam.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUexecAffinityParam calloc() {
        return (CUexecAffinityParam)CUexecAffinityParam.wrap(CUexecAffinityParam.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUexecAffinityParam create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUexecAffinityParam)CUexecAffinityParam.wrap(CUexecAffinityParam.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUexecAffinityParam create(long address) {
        return (CUexecAffinityParam)CUexecAffinityParam.wrap(CUexecAffinityParam.class, (long)address);
    }

    @Nullable
    public static CUexecAffinityParam createSafe(long address) {
        return address == 0L ? null : (CUexecAffinityParam)CUexecAffinityParam.wrap(CUexecAffinityParam.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUexecAffinityParam.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUexecAffinityParam.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUexecAffinityParam.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUexecAffinityParam.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUexecAffinityParam.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUexecAffinityParam.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUexecAffinityParam.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CUexecAffinityParam malloc(MemoryStack stack) {
        return (CUexecAffinityParam)CUexecAffinityParam.wrap(CUexecAffinityParam.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUexecAffinityParam calloc(MemoryStack stack) {
        return (CUexecAffinityParam)CUexecAffinityParam.wrap(CUexecAffinityParam.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUexecAffinityParam.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUexecAffinityParam.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static CUexecAffinitySmCount nparam_smCount(long struct) {
        return CUexecAffinitySmCount.create(struct + (long)PARAM_SMCOUNT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nparam_smCount(long struct, CUexecAffinitySmCount value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAM_SMCOUNT), (long)CUexecAffinitySmCount.SIZEOF);
    }

    static {
        Struct.Layout layout = CUexecAffinityParam.__struct((Struct.Member[])new Struct.Member[]{CUexecAffinityParam.__member((int)4), CUexecAffinityParam.__union((Struct.Member[])new Struct.Member[]{CUexecAffinityParam.__member((int)CUexecAffinitySmCount.SIZEOF, (int)CUexecAffinitySmCount.ALIGNOF)})});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        PARAM = layout.offsetof(1);
        PARAM_SMCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CUexecAffinityParam, Buffer>
    implements NativeResource {
        private static final CUexecAffinityParam ELEMENT_FACTORY = CUexecAffinityParam.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUexecAffinityParam getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUexecAffinityType")
        public int type() {
            return CUexecAffinityParam.ntype(this.address());
        }

        public CUexecAffinitySmCount param_smCount() {
            return CUexecAffinityParam.nparam_smCount(this.address());
        }

        public Buffer type(@NativeType(value="CUexecAffinityType") int value) {
            CUexecAffinityParam.ntype(this.address(), value);
            return this;
        }

        public Buffer param_smCount(CUexecAffinitySmCount value) {
            CUexecAffinityParam.nparam_smCount(this.address(), value);
            return this;
        }

        public Buffer param_smCount(Consumer<CUexecAffinitySmCount> consumer) {
            consumer.accept(this.param_smCount());
            return this;
        }
    }
}

