/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.lwjgl.cuda.CU;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Library;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class CUDA {
    private static final String TOOLKIT_DEFAULT_ROOT;
    private static final String TOOLKIT_PREFIX;
    private static final Pattern TOOLKIT_REGEX;

    private CUDA() {
    }

    public static boolean isPerThreadDefaultStreamSupported() {
        try (SharedLibrary lib = Library.loadNative(CU.class, (String)"org.lwjgl.cuda", (Configuration)Configuration.CUDA_LIBRARY_NAME, (String[])new String[]{"nvcuda"});){
            boolean bl = lib.getFunctionAddress((CharSequence)"cuLaunchKernel_ptsz") != 0L;
            return bl;
        }
    }

    private static Path getToolkitPath() {
        Path path2;
        block11: {
            Path toolkit;
            String toolkitPath = (String)Configuration.CUDA_TOOLKIT_PATH.get();
            if (toolkitPath != null) {
                return Paths.get(toolkitPath, new String[0]);
            }
            String version = (String)Configuration.CUDA_TOOLKIT_VERSION.get();
            if (version != null && Files.isDirectory(toolkit = Paths.get(TOOLKIT_DEFAULT_ROOT + TOOLKIT_PREFIX + version, new String[0]), new LinkOption[0])) {
                return toolkit;
            }
            Path root = Paths.get(TOOLKIT_DEFAULT_ROOT, new String[0]);
            if (!Files.isDirectory(root, new LinkOption[0])) {
                throw new IllegalStateException("Failed to find CUDA Toolkit root path.");
            }
            Stream<Path> directories = Files.find(root, 1, (path, basicFileAttributes) -> basicFileAttributes.isDirectory() && TOOLKIT_REGEX.matcher(path.getFileName().toString()).matches(), new FileVisitOption[0]);
            try {
                path2 = directories.max(Comparator.comparing(path -> {
                    Matcher m = TOOLKIT_REGEX.matcher(path.getFileName().toString());
                    if (!m.find()) {
                        throw new IllegalStateException();
                    }
                    return APIUtil.apiParseVersion((String)m.group(1));
                })).orElseThrow(() -> new IllegalStateException("Failed to find CUDA Toolkit path."));
                if (directories == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (directories != null) {
                        try {
                            directories.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            directories.close();
        }
        return path2;
    }

    private static String getToolkitLibrary(String name) {
        String string;
        block13: {
            Path toolkit = CUDA.getToolkitPath();
            switch (Platform.get()) {
                case LINUX: 
                case MACOSX: {
                    toolkit = toolkit.resolve("lib");
                    break;
                }
                case WINDOWS: {
                    toolkit = toolkit.resolve("bin");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (!Files.isDirectory(toolkit, new LinkOption[0])) {
                throw new IllegalStateException();
            }
            Stream<Path> files = Files.find(toolkit, 1, (path, basicFileAttributes) -> {
                if (basicFileAttributes.isRegularFile()) {
                    String fileName = path.getFileName().toString();
                    switch (Platform.get()) {
                        case LINUX: {
                            if (!fileName.startsWith("lib" + name) || !fileName.endsWith(".so")) break;
                            return true;
                        }
                        case MACOSX: {
                            if (!fileName.startsWith("lib" + name) || !fileName.endsWith(".dylib")) break;
                            return true;
                        }
                        case WINDOWS: {
                            if (!fileName.startsWith(name + "64") || !fileName.endsWith(".dll")) break;
                            return true;
                        }
                    }
                }
                return false;
            }, new FileVisitOption[0]);
            try {
                string = files.findAny().map(path -> path.toAbsolutePath().toString()).orElseThrow(IllegalStateException::new);
                if (files == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            files.close();
        }
        return string;
    }

    static SharedLibrary getToolkitLibrary(Class<?> context, Configuration<String> option, String name) {
        return Library.loadNative(context, (String)"org.lwjgl.cuda", option, () -> Library.loadNative((Class)context, (String)"org.lwjgl.cuda", (String)CUDA.getToolkitLibrary(name)), (String[])new String[]{name});
    }

    static String __CUDA_API_PTDS(String api) {
        return (Boolean)Configuration.CUDA_API_PER_THREAD_DEFAULT_STREAM.get((Object)false) != false ? api + "_ptds" : api;
    }

    static String __CUDA_API_PTSZ(String api) {
        return (Boolean)Configuration.CUDA_API_PER_THREAD_DEFAULT_STREAM.get((Object)false) != false ? api + "_ptsz" : api;
    }

    static String __CUDA_API_VERSION(String api, int version) {
        SharedLibrary CUDA2 = CU.getLibrary();
        for (int i = version; 1 < i; --i) {
            String functionName = api + "_v" + i;
            if (CUDA2.getFunctionAddress((CharSequence)functionName) == 0L) continue;
            return functionName;
        }
        return api;
    }

    static {
        switch (Platform.get()) {
            case LINUX: {
                TOOLKIT_DEFAULT_ROOT = "/usr/local/";
                TOOLKIT_PREFIX = "cuda-";
                break;
            }
            case MACOSX: {
                TOOLKIT_DEFAULT_ROOT = "/Developer/NVIDIA/";
                TOOLKIT_PREFIX = "CUDA-";
                break;
            }
            case WINDOWS: {
                TOOLKIT_DEFAULT_ROOT = "C:/Program Files/NVIDIA GPU Computing Toolkit/CUDA/";
                TOOLKIT_PREFIX = "v";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        TOOLKIT_REGEX = Pattern.compile("^" + TOOLKIT_PREFIX + "(\\d+\\.\\d+)$");
    }
}

