/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkDisplaySurfaceCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DISPLAYMODE;
    public static final int PLANEINDEX;
    public static final int PLANESTACKINDEX;
    public static final int TRANSFORM;
    public static final int GLOBALALPHA;
    public static final int ALPHAMODE;
    public static final int IMAGEEXTENT;

    public VkDisplaySurfaceCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDisplaySurfaceCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDisplaySurfaceCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDisplaySurfaceCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkDisplaySurfaceCreateFlagsKHR")
    public int flags() {
        return VkDisplaySurfaceCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkDisplayModeKHR")
    public long displayMode() {
        return VkDisplaySurfaceCreateInfoKHR.ndisplayMode(this.address());
    }

    @NativeType(value="uint32_t")
    public int planeIndex() {
        return VkDisplaySurfaceCreateInfoKHR.nplaneIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int planeStackIndex() {
        return VkDisplaySurfaceCreateInfoKHR.nplaneStackIndex(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagBitsKHR")
    public int transform() {
        return VkDisplaySurfaceCreateInfoKHR.ntransform(this.address());
    }

    public float globalAlpha() {
        return VkDisplaySurfaceCreateInfoKHR.nglobalAlpha(this.address());
    }

    @NativeType(value="VkDisplayPlaneAlphaFlagBitsKHR")
    public int alphaMode() {
        return VkDisplaySurfaceCreateInfoKHR.nalphaMode(this.address());
    }

    public VkExtent2D imageExtent() {
        return VkDisplaySurfaceCreateInfoKHR.nimageExtent(this.address());
    }

    public VkDisplaySurfaceCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDisplaySurfaceCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR sType$Default() {
        return this.sType(1000002001);
    }

    public VkDisplaySurfaceCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDisplaySurfaceCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR flags(@NativeType(value="VkDisplaySurfaceCreateFlagsKHR") int value) {
        VkDisplaySurfaceCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR displayMode(@NativeType(value="VkDisplayModeKHR") long value) {
        VkDisplaySurfaceCreateInfoKHR.ndisplayMode(this.address(), value);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR planeIndex(@NativeType(value="uint32_t") int value) {
        VkDisplaySurfaceCreateInfoKHR.nplaneIndex(this.address(), value);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR planeStackIndex(@NativeType(value="uint32_t") int value) {
        VkDisplaySurfaceCreateInfoKHR.nplaneStackIndex(this.address(), value);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR transform(@NativeType(value="VkSurfaceTransformFlagBitsKHR") int value) {
        VkDisplaySurfaceCreateInfoKHR.ntransform(this.address(), value);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR globalAlpha(float value) {
        VkDisplaySurfaceCreateInfoKHR.nglobalAlpha(this.address(), value);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR alphaMode(@NativeType(value="VkDisplayPlaneAlphaFlagBitsKHR") int value) {
        VkDisplaySurfaceCreateInfoKHR.nalphaMode(this.address(), value);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR imageExtent(VkExtent2D value) {
        VkDisplaySurfaceCreateInfoKHR.nimageExtent(this.address(), value);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR imageExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR set(int sType, long pNext, int flags, long displayMode, int planeIndex, int planeStackIndex, int transform, float globalAlpha, int alphaMode, VkExtent2D imageExtent) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.displayMode(displayMode);
        this.planeIndex(planeIndex);
        this.planeStackIndex(planeStackIndex);
        this.transform(transform);
        this.globalAlpha(globalAlpha);
        this.alphaMode(alphaMode);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkDisplaySurfaceCreateInfoKHR set(VkDisplaySurfaceCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDisplaySurfaceCreateInfoKHR malloc() {
        return (VkDisplaySurfaceCreateInfoKHR)VkDisplaySurfaceCreateInfoKHR.wrap(VkDisplaySurfaceCreateInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDisplaySurfaceCreateInfoKHR calloc() {
        return (VkDisplaySurfaceCreateInfoKHR)VkDisplaySurfaceCreateInfoKHR.wrap(VkDisplaySurfaceCreateInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDisplaySurfaceCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDisplaySurfaceCreateInfoKHR)VkDisplaySurfaceCreateInfoKHR.wrap(VkDisplaySurfaceCreateInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDisplaySurfaceCreateInfoKHR create(long address) {
        return (VkDisplaySurfaceCreateInfoKHR)VkDisplaySurfaceCreateInfoKHR.wrap(VkDisplaySurfaceCreateInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkDisplaySurfaceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkDisplaySurfaceCreateInfoKHR)VkDisplaySurfaceCreateInfoKHR.wrap(VkDisplaySurfaceCreateInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDisplaySurfaceCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDisplaySurfaceCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDisplaySurfaceCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplaySurfaceCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDisplaySurfaceCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDisplaySurfaceCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDisplaySurfaceCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkDisplaySurfaceCreateInfoKHR mallocStack() {
        return VkDisplaySurfaceCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplaySurfaceCreateInfoKHR callocStack() {
        return VkDisplaySurfaceCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplaySurfaceCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkDisplaySurfaceCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkDisplaySurfaceCreateInfoKHR callocStack(MemoryStack stack) {
        return VkDisplaySurfaceCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDisplaySurfaceCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDisplaySurfaceCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplaySurfaceCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplaySurfaceCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkDisplaySurfaceCreateInfoKHR malloc(MemoryStack stack) {
        return (VkDisplaySurfaceCreateInfoKHR)VkDisplaySurfaceCreateInfoKHR.wrap(VkDisplaySurfaceCreateInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplaySurfaceCreateInfoKHR calloc(MemoryStack stack) {
        return (VkDisplaySurfaceCreateInfoKHR)VkDisplaySurfaceCreateInfoKHR.wrap(VkDisplaySurfaceCreateInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDisplaySurfaceCreateInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDisplaySurfaceCreateInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long ndisplayMode(long struct) {
        return UNSAFE.getLong(null, struct + (long)DISPLAYMODE);
    }

    public static int nplaneIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)PLANEINDEX);
    }

    public static int nplaneStackIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)PLANESTACKINDEX);
    }

    public static int ntransform(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSFORM);
    }

    public static float nglobalAlpha(long struct) {
        return UNSAFE.getFloat(null, struct + (long)GLOBALALPHA);
    }

    public static int nalphaMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALPHAMODE);
    }

    public static VkExtent2D nimageExtent(long struct) {
        return VkExtent2D.create(struct + (long)IMAGEEXTENT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndisplayMode(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DISPLAYMODE, value);
    }

    public static void nplaneIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PLANEINDEX, value);
    }

    public static void nplaneStackIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PLANESTACKINDEX, value);
    }

    public static void ntransform(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TRANSFORM, value);
    }

    public static void nglobalAlpha(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)GLOBALALPHA, value);
    }

    public static void nalphaMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ALPHAMODE, value);
    }

    public static void nimageExtent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGEEXTENT), (long)VkExtent2D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkDisplaySurfaceCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkDisplaySurfaceCreateInfoKHR.__member((int)4), VkDisplaySurfaceCreateInfoKHR.__member((int)POINTER_SIZE), VkDisplaySurfaceCreateInfoKHR.__member((int)4), VkDisplaySurfaceCreateInfoKHR.__member((int)8), VkDisplaySurfaceCreateInfoKHR.__member((int)4), VkDisplaySurfaceCreateInfoKHR.__member((int)4), VkDisplaySurfaceCreateInfoKHR.__member((int)4), VkDisplaySurfaceCreateInfoKHR.__member((int)4), VkDisplaySurfaceCreateInfoKHR.__member((int)4), VkDisplaySurfaceCreateInfoKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DISPLAYMODE = layout.offsetof(3);
        PLANEINDEX = layout.offsetof(4);
        PLANESTACKINDEX = layout.offsetof(5);
        TRANSFORM = layout.offsetof(6);
        GLOBALALPHA = layout.offsetof(7);
        ALPHAMODE = layout.offsetof(8);
        IMAGEEXTENT = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkDisplaySurfaceCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkDisplaySurfaceCreateInfoKHR ELEMENT_FACTORY = VkDisplaySurfaceCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDisplaySurfaceCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDisplaySurfaceCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDisplaySurfaceCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkDisplaySurfaceCreateFlagsKHR")
        public int flags() {
            return VkDisplaySurfaceCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkDisplayModeKHR")
        public long displayMode() {
            return VkDisplaySurfaceCreateInfoKHR.ndisplayMode(this.address());
        }

        @NativeType(value="uint32_t")
        public int planeIndex() {
            return VkDisplaySurfaceCreateInfoKHR.nplaneIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int planeStackIndex() {
            return VkDisplaySurfaceCreateInfoKHR.nplaneStackIndex(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagBitsKHR")
        public int transform() {
            return VkDisplaySurfaceCreateInfoKHR.ntransform(this.address());
        }

        public float globalAlpha() {
            return VkDisplaySurfaceCreateInfoKHR.nglobalAlpha(this.address());
        }

        @NativeType(value="VkDisplayPlaneAlphaFlagBitsKHR")
        public int alphaMode() {
            return VkDisplaySurfaceCreateInfoKHR.nalphaMode(this.address());
        }

        public VkExtent2D imageExtent() {
            return VkDisplaySurfaceCreateInfoKHR.nimageExtent(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDisplaySurfaceCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000002001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDisplaySurfaceCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDisplaySurfaceCreateFlagsKHR") int value) {
            VkDisplaySurfaceCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer displayMode(@NativeType(value="VkDisplayModeKHR") long value) {
            VkDisplaySurfaceCreateInfoKHR.ndisplayMode(this.address(), value);
            return this;
        }

        public Buffer planeIndex(@NativeType(value="uint32_t") int value) {
            VkDisplaySurfaceCreateInfoKHR.nplaneIndex(this.address(), value);
            return this;
        }

        public Buffer planeStackIndex(@NativeType(value="uint32_t") int value) {
            VkDisplaySurfaceCreateInfoKHR.nplaneStackIndex(this.address(), value);
            return this;
        }

        public Buffer transform(@NativeType(value="VkSurfaceTransformFlagBitsKHR") int value) {
            VkDisplaySurfaceCreateInfoKHR.ntransform(this.address(), value);
            return this;
        }

        public Buffer globalAlpha(float value) {
            VkDisplaySurfaceCreateInfoKHR.nglobalAlpha(this.address(), value);
            return this;
        }

        public Buffer alphaMode(@NativeType(value="VkDisplayPlaneAlphaFlagBitsKHR") int value) {
            VkDisplaySurfaceCreateInfoKHR.nalphaMode(this.address(), value);
            return this;
        }

        public Buffer imageExtent(VkExtent2D value) {
            VkDisplaySurfaceCreateInfoKHR.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

