/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_entry_point")
public class SpvcEntryPoint
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXECUTION_MODEL;
    public static final int NAME;

    public SpvcEntryPoint(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcEntryPoint.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SpvExecutionModel")
    public int execution_model() {
        return SpvcEntryPoint.nexecution_model(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer name() {
        return SpvcEntryPoint.nname(this.address());
    }

    @NativeType(value="char const *")
    public String nameString() {
        return SpvcEntryPoint.nnameString(this.address());
    }

    public SpvcEntryPoint execution_model(@NativeType(value="SpvExecutionModel") int value) {
        SpvcEntryPoint.nexecution_model(this.address(), value);
        return this;
    }

    public SpvcEntryPoint name(@NativeType(value="char const *") ByteBuffer value) {
        SpvcEntryPoint.nname(this.address(), value);
        return this;
    }

    public SpvcEntryPoint set(int execution_model, ByteBuffer name) {
        this.execution_model(execution_model);
        this.name(name);
        return this;
    }

    public SpvcEntryPoint set(SpvcEntryPoint src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcEntryPoint malloc() {
        return (SpvcEntryPoint)SpvcEntryPoint.wrap(SpvcEntryPoint.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static SpvcEntryPoint calloc() {
        return (SpvcEntryPoint)SpvcEntryPoint.wrap(SpvcEntryPoint.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static SpvcEntryPoint create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (SpvcEntryPoint)SpvcEntryPoint.wrap(SpvcEntryPoint.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static SpvcEntryPoint create(long address) {
        return (SpvcEntryPoint)SpvcEntryPoint.wrap(SpvcEntryPoint.class, (long)address);
    }

    @Nullable
    public static SpvcEntryPoint createSafe(long address) {
        return address == 0L ? null : (SpvcEntryPoint)SpvcEntryPoint.wrap(SpvcEntryPoint.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)SpvcEntryPoint.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)SpvcEntryPoint.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)SpvcEntryPoint.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcEntryPoint.__create((int)capacity, (int)SIZEOF);
        return (Buffer)SpvcEntryPoint.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)SpvcEntryPoint.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)SpvcEntryPoint.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static SpvcEntryPoint malloc(MemoryStack stack) {
        return (SpvcEntryPoint)SpvcEntryPoint.wrap(SpvcEntryPoint.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcEntryPoint calloc(MemoryStack stack) {
        return (SpvcEntryPoint)SpvcEntryPoint.wrap(SpvcEntryPoint.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)SpvcEntryPoint.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)SpvcEntryPoint.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nexecution_model(long struct) {
        return UNSAFE.getInt(null, struct + (long)EXECUTION_MODEL);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static void nexecution_model(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EXECUTION_MODEL, value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)NAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    static {
        Struct.Layout layout = SpvcEntryPoint.__struct((Struct.Member[])new Struct.Member[]{SpvcEntryPoint.__member((int)4), SpvcEntryPoint.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXECUTION_MODEL = layout.offsetof(0);
        NAME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SpvcEntryPoint, Buffer>
    implements NativeResource {
        private static final SpvcEntryPoint ELEMENT_FACTORY = SpvcEntryPoint.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SpvcEntryPoint getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SpvExecutionModel")
        public int execution_model() {
            return SpvcEntryPoint.nexecution_model(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer name() {
            return SpvcEntryPoint.nname(this.address());
        }

        @NativeType(value="char const *")
        public String nameString() {
            return SpvcEntryPoint.nnameString(this.address());
        }

        public Buffer execution_model(@NativeType(value="SpvExecutionModel") int value) {
            SpvcEntryPoint.nexecution_model(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="char const *") ByteBuffer value) {
            SpvcEntryPoint.nname(this.address(), value);
            return this;
        }
    }
}

