/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;

public class ListGroupsRequest
extends AbstractRequest {
    private final ListGroupsRequestData data;

    public ListGroupsRequest(ListGroupsRequestData data, short version) {
        super(ApiKeys.LIST_GROUPS, version);
        this.data = data;
    }

    @Override
    public ListGroupsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ListGroupsResponseData listGroupsResponseData = new ListGroupsResponseData().setGroups(Collections.emptyList()).setErrorCode(Errors.forException(e).code());
        if (this.version() >= 1) {
            listGroupsResponseData.setThrottleTimeMs(throttleTimeMs);
        }
        return new ListGroupsResponse(listGroupsResponseData);
    }

    public static ListGroupsRequest parse(ByteBuffer buffer, short version) {
        return new ListGroupsRequest(new ListGroupsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public ListGroupsRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<ListGroupsRequest> {
        private final ListGroupsRequestData data;

        public Builder(ListGroupsRequestData data) {
            super(ApiKeys.LIST_GROUPS);
            this.data = data;
        }

        @Override
        public ListGroupsRequest build(short version) {
            if (!this.data.statesFilter().isEmpty() && version < 4) {
                throw new UnsupportedVersionException("The broker only supports ListGroups v" + version + ", but we need v4 or newer to request groups by states.");
            }
            if (!this.data.typesFilter().isEmpty() && version < 5) {
                throw new UnsupportedVersionException("The broker only supports ListGroups v" + version + ", but we need v5 or newer to request groups by type.");
            }
            return new ListGroupsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

