/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigTransformerResult;
import org.apache.kafka.common.config.provider.ConfigProvider;

public class ConfigTransformer {
    public static final Pattern DEFAULT_PATTERN = Pattern.compile("\\$\\{([^}]*?):(([^}]*?):)?([^}]*?)\\}");
    private static final String EMPTY_PATH = "";
    private final Map<String, ConfigProvider> configProviders;

    public ConfigTransformer(Map<String, ConfigProvider> configProviders) {
        this.configProviders = configProviders;
    }

    public ConfigTransformerResult transform(Map<String, String> configs) {
        Map keysByPath;
        HashMap<String, Map> keysByProvider = new HashMap<String, Map>();
        HashMap<String, Map<String, Map<String, String>>> lookupsByProvider = new HashMap<String, Map<String, Map<String, String>>>();
        for (Map.Entry<String, String> config : configs.entrySet()) {
            if (config.getValue() == null) continue;
            List<ConfigVariable> list = ConfigTransformer.getVars(config.getValue(), DEFAULT_PATTERN);
            for (ConfigVariable configVar : list) {
                keysByPath = keysByProvider.computeIfAbsent(configVar.providerName, k -> new HashMap());
                Set keys = keysByPath.computeIfAbsent(configVar.path, k -> new HashSet());
                keys.add(configVar.variable);
            }
        }
        HashMap<String, Long> ttls = new HashMap<String, Long>();
        for (Map.Entry entry : keysByProvider.entrySet()) {
            String providerName = (String)entry.getKey();
            ConfigProvider provider = this.configProviders.get(providerName);
            keysByPath = (Map)entry.getValue();
            if (provider == null || keysByPath == null) continue;
            for (Map.Entry pathWithKeys : keysByPath.entrySet()) {
                String path = (String)pathWithKeys.getKey();
                HashSet<String> keys = new HashSet<String>((Collection)pathWithKeys.getValue());
                ConfigData configData = provider.get(path, keys);
                Map<String, String> data = configData.data();
                Long ttl = configData.ttl();
                if (ttl != null && ttl >= 0L) {
                    ttls.put(path, ttl);
                }
                Map keyValuesByPath = lookupsByProvider.computeIfAbsent(providerName, k -> new HashMap());
                keyValuesByPath.put(path, data);
            }
        }
        HashMap<String, String> data = new HashMap<String, String>(configs);
        for (Map.Entry<String, String> config : configs.entrySet()) {
            data.put(config.getKey(), ConfigTransformer.replace(lookupsByProvider, config.getValue(), DEFAULT_PATTERN));
        }
        return new ConfigTransformerResult(data, ttls);
    }

    private static List<ConfigVariable> getVars(String value, Pattern pattern) {
        ArrayList<ConfigVariable> configVars = new ArrayList<ConfigVariable>();
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            configVars.add(new ConfigVariable(matcher));
        }
        return configVars;
    }

    private static String replace(Map<String, Map<String, Map<String, String>>> lookupsByProvider, String value, Pattern pattern) {
        if (value == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(value);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            ConfigVariable configVar = new ConfigVariable(matcher);
            Map<String, Map<String, String>> lookupsByPath = lookupsByProvider.get(configVar.providerName);
            if (lookupsByPath == null) continue;
            Map<String, String> keyValues = lookupsByPath.get(configVar.path);
            String replacement = keyValues.get(configVar.variable);
            builder.append(value, i, matcher.start());
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(value, i, value.length());
        return builder.toString();
    }

    private static class ConfigVariable {
        final String providerName;
        final String path;
        final String variable;

        ConfigVariable(Matcher matcher) {
            this.providerName = matcher.group(1);
            this.path = matcher.group(3) != null ? matcher.group(3) : ConfigTransformer.EMPTY_PATH;
            this.variable = matcher.group(4);
        }

        public String toString() {
            return "(" + this.providerName + ":" + (this.path != null ? this.path + ":" : ConfigTransformer.EMPTY_PATH) + this.variable + ")";
        }
    }
}

