/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class FetchCommittedOffsetsEvent
extends CompletableApplicationEvent<Map<TopicPartition, OffsetAndMetadata>> {
    private final Set<TopicPartition> partitions;

    public FetchCommittedOffsetsEvent(Set<TopicPartition> partitions, long deadlineMs) {
        super(ApplicationEvent.Type.FETCH_COMMITTED_OFFSETS, deadlineMs);
        this.partitions = Collections.unmodifiableSet(partitions);
    }

    public Set<TopicPartition> partitions() {
        return this.partitions;
    }

    @Override
    public String toStringBase() {
        return super.toStringBase() + ", partitions=" + this.partitions;
    }
}

