/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.AbstractConnectionOrientedTransportMapping;
import org.snmp4j.transport.AbstractServerSocket;
import org.snmp4j.transport.AbstractSocketEntry;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.util.WorkerTask;

public abstract class AbstractTransportServerThread<A extends Address, S extends AbstractSocketEntry<A>>
implements WorkerTask {
    private static final LogAdapter logger = LogFactory.getLogger(AbstractTransportServerThread.class);
    protected final AbstractConnectionOrientedTransportMapping<A, S> transportMapping;
    protected final A serverAddress;
    protected volatile boolean stop = false;
    protected Selector selector;
    protected final LinkedList<S> pending = new LinkedList();
    protected Throwable lastError = null;
    protected ServerSocketChannel ssc;

    public AbstractTransportServerThread(AbstractConnectionOrientedTransportMapping<A, S> transportMapping, A serverAddress) throws IOException {
        this.transportMapping = transportMapping;
        this.serverAddress = serverAddress;
        this.selector = Selector.open();
    }

    protected void connectSocketToSendMessage(A address, byte[] message, SocketChannel socketChannel, S entry, Map<A, S> sockets) throws ClosedChannelException {
        AbstractSocketEntry prevSocketEntry = (AbstractSocketEntry)sockets.putIfAbsent(address, entry);
        if (prevSocketEntry != null) {
            if (prevSocketEntry.getSocketChannel().isConnected()) {
                entry = prevSocketEntry;
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Concurrent connection attempt detected, canceling this one to " + String.valueOf(address))));
                }
                ((AbstractSocketEntry)entry).addMessage(message);
                this.closeRedundantSocketChannelIfNeeded(address, socketChannel, prevSocketEntry, true);
            } else {
                ((AbstractSocketEntry)entry).insertMessages(prevSocketEntry.getMessages());
                sockets.put(address, entry);
                this.closeRedundantSocketChannelIfNeeded(address, socketChannel, prevSocketEntry, false);
            }
        }
        this.queueNewMessage(entry);
        logger.debug((Serializable)((Object)("Trying to connect to " + String.valueOf(address))));
    }

    private void closeRedundantSocketChannelIfNeeded(A address, SocketChannel socketChannel, S prevSocketEntry, boolean closeNew) {
        if (socketChannel != ((AbstractSocketEntry)prevSocketEntry).getSocketChannel()) {
            try {
                if (closeNew) {
                    socketChannel.close();
                } else {
                    ((AbstractSocketEntry)prevSocketEntry).getSocketChannel().close();
                }
            }
            catch (IOException iox) {
                logger.error("Failed to close redundantly opened socket for '" + String.valueOf(address) + "', with " + iox.getMessage(), iox);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNewMessage(S entry) throws ClosedChannelException {
        LinkedList<S> linkedList = this.pending;
        synchronized (linkedList) {
            this.pending.add(entry);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPending() {
        LinkedList<S> linkedList = this.pending;
        synchronized (linkedList) {
            int i = 0;
            while (i < this.pending.size()) {
                block17: {
                    try {
                        TransportStateEvent e;
                        AbstractSocketEntry entry = (AbstractSocketEntry)this.pending.get(i);
                        try {
                            if (entry.getSocketChannel().isConnected()) {
                                if (entry.hasMessage() && entry.isHandshakeFinished()) {
                                    entry.addRegistration(this.selector, 4);
                                }
                                break block17;
                            }
                            if (entry.getSocketChannel().isOpen()) {
                                entry.addRegistration(this.selector, 8);
                                break block17;
                            }
                            if (entry.hasMessage()) break block17;
                            this.pending.remove(entry);
                            --i;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Serializable)((Object)("Removed closed socket entry without pending messages: " + String.valueOf(entry))));
                            }
                        }
                        catch (CancelledKeyException ckex) {
                            logger.warn(ckex);
                            this.pending.remove(entry);
                            --i;
                            try {
                                entry.getSocketChannel().close();
                                e = new TransportStateEvent((AbstractTransportMapping<?>)this.transportMapping, (Address)entry.getPeerAddress(), 4, null);
                                this.transportMapping.fireConnectionStateChanged(e);
                            }
                            catch (IOException ex) {
                                logger.error(ex);
                                ex.printStackTrace();
                            }
                        }
                        catch (IOException iox) {
                            logger.error(iox);
                            iox.printStackTrace();
                            this.pending.remove(entry);
                            --i;
                            try {
                                entry.getSocketChannel().close();
                                e = new TransportStateEvent((AbstractTransportMapping<?>)this.transportMapping, (Address)entry.getPeerAddress(), 4, iox);
                                this.transportMapping.fireConnectionStateChanged(e);
                            }
                            catch (IOException ex) {
                                logger.error(ex);
                                ex.printStackTrace();
                            }
                            this.lastError = iox;
                            if (SNMP4JSettings.isForwardRuntimeExceptions()) {
                                throw new RuntimeException(iox);
                            }
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            return;
        }
    }

    protected abstract S createSocketEntry(A var1, SocketChannel var2, boolean var3, TransportStateReference var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(A address, byte[] message, TransportStateReference tmStateReference, Map<A, S> sockets) throws IOException {
        Object object;
        AbstractInterruptibleChannel sc = null;
        AbstractSocketEntry<Object> entry = (AbstractSocketEntry)sockets.get(address);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Looking up connection for destination '" + String.valueOf(address) + "' returned: " + String.valueOf(entry))));
            logger.debug((Serializable)((Object)sockets.toString()));
        }
        if (entry != null) {
            object = entry;
            synchronized (object) {
                entry.used();
                sc = entry.getSocketChannel();
            }
        }
        if (sc == null || !sc.isOpen() || !((SocketChannel)sc).isConnected()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Socket for address '" + String.valueOf(address) + "' is closed, opening it...")));
            }
            object = this.pending;
            synchronized (object) {
                this.pending.remove(entry);
            }
            try {
                SocketAddress targetAddress = address.getSocketAddress();
                if (sc == null || !sc.isOpen()) {
                    sc = this.openSocketChannel(address.getFamily());
                    ((AbstractSelectableChannel)sc).configureBlocking(false);
                    ((SocketChannel)sc).connect(targetAddress);
                } else {
                    ((AbstractSelectableChannel)sc).configureBlocking(false);
                    if (!((SocketChannel)sc).isConnectionPending()) {
                        ((SocketChannel)sc).connect(targetAddress);
                    }
                }
                entry = this.createSocketEntry(address, (SocketChannel)sc, true, tmStateReference);
                if (entry != null) {
                    entry.addMessage(message);
                    this.connectSocketToSendMessage(address, message, (SocketChannel)sc, entry, sockets);
                }
                logger.error((Serializable)((Object)("Socket channel not accepted and message not sent: " + String.valueOf(sc) + " from " + String.valueOf(address))));
            }
            catch (IOException iox) {
                logger.error(iox);
                iox.printStackTrace();
                throw iox;
            }
        } else {
            entry.addMessage(message);
            logger.debug((Serializable)((Object)"Waking up selector for new message"));
            this.queueNewMessage(entry);
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    protected abstract SocketChannel openSocketChannel(ProtocolFamily var1) throws IOException;

    @Override
    public abstract void run();

    protected abstract boolean readMessage(SelectionKey var1, SocketChannel var2, A var3, S var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doServer(Map<A, S> sockets) {
        try {
            while (!this.stop) {
                try {
                    this.processQueues();
                    this.selector.select();
                    if (this.stop) break;
                    Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                    Iterator<SelectionKey> it = readyKeys.iterator();
                    while (it.hasNext()) {
                        try {
                            TransportStateEvent e;
                            AbstractSocketEntry entry = null;
                            SelectionKey sk = it.next();
                            it.remove();
                            SocketChannel readChannel = null;
                            Address incomingAddress = null;
                            if (sk.isAcceptable()) {
                                logger.debug((Serializable)((Object)"Key is acceptable"));
                                ServerSocketChannel nextReady = (ServerSocketChannel)sk.channel();
                                readChannel = nextReady.accept();
                                readChannel.configureBlocking(false);
                                incomingAddress = (Address)this.createIncomingAddress(readChannel);
                                entry = (AbstractSocketEntry)this.createSocketEntry(incomingAddress, readChannel, false, null);
                                if (entry == null) continue;
                                entry.addRegistration(this.selector, 1);
                                sockets.put(incomingAddress, entry);
                                this.transportMapping.timeoutSocket(entry);
                                e = new TransportStateEvent(this.transportMapping, incomingAddress, 1, null);
                                this.transportMapping.fireConnectionStateChanged(e);
                                if (e.isCancelled()) {
                                    logger.warn((Serializable)((Object)"Incoming connection cancelled"));
                                    readChannel.close();
                                    this.removeSocketEntry(incomingAddress);
                                    readChannel = null;
                                }
                            } else if (sk.isConnectable()) {
                                logger.debug((Serializable)((Object)"Key is connectable"));
                                this.connectChannel(sk, incomingAddress);
                            } else {
                                if (sk.isWritable()) {
                                    logger.debug((Serializable)((Object)"Key is writable"));
                                    incomingAddress = this.writeData(sk, incomingAddress);
                                }
                                if (sk.isReadable()) {
                                    logger.debug((Serializable)((Object)"Key is readable"));
                                    readChannel = (SocketChannel)sk.channel();
                                    incomingAddress = (Address)this.createIncomingAddress(readChannel);
                                }
                            }
                            if (!sk.isReadable() || readChannel == null) continue;
                            logger.debug((Serializable)((Object)"Key is reading"));
                            try {
                                int busyLoops;
                                if (this.readMessage(sk, readChannel, incomingAddress, entry) || entry == null || this.transportMapping.getMaxBusyLoops() <= 0 || (busyLoops = entry.nextBusyLoop()) <= this.transportMapping.getMaxBusyLoops()) continue;
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Serializable)((Object)("After " + busyLoops + " read key has been removed: " + String.valueOf(entry))));
                                }
                                entry.removeRegistration(this.selector, 1);
                                entry.resetBusyLoops();
                            }
                            catch (IOException iox) {
                                logger.warn(iox);
                                this.transportMapping.cancelNonServerSelectionKey(sk);
                                readChannel.close();
                                this.fireIncrementCounterSessionClose();
                                this.removeSocketEntry(incomingAddress);
                                e = new TransportStateEvent(this.transportMapping, incomingAddress, 2, iox);
                                this.transportMapping.fireConnectionStateChanged(e);
                            }
                        }
                        catch (CancelledKeyException ckex) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Serializable)((Object)"Selection key cancelled, skipping it"));
                        }
                    }
                }
                catch (NullPointerException npex) {
                    npex.printStackTrace();
                    logger.warn((Serializable)((Object)"NullPointerException within select()?"));
                    this.stop = true;
                }
                if (this.stop) continue;
                this.processPending();
            }
            if (this.ssc != null) {
                this.ssc.close();
                logger.debug((Serializable)((Object)("Closed server socket channel " + String.valueOf(this.ssc))));
            }
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (IOException iox) {
            logger.error(iox);
            this.lastError = iox;
        }
        if (!this.stop) {
            this.stop = true;
            AbstractConnectionOrientedTransportMapping<A, S> abstractConnectionOrientedTransportMapping = this.transportMapping;
            synchronized (abstractConnectionOrientedTransportMapping) {
                try {
                    this.transportMapping.close();
                }
                catch (IOException e) {
                    this.lastError = e;
                    logger.warn(e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Worker task finished: " + this.getClass().getName())));
        }
    }

    protected void fireIncrementCounterSessionClose() {
    }

    protected abstract void processQueues();

    public abstract S removeSocketEntry(A var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectChannel(SelectionKey sk, A incomingAddress) {
        block10: {
            AbstractSocketEntry entry = (AbstractSocketEntry)sk.attachment();
            try {
                SocketChannel sc = (SocketChannel)sk.channel();
                if (!sc.isConnected()) {
                    if (sc.finishConnect()) {
                        sc.configureBlocking(false);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Connected to " + String.valueOf(entry.getPeerAddress()))));
                        }
                        this.transportMapping.timeoutSocket(entry);
                        entry.removeRegistration(this.selector, 8);
                        entry.addRegistration(this.selector, 4);
                    } else {
                        entry = null;
                    }
                }
                if (entry != null) {
                    A addr = incomingAddress == null ? entry.getPeerAddress() : incomingAddress;
                    logger.debug((Serializable)((Object)("Fire connected event for " + String.valueOf(addr))));
                    TransportStateEvent e = new TransportStateEvent((AbstractTransportMapping<?>)this.transportMapping, (Address)addr, 1, null);
                    this.transportMapping.fireConnectionStateChanged(e);
                }
            }
            catch (IOException iox) {
                logger.warn(iox);
                sk.cancel();
                this.closeChannel(sk.channel());
                if (entry == null) break block10;
                LinkedList<S> linkedList = this.pending;
                synchronized (linkedList) {
                    this.pending.remove(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected A writeData(SelectionKey sk, A incomingAddress) {
        AbstractSocketEntry entry = (AbstractSocketEntry)sk.attachment();
        try {
            SocketChannel sc = (SocketChannel)sk.channel();
            incomingAddress = this.createIncomingAddress(sc);
            if (entry != null && !entry.hasMessage()) {
                LinkedList<S> linkedList = this.pending;
                synchronized (linkedList) {
                    this.pending.remove(entry);
                    entry.removeRegistration(this.selector, 4);
                }
            }
            if (entry != null) {
                this.writeMessage(entry, sc);
            } else {
                sk.cancel();
                logger.warn((Serializable)((Object)("Key was writable for incoming address " + String.valueOf(incomingAddress) + " but SocketEntry is null, key is canceled")));
            }
        }
        catch (IOException iox) {
            logger.warn(iox);
            this.closeChannel(sk.channel());
            this.removeSocketEntry(incomingAddress);
            TransportStateEvent e = new TransportStateEvent((AbstractTransportMapping<?>)this.transportMapping, (Address)incomingAddress, 2, iox);
            this.transportMapping.fireConnectionStateChanged(e);
        }
        return incomingAddress;
    }

    protected abstract A createIncomingAddress(SocketChannel var1) throws IOException;

    protected void closeChannel(SelectableChannel channel) {
        try {
            channel.close();
        }
        catch (IOException channelCloseException) {
            logger.warn(channelCloseException);
        }
    }

    protected void writeMessage(S entry, SocketChannel sc) throws IOException {
        byte[] message = ((AbstractSocketEntry)entry).nextMessage();
        if (message != null) {
            ((AbstractSocketEntry)entry).addRegistration(this.selector, 1);
            ByteBuffer buffer = ByteBuffer.wrap(message);
            sc.write(buffer);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Sent message with length " + message.length + " to " + String.valueOf(((AbstractServerSocket)entry).getPeerAddress()) + ": " + new OctetString(message).toHexString())));
            }
        } else {
            ((AbstractSocketEntry)entry).removeRegistration(this.selector, 4);
            if (((AbstractSocketEntry)entry).hasMessage() && !((AbstractSocketEntry)entry).isRegistered(4)) {
                ((AbstractSocketEntry)entry).addRegistration(this.selector, 4);
                logger.debug((Serializable)((Object)"Waking up selector for write"));
                this.selector.wakeup();
            }
        }
    }

    public void close() {
        this.stop = true;
        WorkerTask st = this.transportMapping.getListenWorkerTask();
        if (st != null) {
            st.terminate();
        }
    }

    @Override
    public void terminate() {
        this.stop = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Terminated worker task: " + this.getClass().getName())));
        }
    }

    @Override
    public void join() {
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Joining worker task: " + this.getClass().getName())));
        }
    }

    @Override
    public void interrupt() {
        this.stop = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Interrupting worker task: " + this.getClass().getName())));
        }
        this.selector.wakeup();
    }
}

