/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.util.EventObject;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.PDU;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.StateReference;
import org.snmp4j.security.SecurityStateReference;
import org.snmp4j.security.TsmSecurityStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class CommandResponderEvent<A extends Address>
extends EventObject {
    private static final long serialVersionUID = 1969372060103366769L;
    private int securityModel;
    private int securityLevel;
    private int maxSizeResponsePDU;
    private PduHandle pduHandle;
    private StateReference<A> stateReference;
    private PDU pdu;
    private int messageProcessingModel;
    private byte[] securityName;
    private boolean processed;
    private A peerAddress;
    private transient TransportMapping<? super A> transportMapping;
    private TransportStateReference tmStateReference;

    public CommandResponderEvent(MessageDispatcher messageDispatcher, TransportMapping<? super A> transportMapping, A sourceAddress, int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PduHandle pduHandle, PDU pdu, int maxSizeResponseScopedPDU, StateReference<A> stateReference) {
        super(messageDispatcher);
        this.setTransportMapping(transportMapping);
        this.setMessageProcessingModel(messageProcessingModel);
        this.setSecurityModel(securityModel);
        this.setSecurityName(securityName);
        this.setSecurityLevel(securityLevel);
        this.setPduHandle(pduHandle);
        this.setPDU(pdu);
        this.setMaxSizeResponsePDU(maxSizeResponseScopedPDU);
        this.setStateReference(stateReference);
        this.setPeerAddress(sourceAddress);
    }

    public CommandResponderEvent(Object source, CommandResponderEvent<A> other) {
        super(source);
        this.setTransportMapping(other.transportMapping);
        this.setMessageProcessingModel(other.messageProcessingModel);
        this.setSecurityModel(other.securityModel);
        this.setSecurityName(other.securityName);
        this.setSecurityLevel(other.securityLevel);
        this.setPduHandle(other.pduHandle);
        this.setPDU(other.pdu);
        this.setMaxSizeResponsePDU(other.maxSizeResponsePDU);
        this.setStateReference(other.stateReference);
        this.setPeerAddress(other.getPeerAddress());
    }

    public MessageDispatcher getMessageDispatcher() {
        return (MessageDispatcher)super.getSource();
    }

    public int getSecurityModel() {
        return this.securityModel;
    }

    public void setSecurityModel(int securityModel) {
        this.securityModel = securityModel;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setMaxSizeResponsePDU(int maxSizeResponsePDU) {
        this.maxSizeResponsePDU = maxSizeResponsePDU;
    }

    public int getMaxSizeResponsePDU() {
        return this.maxSizeResponsePDU;
    }

    public void setPduHandle(PduHandle pduHandle) {
        this.pduHandle = pduHandle;
    }

    public PduHandle getPduHandle() {
        return this.pduHandle;
    }

    public void setStateReference(StateReference<A> stateReference) {
        this.stateReference = stateReference;
    }

    public StateReference<A> getStateReference() {
        return this.stateReference;
    }

    public void setPDU(PDU pdu) {
        this.pdu = pdu;
    }

    public PDU getPDU() {
        return this.pdu;
    }

    public void setMessageProcessingModel(int messageProcessingModel) {
        this.messageProcessingModel = messageProcessingModel;
    }

    public int getMessageProcessingModel() {
        return this.messageProcessingModel;
    }

    public void setSecurityName(byte[] securityName) {
        this.securityName = securityName;
    }

    public byte[] getSecurityName() {
        return this.securityName;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public A getPeerAddress() {
        return this.peerAddress;
    }

    public TransportMapping<? super A> getTransportMapping() {
        return this.transportMapping;
    }

    public void setPeerAddress(A peerAddress) {
        this.peerAddress = peerAddress;
    }

    protected void setTransportMapping(TransportMapping<? super A> transportMapping) {
        this.transportMapping = transportMapping;
    }

    public TransportStateReference getTmStateReference() {
        SecurityStateReference securityStateReference;
        StateReference<A> stateReference;
        if (this.tmStateReference == null && (stateReference = this.getStateReference()) != null && (securityStateReference = stateReference.getSecurityStateReference()) instanceof TsmSecurityStateReference) {
            return ((TsmSecurityStateReference)securityStateReference).getTmStateReference();
        }
        return this.tmStateReference;
    }

    public void setTmStateReference(TransportStateReference tmStateReference) {
        this.tmStateReference = tmStateReference;
    }

    @Override
    public String toString() {
        return "CommandResponderEvent[securityModel=" + this.securityModel + ", securityLevel=" + this.securityLevel + ", maxSizeResponsePDU=" + this.maxSizeResponsePDU + ", pduHandle=" + String.valueOf(this.pduHandle) + ", stateReference=" + String.valueOf(this.stateReference) + ", pdu=" + String.valueOf(this.pdu) + ", messageProcessingModel=" + this.messageProcessingModel + ", securityName=" + String.valueOf(new OctetString(this.securityName)) + ", processed=" + this.processed + ", peerAddress=" + String.valueOf(this.peerAddress) + ", transportMapping=" + String.valueOf(this.transportMapping) + ", tmStateReference=" + String.valueOf(this.tmStateReference) + "]";
    }
}

