/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.sort.Scan;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SortBufferRowSource
extends Scan
implements ScanControllerRowSource {
    SortBuffer sortBuffer = null;
    protected TransactionManager tran = null;
    private int maxFreeListSize;
    private boolean writingToDisk;
    private SortObserver sortObserver;

    SortBufferRowSource(SortBuffer sortBuffer, TransactionManager tran, SortObserver sortObserver, boolean writingToDisk, int maxFreeListSize) {
        this.sortBuffer = sortBuffer;
        this.tran = tran;
        this.sortObserver = sortObserver;
        this.writingToDisk = writingToDisk;
        this.maxFreeListSize = maxFreeListSize;
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() {
        if (this.sortBuffer == null) {
            return null;
        }
        DataValueDescriptor[] retval = this.sortBuffer.removeFirst();
        if (retval != null && this.writingToDisk) {
            this.sortObserver.addToFreeList(retval, this.maxFreeListSize);
        }
        return retval;
    }

    @Override
    public boolean needsRowLocation() {
        return false;
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return false;
    }

    @Override
    public boolean needsToClone() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rl) {
        SanityManager.THROWASSERT((String)"unexpected call to RowSource.rowLocation");
    }

    @Override
    public void offendingRowLocation(RowLocation rl, long containdId) throws StandardException {
        SanityManager.NOTREACHED();
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public void close() {
        if (this.sortBuffer != null) {
            this.sortBuffer.close();
            this.sortBuffer = null;
        }
        this.tran.closeMe(this);
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) {
        SanityManager.ASSERT((boolean)closeHeldScan, (String)"Sort scan should not be held open across commit.");
        this.close();
        return true;
    }

    @Override
    public void closeRowSource() {
        this.close();
    }

    @Override
    public boolean next() throws StandardException {
        throw StandardException.newException((String)"XSAS0.S", (Object[])new Object[0]);
    }

    @Override
    public void fetchWithoutQualify(DataValueDescriptor[] result) throws StandardException {
        throw StandardException.newException((String)"XSAS0.S", (Object[])new Object[0]);
    }

    @Override
    public void fetch(DataValueDescriptor[] result) throws StandardException {
        throw StandardException.newException((String)"XSAS0.S", (Object[])new Object[0]);
    }

    @Override
    public final boolean fetchNext(DataValueDescriptor[] row) throws StandardException {
        throw StandardException.newException((String)"XSAS0.S", (Object[])new Object[0]);
    }
}

