/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class SavepointNode
extends DDLStatementNode {
    private String savepointName;
    private int savepointStatementType;

    SavepointNode(String objectName, int savepointStatementType, ContextManager cm) throws StandardException {
        super(cm);
        this.savepointName = objectName;
        this.savepointStatementType = savepointStatementType;
        if (this.savepointStatementType > 3 || this.savepointStatementType < 1) {
            SanityManager.THROWASSERT((String)("Unexpected value for savepointStatementType = " + this.savepointStatementType + ". Expected value between 1-3"));
        }
    }

    @Override
    public String toString() {
        String tempString = "savepointName: \n" + this.savepointName + "\n";
        tempString = tempString + "savepointStatementType: \n" + this.savepointStatementType + "\n";
        return super.toString() + tempString;
    }

    @Override
    String statementToString() {
        if (this.savepointStatementType == 1) {
            return "SAVEPOINT";
        }
        if (this.savepointStatementType == 2) {
            return "ROLLBACK WORK TO SAVEPOINT";
        }
        return "RELEASE TO SAVEPOINT";
    }

    @Override
    public boolean needsSavepoint() {
        return false;
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSavepointConstantAction(this.savepointName, this.savepointStatementType);
    }
}

