/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.IgnoreFilter;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLModGeneratedColumnsStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasTableFunctionVisitor;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.NormalizeResultSetNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class InsertNode
extends DMLModGeneratedColumnsStatementNode {
    private ResultColumnList targetColumnList;
    private boolean deferred;
    public ValueNode checkConstraints;
    public boolean hasDeferrableCheckConstraints;
    public Properties targetProperties;
    public FKInfo fkInfo;
    protected boolean bulkInsert;
    private boolean bulkInsertReplace;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    public boolean autoincrementColumnSetToDEFAULT;

    InsertNode(QueryTreeNode targetName, ResultColumnList insertColumns, ResultSetNode queryExpression, MatchingClauseNode matchingClause, Properties targetProperties, OrderByList orderByList, ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause, ContextManager cm) {
        super(queryExpression, matchingClause, InsertNode.getStatementType(targetProperties), cm);
        this.setTarget(targetName);
        this.targetColumnList = insertColumns;
        this.targetProperties = targetProperties;
        this.orderByList = orderByList;
        this.offset = offset;
        this.fetchFirst = fetchFirst;
        this.hasJDBClimitClause = hasJDBClimitClause;
        this.getResultSetNode().setInsertSource();
    }

    @Override
    public String toString() {
        try {
            return (this.targetTableName != null ? this.targetTableName : this.targetVTI.getTableName()).toString() + "\n" + String.valueOf(this.targetProperties) + "\n" + super.toString();
        }
        catch (StandardException e) {
            return "tableName: <not_known>\n" + String.valueOf(this.targetProperties) + "\n" + super.toString();
        }
    }

    @Override
    String statementToString() {
        return "INSERT";
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.targetTableName != null) {
            this.printLabel(depth, "targetTableName: ");
            this.targetTableName.treePrint(depth + 1);
        }
        if (this.targetColumnList != null) {
            this.printLabel(depth, "targetColumnList: ");
            this.targetColumnList.treePrint(depth + 1);
        }
        if (this.orderByList != null) {
            this.printLabel(depth, "orderByList: ");
            this.orderByList.treePrint(depth + 1);
        }
        if (this.offset != null) {
            this.printLabel(depth, "offset:");
            this.offset.treePrint(depth + 1);
        }
        if (this.fetchFirst != null) {
            this.printLabel(depth, "fetch first/next:");
            this.fetchFirst.treePrint(depth + 1);
        }
    }

    @Override
    public void bindStatement() throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(0);
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        DataDictionary dataDictionary = this.getDataDictionary();
        super.bindResultSetsWithTables(dataDictionary);
        this.verifyTargetTable();
        if (this.targetProperties != null) {
            this.verifyTargetProperties(dataDictionary);
        }
        IgnoreFilter ignorePermissions = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignorePermissions);
        this.getResultColumnList();
        if (this.targetColumnList != null) {
            if (this.synonymTableName != null) {
                this.normalizeSynonymColumns(this.targetColumnList, this.targetTableName);
            }
            this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
            if (this.targetTableDescriptor != null) {
                this.targetColumnList.bindResultColumnsByName(this.targetTableDescriptor, this);
            } else {
                this.targetColumnList.bindResultColumnsByName(this.targetVTI.getResultColumns(), this.targetVTI, this);
            }
            this.getCompilerContext().popCurrentPrivType();
        }
        this.getCompilerContext().removePrivilegeFilter(ignorePermissions);
        SanityManager.ASSERT((fromList.size() == 0 ? 1 : 0) != 0, (String)("fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()"));
        boolean isTableConstructor = this.resultSet instanceof UnionNode && ((UnionNode)this.resultSet).tableConstructor() || this.resultSet instanceof RowResultSetNode;
        ResultColumnList tempRCL = this.resultSet.getResultColumns();
        boolean defaultsWereReplaced = false;
        for (int i = 0; i < tempRCL.size(); ++i) {
            ResultColumn rc = tempRCL.getResultColumn(i + 1);
            if (!rc.wasDefaultColumn()) continue;
            defaultsWereReplaced = true;
        }
        this.resultSet.replaceOrForbidDefaults(this.targetTableDescriptor, this.targetColumnList, isTableConstructor);
        super.bindExpressions();
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
            this.getCompilerContext().addRequiredTablePriv(this.targetTableDescriptor);
            this.getCompilerContext().popCurrentPrivType();
        }
        this.getCompilerContext().addPrivilegeFilter(ignorePermissions);
        if (this.targetColumnList != null) {
            if (this.resultSet.getResultColumns().visibleSize() > this.targetColumnList.size()) {
                throw StandardException.newException((String)"42802", (Object[])new Object[0]);
            }
            this.resultSet.bindUntypedNullsToResultColumns(this.targetColumnList);
            this.resultSet.setTableConstructorTypes(this.targetColumnList);
        } else {
            if (this.resultSet.getResultColumns().visibleSize() > this.resultColumnList.size()) {
                throw StandardException.newException((String)"42802", (Object[])new Object[0]);
            }
            this.resultSet.bindUntypedNullsToResultColumns(this.resultColumnList);
            this.resultSet.setTableConstructorTypes(this.resultColumnList);
        }
        this.resultSet.bindResultColumns(fromList);
        int resCols = this.resultSet.getResultColumns().visibleSize();
        DataDictionary dd = this.getDataDictionary();
        if (this.targetColumnList != null ? this.targetColumnList.size() != resCols : this.targetTableDescriptor != null && this.targetTableDescriptor.getNumberOfColumns() != resCols) {
            throw StandardException.newException((String)"42802", (Object[])new Object[0]);
        }
        boolean inOrder = true;
        int numTableColumns = this.resultColumnList.size();
        int[] colMap = new int[numTableColumns];
        for (int i = 0; i < colMap.length; ++i) {
            colMap[i] = -1;
        }
        if (this.targetColumnList != null) {
            int targetSize = this.targetColumnList.size();
            int index = 0;
            while (index < targetSize) {
                int position = ((ResultColumn)this.targetColumnList.elementAt(index)).getColumnDescriptor().getPosition();
                if (index != position - 1) {
                    inOrder = false;
                }
                colMap[position - 1] = index++;
            }
        } else {
            for (int position = 0; position < this.resultSet.getResultColumns().visibleSize(); ++position) {
                colMap[position] = position;
            }
        }
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.resultSet);
            super.bindExpressions();
            this.orderByList.bindOrderByColumns(this.resultSet);
        }
        InsertNode.bindOffsetFetch(this.offset, this.fetchFirst);
        this.resultSet = this.enhanceAndCheckForAutoincrement(this.resultSet, inOrder, colMap, defaultsWereReplaced);
        this.resultColumnList.checkStorableExpressions(this.resultSet.getResultColumns());
        if (!this.resultColumnList.columnTypesAndLengthsMatch(this.resultSet.getResultColumns())) {
            this.resultSet = new NormalizeResultSetNode(this.resultSet, this.resultColumnList, null, false, this.getContextManager());
        }
        if (this.targetTableDescriptor != null) {
            ResultColumnList sourceRCL = this.resultSet.getResultColumns();
            sourceRCL.copyResultColumnNames(this.resultColumnList);
            this.parseAndBindGenerationClauses(dataDictionary, this.targetTableDescriptor, sourceRCL, this.resultColumnList, false, null);
            boolean[] hasDCC = new boolean[]{false};
            this.checkConstraints = this.bindConstraints(dataDictionary, this.getOptimizerFactory(), this.targetTableDescriptor, null, sourceRCL, null, null, true, hasDCC);
            this.hasDeferrableCheckConstraints = hasDCC[0];
            if (this.resultSet.referencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
                if (this.bulkInsertReplace && this.resultSet.referencesTarget(this.targetTableDescriptor.getName(), true)) {
                    throw StandardException.newException((String)"42Y38", (Object[])new Object[]{this.targetTableDescriptor.getQualifiedName()});
                }
            }
            this.getAffectedIndexes(this.targetTableDescriptor);
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            this.autoincRowLocation = dd.computeAutoincRowLocations(tc, this.targetTableDescriptor);
        } else {
            this.deferred = VTIDeferModPolicy.deferIt(1, this.targetVTI, null, this.resultSet);
        }
        this.identitySequenceUUIDString = this.getUUIDofSequenceGenerator();
        this.getCompilerContext().removePrivilegeFilter(ignorePermissions);
        this.getCompilerContext().popCurrentPrivType();
    }

    ResultSetNode enhanceAndCheckForAutoincrement(ResultSetNode resultSet, boolean inOrder, int[] colMap, boolean defaultsWereReplaced) throws StandardException {
        if (!((resultSet = resultSet.enhanceRCLForInsert(this, inOrder, colMap)) instanceof UnionNode) || !((UnionNode)resultSet).tableConstructor()) {
            this.resultColumnList.forbidOverrides(resultSet.getResultColumns(), defaultsWereReplaced);
        }
        return resultSet;
    }

    @Override
    int getPrivType() {
        return 3;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        boolean returnValue = false;
        if (this.targetTableDescriptor != null) {
            returnValue = this.isSessionSchema(this.targetTableDescriptor.getSchemaDescriptor());
        }
        if (!returnValue) {
            returnValue = this.resultSet.referencesSessionSchema();
        }
        return returnValue;
    }

    private void verifyTargetProperties(DataDictionary dd) throws StandardException {
        String insertMode = this.targetProperties.getProperty("insertMode");
        if (insertMode != null) {
            String upperValue = StringUtil.SQLToUpperCase(insertMode);
            if (!upperValue.equals("BULKINSERT") && !upperValue.equals("REPLACE")) {
                throw StandardException.newException((String)"42X60", (Object[])new Object[]{insertMode, this.targetTableName});
            }
            if (!this.verifyBulkInsert(dd, upperValue)) {
                this.targetProperties.remove("insertMode");
            } else {
                int bulkFetch;
                String bulkFetchStr;
                this.bulkInsert = true;
                if (upperValue.equals("REPLACE")) {
                    this.bulkInsertReplace = true;
                }
                if ((bulkFetchStr = this.targetProperties.getProperty("bulkFetch")) != null && (bulkFetch = this.getIntProperty(bulkFetchStr, "bulkFetch")) <= 0) {
                    throw StandardException.newException((String)"42Y64", (Object[])new Object[]{String.valueOf(bulkFetch)});
                }
            }
        }
    }

    private boolean verifyBulkInsert(DataDictionary dd, String mode) throws StandardException {
        return true;
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        if (this.targetTableDescriptor != null) {
            long heapConglomId = this.targetTableDescriptor.getHeapConglomerateId();
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            int numIndexes = this.targetTableDescriptor != null ? this.indexConglomerateNumbers.length : 0;
            StaticCompiledOpenConglomInfo[] indexSCOCIs = new StaticCompiledOpenConglomInfo[numIndexes];
            for (int index = 0; index < numIndexes; ++index) {
                indexSCOCIs[index] = tc.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[index]);
            }
            if (this.bulkInsert || this.targetTableDescriptor.getLockGranularity() == 'T') {
                this.lockMode = 7;
            }
            return this.getGenericConstantActionFactory().getInsertConstantAction(this.targetTableDescriptor, heapConglomId, tc.getStaticCompiledConglomInfo(heapConglomId), this.indicesToMaintain, this.indexConglomerateNumbers, indexSCOCIs, this.indexNames, this.deferred, false, this.hasDeferrableCheckConstraints, this.targetTableDescriptor.getUUID(), this.lockMode, null, null, this.targetProperties, this.getFKInfo(), this.getTriggerInfo(), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.getIndexedCols(), null, null, null, this.resultSet.isOneRowResultSet(), this.autoincRowLocation, this.inMatchingClause(), this.identitySequenceUUIDString, this.autoincrementColumnSetToDEFAULT);
        }
        return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(1, this.deferred);
    }

    boolean[] getIndexedCols() throws StandardException {
        boolean[] indexedCols = new boolean[this.targetTableDescriptor.getNumberOfColumns()];
        for (int index = 0; index < this.indicesToMaintain.length; ++index) {
            int[] colIds = this.indicesToMaintain[index].getIndexDescriptor().baseColumnPositions();
            for (int index2 = 0; index2 < colIds.length; ++index2) {
                indexedCols[colIds[index2] - 1] = true;
            }
        }
        return indexedCols;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        this.resultSet.pushQueryExpressionSuffix();
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.resultSet.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        this.resultSet.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        super.optimizeStatement();
        HasTableFunctionVisitor tableFunctionVisitor = new HasTableFunctionVisitor();
        this.accept(tableFunctionVisitor);
        if (tableFunctionVisitor.hasNode() && !this.isSessionSchema(this.targetTableDescriptor.getSchemaDescriptor())) {
            this.requestBulkInsert();
        }
    }

    private void requestBulkInsert() {
        if (this.targetProperties == null) {
            this.targetProperties = new Properties();
        }
        String key = "insertMode";
        String value = "bulkInsert";
        if (this.targetProperties.getProperty(key) == null) {
            this.targetProperties.put(key, value);
        }
        this.bulkInsert = true;
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCodeForTemporaryTable(acb);
        this.generateParameterValueSet(acb);
        if (this.targetTableDescriptor != null) {
            acb.pushGetResultSetFactoryExpression(mb);
            if (this.inMatchingClause()) {
                this.matchingClause.generateResultSetField(acb, mb);
            } else {
                this.resultSet.generate(acb, mb);
            }
            this.generateGenerationClauses(this.resultColumnList, this.resultSet.getResultSetNumber(), false, acb, mb);
            this.generateCheckConstraints(this.checkConstraints, acb, mb);
            if (this.bulkInsert) {
                ColumnDescriptorList cdl = this.targetTableDescriptor.getColumnDescriptorList();
                ExecRowBuilder builder = new ExecRowBuilder(cdl.size(), false);
                for (int i = 0; i < cdl.size(); ++i) {
                    ColumnDescriptor cd = (ColumnDescriptor)cdl.get(i);
                    builder.setColumn(i + 1, cd.getType());
                }
                mb.push(acb.addItem(builder));
            } else {
                mb.push(-1);
            }
            if (this.targetTableName.getSchemaName() == null) {
                mb.pushNull("java.lang.String");
            } else {
                mb.push(this.targetTableName.getSchemaName());
            }
            mb.push(this.targetTableName.getTableName());
            mb.callMethod((short)185, null, "getInsertResultSet", "org.apache.derby.iapi.sql.ResultSet", 6);
        } else {
            this.targetVTI.assignCostEstimate(this.resultSet.getNewCostEstimate());
            acb.pushGetResultSetFactoryExpression(mb);
            this.resultSet.generate(acb, mb);
            this.targetVTI.generate(acb, mb);
            mb.callMethod((short)185, null, "getInsertVTIResultSet", "org.apache.derby.iapi.sql.ResultSet", 2);
        }
    }

    @Override
    protected final int getStatementType() {
        return 1;
    }

    static int getStatementType(Properties targetProperties) {
        String upperValue;
        String insertMode;
        int retval = 1;
        String string = insertMode = targetProperties == null ? null : targetProperties.getProperty("insertMode");
        if (insertMode != null && (upperValue = StringUtil.SQLToUpperCase(insertMode)).equals("REPLACE")) {
            retval = 2;
        }
        return retval;
    }

    private void getAffectedIndexes(TableDescriptor td) throws StandardException {
        IndexLister indexLister = td.getIndexLister();
        this.indicesToMaintain = indexLister.getDistinctIndexRowGenerators();
        this.indexConglomerateNumbers = indexLister.getDistinctIndexConglomerateNumbers();
        this.indexNames = indexLister.getDistinctIndexNames();
        ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
        CompilerContext cc = this.getCompilerContext();
        for (int index = 0; index < cds.length; ++index) {
            cc.createDependency(cds[index]);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.targetColumnList != null) {
            this.targetColumnList.accept(v);
        }
    }
}

